/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.model;

import com.google.common.base.CaseFormat;
import it.hurts.metallurgy_reforged.material.Metal;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

@MethodsReturnNonnullByDefault
public class AlloySample {
    private final Metal metal;
    private ItemStack fallbackStack = ItemStack.field_190927_a;
    private final int amount;
    private final boolean isOriginal;
    private float xp = -1.0f;

    public AlloySample(Metal metal, int amount, float xp) {
        this.metal = metal;
        this.amount = amount;
        this.xp = xp;
        this.isOriginal = true;
    }

    public AlloySample(Metal metal, int amount) {
        this(metal, amount, -1.0f);
    }

    public AlloySample(ItemStack oreDictStack, int amount) {
        this.metal = null;
        this.fallbackStack = oreDictStack;
        this.amount = amount;
        this.isOriginal = false;
    }

    @Nullable
    public Metal getMetal() {
        return this.metal;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean isOriginal() {
        return this.isOriginal;
    }

    public float getXp() {
        return this.xp;
    }

    public boolean hasXp() {
        return this.xp != -1.0f;
    }

    public AlloySample setXp(float xp) {
        this.xp = xp;
        return this;
    }

    public boolean hasFallenBack() {
        return !this.fallbackStack.func_190926_b();
    }

    public List<ItemStack> getOredictedStacks() {
        if (this.hasFallenBack()) {
            return Collections.singletonList(this.fallbackStack);
        }
        return OreDictionary.getOres((String)("ingot" + CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.metal.toString())));
    }

    public ItemStack getStack() {
        if (this.hasFallenBack() || this.metal == null) {
            return this.fallbackStack;
        }
        return new ItemStack((Item)this.metal.getIngot(), this.amount);
    }

    public ItemStack getFallbackStack() {
        return this.fallbackStack;
    }
}

