/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.recipe;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.model.AlloySample;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class AlloyerRecipes {
    private static final AlloyerRecipes INSTANCE = new AlloyerRecipes();
    private final Table<AlloySample, AlloySample, AlloySample> alloyingList = HashBasedTable.create();

    public static AlloyerRecipes getInstance() {
        return INSTANCE;
    }

    private AlloyerRecipes() {
        this.addAlloyRecipe(new AlloySample(ModMetals.COPPER, 3), new AlloySample(ModMetals.TIN, 1), new AlloySample(ModMetals.BRONZE, 4, 1.75f));
        this.addAlloyRecipe(new AlloySample(ModMetals.SHADOW_IRON, 2), new AlloySample(ModMetals.LEMURITE, 1), new AlloySample(ModMetals.SHADOW_STEEL, 3, 1.5f));
        this.addAlloyRecipe(new AlloySample(ModMetals.ALDUORITE, 1), new AlloySample(ModMetals.CERUCLASE, 1), new AlloySample(ModMetals.INOLASHITE, 2, 1.25f));
        this.addAlloyRecipe(new AlloySample(ModMetals.COPPER, 3), new AlloySample(ModMetals.ZINC, 1), new AlloySample(ModMetals.BRASS, 4, 1.75f));
        this.addAlloyRecipe(new AlloySample(ModMetals.DEEP_IRON, 3), new AlloySample(ModMetals.INFUSCOLIUM, 1), new AlloySample(ModMetals.BLACK_STEEL, 4, 1.75f));
        this.addAlloyRecipe(new AlloySample(new ItemStack(Items.field_151042_j), 1), new AlloySample(ModMetals.MANGANESE, 2), new AlloySample(ModMetals.STEEL, 2, 1.5f));
        this.addAlloyRecipe(new AlloySample(new ItemStack(Items.field_151042_j), 1), new AlloySample(ModMetals.BRONZE, 2), new AlloySample(ModMetals.DAMASCUS_STEEL, 3, 1.5f));
        this.addAlloyRecipe(new AlloySample(ModMetals.SILVER, 1), new AlloySample(new ItemStack(Items.field_151043_k), 1), new AlloySample(ModMetals.ELECTRUM, 2, 1.25f));
        this.addAlloyRecipe(new AlloySample(ModMetals.ORICHALCUM, 1), new AlloySample(ModMetals.PLATINUM, 1), new AlloySample(ModMetals.CELENEGIL, 2, 1.25f));
        this.addAlloyRecipe(new AlloySample(ModMetals.KALENDRITE, 1), new AlloySample(ModMetals.PLATINUM, 1), new AlloySample(ModMetals.AMORDRINE, 2, 1.25f));
        this.addAlloyRecipe(new AlloySample(ModMetals.MITHRIL, 1), new AlloySample(ModMetals.RUBRACIUM, 2), new AlloySample(ModMetals.HADEROTH, 3, 1.5f));
        this.addAlloyRecipe(new AlloySample(ModMetals.ADAMANTINE, 1), new AlloySample(ModMetals.ATLARUS, 1), new AlloySample(ModMetals.TARTARITE, 1, 1.5f));
        this.addAlloyRecipe(new AlloySample(ModMetals.EXIMITE, 1), new AlloySample(ModMetals.MEUTOITE, 1), new AlloySample(ModMetals.DESICHALKOS, 2, 1.25f));
        this.addAlloyRecipe(new AlloySample(new ItemStack(Items.field_151043_k), 1), new AlloySample(new ItemStack(Items.field_151042_j), 1), new AlloySample(ModMetals.ANGMALLEN, 2, 1.25f));
        this.addAlloyRecipe(new AlloySample(ModMetals.INFUSCOLIUM, 1), new AlloySample(ModMetals.STEEL, 1), new AlloySample(ModMetals.HEPATIZON, 2, 1.25f));
        this.addAlloyRecipe(new AlloySample(ModMetals.SILVER, 1), new AlloySample(ModMetals.MITHRIL, 1), new AlloySample(ModMetals.QUICKSILVER, 2, 1.25f));
        this.addAlloyRecipe(new AlloySample(ModMetals.LUTETIUM, 1), new AlloySample(ModMetals.OSMIUM, 1), new AlloySample(ModMetals.KRIK, 2, 1.25f));
        this.addAlloyRecipe(new AlloySample(ModMetals.SANGUINITE, 1), new AlloySample(ModMetals.CARMOT, 1), new AlloySample(ModMetals.ETHERIUM, 2, 1.25f));
    }

    public void addCustomAlloyRecipe(ItemStack input1, ItemStack input2, ItemStack result, float xp) {
        if (input1.func_190926_b() || input2.func_190926_b() || result.func_190926_b()) {
            return;
        }
        if (this.getAlloyResult(input1, input2) != ItemStack.field_190927_a) {
            return;
        }
        this.alloyingList.put((Object)new AlloySample(input1, input1.func_190916_E()), (Object)new AlloySample(input2, input2.func_190916_E()), (Object)new AlloySample(result, result.func_190916_E()).setXp(xp));
    }

    private void addAlloyRecipe(AlloySample input1, AlloySample input2, AlloySample result) {
        if (!(input1.getStack().func_190926_b() || input2.getStack().func_190926_b() || result.getStack().func_190926_b())) {
            this.alloyingList.put((Object)input1, (Object)input2, (Object)result);
        }
    }

    public void removeAlloyRecipe(ItemStack output) {
        Set<Table.Cell> recipesToRemove = this.alloyingList.cellSet().stream().filter(cell -> this.compareItemStackToAlloySample(output, (AlloySample)cell.getValue())).collect(Collectors.toSet());
        if (!recipesToRemove.isEmpty()) {
            recipesToRemove.forEach(alloyCell -> {
                AlloySample cfr_ignored_0 = (AlloySample)this.alloyingList.remove(alloyCell.getRowKey(), alloyCell.getColumnKey());
            });
        }
    }

    public ItemStack getAlloyResult(ItemStack input1, ItemStack input2) {
        Optional<Table.Cell> result = this.alloyingList.cellSet().stream().filter(cell -> this.compareItemStackToAlloySample(input1, (AlloySample)cell.getRowKey()) && this.compareItemStackToAlloySample(input2, (AlloySample)cell.getColumnKey()) || this.compareItemStackToAlloySample(input1, (AlloySample)cell.getColumnKey()) && this.compareItemStackToAlloySample(input2, (AlloySample)cell.getRowKey())).findFirst();
        if (result.isPresent()) {
            AlloySample alloyResult = (AlloySample)result.get().getValue();
            return alloyResult.getStack();
        }
        return ItemStack.field_190927_a;
    }

    public boolean isAlloyMetal(ItemStack input1) {
        return this.alloyingList.cellSet().stream().anyMatch(cell -> this.compareItemStackToAlloySample(input1, (AlloySample)cell.getRowKey()) || this.compareItemStackToAlloySample(input1, (AlloySample)cell.getColumnKey()));
    }

    private boolean compareItemStackToAlloySample(ItemStack stack, AlloySample alloySample) {
        Metal metal = ItemUtils.getMetalFromOreDictStack(stack);
        if (metal != null && !alloySample.hasFallenBack()) {
            return metal == alloySample.getMetal();
        }
        return this.compareItemStacks(stack, alloySample.getFallbackStack());
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public float getAlloyExperience(ItemStack stack) {
        Optional<AlloySample> result = this.alloyingList.cellSet().stream().map(Table.Cell::getValue).filter(resultAlloy -> this.compareItemStackToAlloySample(stack, (AlloySample)resultAlloy)).findFirst();
        return result.filter(AlloySample::hasXp).map(AlloySample::getXp).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public int getItemQuantity(ItemStack result, ItemStack input) {
        for (Table.Cell cell : this.alloyingList.cellSet()) {
            if (!this.compareItemStackToAlloySample(result, (AlloySample)cell.getValue())) continue;
            if (this.compareItemStackToAlloySample(input, (AlloySample)cell.getRowKey())) {
                return ((AlloySample)cell.getRowKey()).getAmount();
            }
            if (!this.compareItemStackToAlloySample(input, (AlloySample)cell.getColumnKey())) continue;
            return ((AlloySample)cell.getColumnKey()).getAmount();
        }
        return 0;
    }

    public Table<AlloySample, AlloySample, AlloySample> getRecipeTable() {
        return this.alloyingList;
    }
}

