/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.recipe;

import com.google.common.base.CaseFormat;
import com.google.gson.JsonObject;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.ModMetals;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class IngredientMetal
extends Ingredient {
    String type;

    public IngredientMetal(String ingredientType) {
        super(0);
        this.type = ingredientType;
    }

    public boolean apply(@Nullable ItemStack craftingStack) {
        if (craftingStack == null || craftingStack.func_190926_b()) {
            return false;
        }
        return this.isMetal(this.type, craftingStack);
    }

    private boolean isMetal(String type, ItemStack stack) {
        int[] ids;
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            String ore = OreDictionary.getOreName((int)id);
            if (!ore.startsWith(type)) continue;
            String snakeOre = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, ore);
            Object[] snakeArray = snakeOre.split("_");
            String metalName = String.join((CharSequence)"_", (CharSequence[])ArrayUtils.removeElement((Object[])snakeArray, (Object)snakeArray[0]));
            return ModMetals.metalMap.containsKey(metalName);
        }
        return false;
    }

    public NonNullList<ItemStack> getOreDictStacks(Metal metal) {
        return OreDictionary.getOres((String)(this.type + CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, metal.toString())));
    }

    public static class Factory
    implements IIngredientFactory {
        @Nonnull
        public Ingredient parse(JsonContext context, JsonObject json) {
            String type = JsonUtils.func_151200_h((JsonObject)json, (String)"item_type");
            return new IngredientMetal(type);
        }
    }
}

