/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.recipe;

import it.hurts.metallurgy_reforged.block.BlockTypes;
import it.hurts.metallurgy_reforged.block.ModBlocks;
import it.hurts.metallurgy_reforged.config.RegistrationConfig;
import it.hurts.metallurgy_reforged.item.ModItems;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.Utils;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ModRecipes {
    private static final String GENERATED_RECIPES_PATH = "/assets/metallurgy/recipes/generated";

    @Deprecated
    public static void checkForUnboundRecipes() {
        Path blockRecipesPath = Utils.getPath("/assets/metallurgy/recipes/generated/block");
        Path itemRecipesPath = Utils.getPath("/assets/metallurgy/recipes/generated/item");
        Path handMadeBlockRecipes = Utils.getPath("/assets/metallurgy/recipes/block");
        if (blockRecipesPath != null && itemRecipesPath != null) {
            if (!(blockRecipesPath.toFile().isDirectory() && itemRecipesPath.toFile().isDirectory() && handMadeBlockRecipes.toFile().isDirectory())) {
                return;
            }
            for (File recipe : blockRecipesPath.toFile().listFiles()) {
                for (BlockTypes blockTypes : BlockTypes.values()) {
                    if (!recipe.getName().startsWith(blockTypes.getPrefix())) continue;
                    ModRecipes.enableDisableJsonRecipe(recipe, blockTypes.isEnabled());
                }
            }
            for (File itemFile : itemRecipesPath.toFile().listFiles()) {
                if (itemFile.isDirectory()) {
                    if (itemFile.getName().equals("armor")) {
                        Arrays.stream(itemFile.listFiles()).forEach(armor -> ModRecipes.enableDisableJsonRecipe(itemFile, RegistrationConfig.categoryItems.enableMetalArmorSets));
                    }
                    if (itemFile.getName().equals("tool")) {
                        for (File file : itemFile.listFiles()) {
                            if (file.getName().startsWith("axe_")) {
                                ModRecipes.enableDisableJsonRecipe(file, RegistrationConfig.categoryItems.enableMetalAxes);
                                continue;
                            }
                            if (file.getName().startsWith("hoe_")) {
                                ModRecipes.enableDisableJsonRecipe(file, RegistrationConfig.categoryItems.enableMetalHoes);
                                continue;
                            }
                            if (file.getName().startsWith("pickaxe_")) {
                                ModRecipes.enableDisableJsonRecipe(file, RegistrationConfig.categoryItems.enableMetalPickaxes);
                                continue;
                            }
                            if (file.getName().startsWith("shovel_")) {
                                ModRecipes.enableDisableJsonRecipe(file, RegistrationConfig.categoryItems.enableMetalShovels);
                                continue;
                            }
                            if (!file.getName().startsWith("sword_")) continue;
                            ModRecipes.enableDisableJsonRecipe(file, RegistrationConfig.categoryItems.enableMetalSwords);
                        }
                    }
                    if (itemFile.getName().equals("dust")) {
                        Arrays.stream(itemFile.listFiles()).forEach(dustAlloy -> ModRecipes.enableDisableJsonRecipe(dustAlloy, RegistrationConfig.categoryItems.enableMetalDusts));
                    }
                    if (itemFile.getName().equals("compat")) {
                        Arrays.stream(itemFile.listFiles()).forEach(midToGoldRecipe -> ModRecipes.enableDisableJsonRecipe(midToGoldRecipe, RegistrationConfig.categoryItems.enableMetalDusts));
                    }
                    if (!itemFile.getName().equals("shapeless")) continue;
                    for (File file : itemFile.listFiles()) {
                        if (file.getName().startsWith("nugget_shapeless_")) {
                            ModRecipes.enableDisableJsonRecipe(file, RegistrationConfig.categoryItems.enableMetalNuggets);
                            continue;
                        }
                        if (!file.getName().startsWith("ingot_shapeless")) continue;
                        ModRecipes.enableDisableJsonRecipe(file, RegistrationConfig.categoryBlocks.enableRawMetalBlocks);
                    }
                    continue;
                }
                if (!itemFile.isFile()) continue;
                ModRecipes.enableDisableJsonRecipe(itemFile, RegistrationConfig.categoryItems.enableMetalNuggets);
            }
            for (File recipe : handMadeBlockRecipes.toFile().listFiles()) {
                if (!recipe.getName().startsWith("gold_") && !recipe.getName().startsWith("iron_")) continue;
                for (BlockTypes blockTypes : BlockTypes.values()) {
                    if (!recipe.getName().substring(5).startsWith(blockTypes.getPrefix())) continue;
                    ModRecipes.enableDisableJsonRecipe(recipe, blockTypes.isEnabled());
                }
            }
        }
    }

    private static void enableDisableJsonRecipe(File recipe, boolean enabled) {
        String newPath = "";
        if (recipe.toString().endsWith(".json") && !enabled) {
            newPath = recipe.toString() + ".disabled";
        }
        if (recipe.toString().endsWith(".disabled") && enabled) {
            newPath = recipe.toString().replace(".disabled", "");
        }
        if (newPath.equals("")) {
            return;
        }
        recipe.renameTo(new File(newPath));
    }

    public static void initFurnaceRecipes() {
        ModMetals.metalMap.forEach((name, metal) -> {
            if (metal.getOre() != null) {
                GameRegistry.addSmelting((Block)metal.getOre(), (ItemStack)new ItemStack((Item)metal.getIngot()), (float)1.0f);
            }
            if (RegistrationConfig.categoryItems.enableMetalDusts) {
                GameRegistry.addSmelting((Item)metal.getDust(), (ItemStack)new ItemStack((Item)metal.getIngot()), (float)0.6f);
            }
        });
        GameRegistry.addSmelting((Item)ModItems.dustIron, (ItemStack)new ItemStack(Items.field_151042_j), (float)0.6f);
        GameRegistry.addSmelting((Item)ModItems.dustGold, (ItemStack)new ItemStack(Items.field_151043_k), (float)0.6f);
        GameRegistry.addSmelting((Block)ModBlocks.oreTar, (ItemStack)new ItemStack((Item)ModItems.tar), (float)0.5f);
        GameRegistry.addSmelting((Block)ModBlocks.orePhosphorite, (ItemStack)new ItemStack((Item)ModItems.phosphorus), (float)0.5f);
        GameRegistry.addSmelting((Block)ModBlocks.orePotash, (ItemStack)new ItemStack((Item)ModItems.potash), (float)0.5f);
        GameRegistry.addSmelting((Block)ModBlocks.oreSulfur, (ItemStack)new ItemStack((Item)ModItems.sulfur), (float)0.5f);
    }
}

