/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.recipe;

import com.google.gson.JsonObject;
import it.hurts.metallurgy_reforged.item.ModItems;
import it.hurts.metallurgy_reforged.item.gadget.ItemOreDetector;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import it.hurts.metallurgy_reforged.util.Utils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class OreDetectorRecipe
extends ShapelessOreRecipe {
    public OreDetectorRecipe(ResourceLocation group, NonNullList<Ingredient> input) {
        super(group, input, ItemStack.field_190927_a);
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        ItemStack output = ItemStack.field_190927_a;
        NonNullList inputs = NonNullList.func_191196_a();
        Metal metalModel = null;
        if (this.input.size() == 1) {
            return new ItemStack((Item)ModItems.oreDetector);
        }
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            Metal otherMetal = ItemUtils.getMetalFromOreDictStack(stack);
            if (otherMetal != null) {
                if (otherMetal == metalModel || otherMetal.isAlloy()) {
                    return ItemStack.field_190927_a;
                }
                inputs.add((Object)stack);
                metalModel = otherMetal;
                continue;
            }
            if (stack.func_77973_b() != ModItems.oreDetector) continue;
            if (!ItemOreDetector.getDetectorMetals(stack).isEmpty()) {
                return ItemStack.field_190927_a;
            }
            output = stack.func_77946_l();
        }
        if (metalModel == null) {
            return output;
        }
        ItemOreDetector.addIngotsToDetector(output, (List<ItemStack>)inputs);
        return output;
    }

    public boolean func_192399_d() {
        return true;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            NonNullList<Ingredient> ingredients = Utils.parseShapelessRecipe(context, json);
            return new OreDetectorRecipe(null, ingredients);
        }
    }
}

