/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.recipe;

import it.hurts.metallurgy_reforged.block.BlockTypes;
import it.hurts.metallurgy_reforged.material.ModMetals;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public class SublimationRecipes {
    private static final SublimationRecipes INSTANCE = new SublimationRecipes();
    private final Map<ItemStack, PotionEffect> sublimationList = new HashMap<ItemStack, PotionEffect>();

    public static SublimationRecipes getInstance() {
        return INSTANCE;
    }

    private SublimationRecipes() {
        if (ModMetals.ADAMANTINE != null) {
            this.addSublimationRecipe(new ItemStack((Block)ModMetals.ADAMANTINE.getBlock(BlockTypes.BLOCK), 5), new PotionEffect(MobEffects.field_76443_y, 24000));
        }
        if (ModMetals.CARMOT != null) {
            this.addSublimationRecipe(new ItemStack((Block)ModMetals.CARMOT.getBlock(BlockTypes.BLOCK), 6), new PotionEffect(MobEffects.field_76422_e, 24000));
        }
        if (ModMetals.ALDUORITE != null) {
            this.addSublimationRecipe(new ItemStack((Block)ModMetals.ALDUORITE.getBlock(BlockTypes.BLOCK), 6), new PotionEffect(MobEffects.field_76426_n, 20000));
        }
        if (ModMetals.QUICKSILVER != null) {
            this.addSublimationRecipe(new ItemStack((Block)ModMetals.QUICKSILVER.getBlock(BlockTypes.BLOCK), 4), new PotionEffect(MobEffects.field_76424_c, 24000));
        }
        if (ModMetals.STEEL != null) {
            this.addSublimationRecipe(new ItemStack((Block)ModMetals.STEEL.getBlock(BlockTypes.BLOCK), 4), new PotionEffect(MobEffects.field_76420_g, 20000));
        }
        if (ModMetals.DEEP_IRON != null) {
            this.addSublimationRecipe(new ItemStack((Block)ModMetals.DEEP_IRON.getBlock(BlockTypes.BLOCK), 5), new PotionEffect(MobEffects.field_76427_o, 22000));
        }
        if (ModMetals.ELECTRUM != null) {
            this.addSublimationRecipe(new ItemStack((Block)ModMetals.ELECTRUM.getBlock(BlockTypes.BLOCK), 5), new PotionEffect(MobEffects.field_76439_r, 24000));
        }
        if (ModMetals.CELENEGIL != null) {
            this.addSublimationRecipe(new ItemStack((Block)ModMetals.CELENEGIL.getBlock(BlockTypes.BLOCK), 6), new PotionEffect(MobEffects.field_76429_m, 24000, 1));
        }
        if (ModMetals.KALENDRITE != null) {
            this.addSublimationRecipe(new ItemStack((Block)ModMetals.KALENDRITE.getBlock(BlockTypes.BLOCK), 5), new PotionEffect(MobEffects.field_76428_l, 22000));
        }
        if (ModMetals.MIDASIUM != null) {
            this.addSublimationRecipe(new ItemStack((Block)ModMetals.MIDASIUM.getBlock(BlockTypes.BLOCK), 4), new PotionEffect(MobEffects.field_188425_z, 20000));
        }
        if (ModMetals.HADEROTH != null) {
            this.addSublimationRecipe(new ItemStack((Block)ModMetals.HADEROTH.getBlock(BlockTypes.BLOCK), 4), new PotionEffect(MobEffects.field_180152_w, 20000, 4));
        }
    }

    public void addSublimationRecipe(ItemStack input, PotionEffect potion) {
        if (input.func_190926_b() || potion == null) {
            return;
        }
        if (this.getSublimationResult(input) != null) {
            return;
        }
        this.sublimationList.put(input, potion);
    }

    public void removeSublimationRecipe(Potion output) {
        ItemStack keyToRemove = ItemStack.field_190927_a;
        for (Map.Entry<ItemStack, PotionEffect> entry : this.sublimationList.entrySet()) {
            if (output != entry.getValue().func_188419_a()) continue;
            keyToRemove = entry.getKey();
        }
        if (!keyToRemove.func_190926_b()) {
            this.sublimationList.remove(keyToRemove);
        }
    }

    public PotionEffect getSublimationResult(ItemStack input) {
        for (Map.Entry<ItemStack, PotionEffect> entry : this.sublimationList.entrySet()) {
            if (!this.compareItemStacks(entry.getKey(), input) || entry.getKey().func_190916_E() != input.func_190916_E()) continue;
            return entry.getValue();
        }
        return null;
    }

    public int getSublimationBlockAmount(ItemStack input) {
        for (Map.Entry<ItemStack, PotionEffect> entry : this.sublimationList.entrySet()) {
            if (!this.compareItemStacks(entry.getKey(), input)) continue;
            return entry.getKey().func_190916_E();
        }
        return 0;
    }

    public Map<ItemStack, PotionEffect> recipesMap() {
        return this.sublimationList;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }
}

