/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.tileentity;

import blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler;
import it.hurts.metallurgy_reforged.block.BlockAlloyer;
import it.hurts.metallurgy_reforged.container.ContainerAlloyer;
import it.hurts.metallurgy_reforged.item.ModItems;
import it.hurts.metallurgy_reforged.recipe.AlloyerRecipes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.commons.lang3.ArrayUtils;

@Optional.Interface(modid="immersiveengineering", iface="blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler$IExternalHeatable")
public class TileEntityAlloyer
extends TileEntityLockable
implements ITickable,
ISidedInventory,
ExternalHeaterHandler.IExternalHeatable {
    private static final int[] slotsTop = Slots.INPUT_SLOT.slots();
    private static final int[] slotsBottom = Slots.OUTPUT_SLOT.slots();
    private static final int[] slotsSides = Slots.FUEL_SLOT.slots();
    private final IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    private final IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    private final IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private String customName;
    public static final int TOTAL_ALLOYING_TIME = 140;
    private int burnTime;
    private int totalBurnTime;
    private int alloyingTime;
    private boolean isPoweredByThermite;

    public static boolean isItemFuel(ItemStack fuel) {
        return TileEntityFurnace.func_145952_a((ItemStack)fuel) > 0;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.inventory.get(index);
        boolean isEmptyOrNotEqualToTheSlotStack = stack.func_190926_b() || !stack.func_77969_a(itemstack) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (Slots.INPUT_SLOT.contains(index) && isEmptyOrNotEqualToTheSlotStack) {
            this.alloyingTime = 0;
            this.func_70296_d();
        }
    }

    @Nonnull
    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.alloyer";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        this.burnTime = compound.func_74765_d("burn_time");
        this.alloyingTime = compound.func_74765_d("alloying_time");
        this.totalBurnTime = compound.func_74765_d("total_burn_time");
        this.isPoweredByThermite = compound.func_74767_n("powered_by_thermite");
        if (compound.func_150297_b("custom_name", 8)) {
            this.setCustomName(compound.func_74779_i("custom_name"));
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74777_a("burn_time", (short)this.burnTime);
        compound.func_74777_a("alloying_time", (short)this.alloyingTime);
        compound.func_74777_a("total_burn_time", (short)this.totalBurnTime);
        compound.func_74757_a("powered_by_thermite", this.isPoweredByThermite);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
        if (this.func_145818_k_()) {
            compound.func_74778_a("custom_name", this.customName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(TileEntityAlloyer te) {
        return te.func_174887_a_(0) > 0;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, compound);
    }

    public void onDataPacket(@Nonnull NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void sendUpdate() {
        if (this.field_145850_b != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 8);
            this.func_70296_d();
        }
    }

    public void func_73660_a() {
        boolean oldBurningState = this.isBurning();
        if (this.isBurning()) {
            --this.burnTime;
            if (this.canAlloy()) {
                this.alloyingTime = this.isPoweredByThermite ? Math.min(this.alloyingTime += 2, 140) : ++this.alloyingTime;
                if (this.alloyingTime >= 140) {
                    this.alloyItem();
                    this.alloyingTime = 0;
                    this.func_70296_d();
                }
            }
        } else {
            ItemStack fuelStack = (ItemStack)this.inventory.get(Slots.FUEL_SLOT.slots[0]);
            Item fuelItem = fuelStack.func_77973_b();
            if (!fuelStack.func_190926_b() && this.canAlloy()) {
                this.isPoweredByThermite = fuelStack.func_77973_b() == ModItems.dustThermite;
                this.totalBurnTime = this.burnTime = TileEntityFurnace.func_145952_a((ItemStack)fuelStack);
                fuelStack.func_190918_g(1);
                if (fuelStack.func_190926_b()) {
                    ItemStack containerItem = fuelItem.getContainerItem(fuelStack);
                    this.inventory.set(Slots.FUEL_SLOT.slots[0], (Object)containerItem);
                }
                this.func_70296_d();
            }
            if (this.alloyingTime > 0) {
                this.alloyingTime = Math.max(this.alloyingTime - 3, 0);
            }
        }
        if (oldBurningState != this.isBurning()) {
            BlockAlloyer.setState(this.isBurning(), this.field_145850_b, this.field_174879_c);
        }
    }

    public int doHeatTick(int energyAvailable, boolean redstone) {
        if (this.canAlloy() || redstone) {
            this.totalBurnTime = 111;
            this.burnTime = Math.min(this.burnTime += 2, this.totalBurnTime);
            if (this.canAlloy() && this.totalBurnTime == this.burnTime && this.alloyingTime < 140) {
                ++this.alloyingTime;
            }
            if (!((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockAlloyer.BURNING)).booleanValue()) {
                BlockAlloyer.setState(true, this.field_145850_b, this.field_174879_c);
            }
            this.sendUpdate();
        }
        if (!this.isBurning()) {
            return 0;
        }
        if (this.burnTime < this.totalBurnTime) {
            return ExternalHeaterHandler.defaultFurnaceEnergyCost;
        }
        return ExternalHeaterHandler.defaultFurnaceSpeedupCost + ExternalHeaterHandler.defaultFurnaceEnergyCost;
    }

    private boolean canAlloy() {
        boolean areInputCountsLessThanRecipeCounts;
        ItemStack input1 = (ItemStack)this.inventory.get(Slots.INPUT_SLOT.slots[0]);
        ItemStack input2 = (ItemStack)this.inventory.get(Slots.INPUT_SLOT.slots[1]);
        ItemStack result = AlloyerRecipes.getInstance().getAlloyResult(input1, input2);
        boolean bl = areInputCountsLessThanRecipeCounts = input1.func_190916_E() < AlloyerRecipes.getInstance().getItemQuantity(result, input1) || input2.func_190916_E() < AlloyerRecipes.getInstance().getItemQuantity(result, input2);
        if (result.func_190926_b() || areInputCountsLessThanRecipeCounts) {
            return false;
        }
        ItemStack output = (ItemStack)this.inventory.get(Slots.OUTPUT_SLOT.slots[0]);
        if (output.func_190926_b()) {
            return true;
        }
        if (!output.func_77969_a(result) || !ItemStack.func_77970_a((ItemStack)output, (ItemStack)result)) {
            return false;
        }
        int resultCount = output.func_190916_E() + result.func_190916_E();
        return resultCount <= this.func_70297_j_() && resultCount <= output.func_77976_d();
    }

    private void alloyItem() {
        if (this.canAlloy()) {
            ItemStack input1 = (ItemStack)this.inventory.get(0);
            ItemStack input2 = (ItemStack)this.inventory.get(1);
            ItemStack result = AlloyerRecipes.getInstance().getAlloyResult(input1, input2);
            ItemStack output = (ItemStack)this.inventory.get(3);
            if (output.func_190926_b()) {
                this.inventory.set(3, (Object)result.func_77946_l());
            } else if (output.func_77969_a(result) && ItemStack.func_77970_a((ItemStack)output, (ItemStack)result)) {
                output.func_190917_f(result.func_190916_E());
            }
            input1.func_190918_g(AlloyerRecipes.getInstance().getItemQuantity(result, input1));
            input2.func_190918_g(AlloyerRecipes.getInstance().getItemQuantity(result, input2));
        }
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        if (Slots.OUTPUT_SLOT.contains(index)) {
            return false;
        }
        if (Slots.FUEL_SLOT.contains(index)) {
            ItemStack fuelStack = (ItemStack)this.inventory.get(index);
            return TileEntityAlloyer.isItemFuel(stack) || SlotFurnaceFuel.func_178173_c_((ItemStack)stack) && fuelStack.func_77973_b() != Items.field_151133_ar;
        }
        if (Slots.INPUT_SLOT.contains(index)) {
            if (AlloyerRecipes.getInstance().isAlloyMetal(stack)) {
                ItemStack input1 = (ItemStack)this.inventory.get(0);
                ItemStack input2 = (ItemStack)this.inventory.get(1);
                if (input1.func_190926_b()) {
                    if (input2.func_190926_b()) {
                        return true;
                    }
                    if (index == 1) {
                        return input2.func_77969_a(stack) || ItemStack.func_179545_c((ItemStack)input2, (ItemStack)stack);
                    }
                    return !AlloyerRecipes.getInstance().getAlloyResult(input2, stack).func_190926_b();
                }
                if (input2.func_190926_b()) {
                    if (index == 0) {
                        return input1.func_77969_a(stack) || ItemStack.func_179545_c((ItemStack)input1, (ItemStack)stack);
                    }
                    return !AlloyerRecipes.getInstance().getAlloyResult(input1, stack).func_190926_b();
                }
                ItemStack s = (ItemStack)this.inventory.get(index);
                return (s.func_77969_a(stack) || ItemStack.func_179545_c((ItemStack)s, (ItemStack)stack)) && s.func_77976_d() > s.func_190916_E();
            }
            return false;
        }
        return false;
    }

    @Nonnull
    public String func_174875_k() {
        return "minecraft:alloyer";
    }

    @Nonnull
    public Container func_174876_a(@Nonnull InventoryPlayer inventory, @Nonnull EntityPlayer player) {
        return new ContainerAlloyer(inventory, (IInventory)this);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.burnTime;
            }
            case 1: {
                return this.totalBurnTime;
            }
            case 2: {
                return this.alloyingTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.burnTime = value;
                break;
            }
            case 1: {
                this.totalBurnTime = value;
                break;
            }
            case 2: {
                this.alloyingTime = value;
                break;
            }
        }
    }

    public int func_174890_g() {
        return 3;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return side == EnumFacing.DOWN ? slotsBottom : (side == EnumFacing.UP ? slotsTop : slotsSides);
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack itemStackIn, @Nonnull EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nonnull EnumFacing direction) {
        return Slots.OUTPUT_SLOT.contains(index);
    }

    public static enum Slots {
        INPUT_SLOT(0, 1),
        OUTPUT_SLOT(3),
        FUEL_SLOT(2);

        private final int[] slots;

        private Slots(int ... slots) {
            this.slots = slots;
        }

        public int[] slots() {
            return this.slots;
        }

        public boolean contains(int i) {
            return ArrayUtils.contains((int[])this.slots, (int)i);
        }
    }
}

