/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.tileentity;

import com.google.common.collect.Lists;
import it.hurts.metallurgy_reforged.block.BlockChamber;
import it.hurts.metallurgy_reforged.container.ContainerNull;
import it.hurts.metallurgy_reforged.recipe.SublimationRecipes;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityChamber
extends TileEntityLockable
implements ITickable,
ISidedInventory {
    public static final int METAL_SLOT = 0;
    public static final int FUEL_SLOT = 1;
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{1};
    private static final int[] SLOTS_SIDES = new int[]{1};
    private final IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    private final IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    private final IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private String chamberCustomName;
    public int fuelTime = 0;
    public int activeTime = 0;
    public PotionEffect potionEffect = null;
    public List<UUID> affectedPlayers = Lists.newArrayList();

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.inventory.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.func_70296_d();
        }
    }

    public void setPotionEffect(PotionEffect effect) {
        this.potionEffect = effect;
        this.updateBlock();
    }

    public void updateBlock() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 4);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this;
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        if (index == 1) {
            return TileEntityFurnace.func_145954_b((ItemStack)stack);
        }
        ItemStack itemstack = (ItemStack)this.inventory.get(0);
        SublimationRecipes recipes = SublimationRecipes.getInstance();
        int recipeAmount = recipes.getSublimationBlockAmount(stack);
        return itemstack.func_190916_E() < recipeAmount;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    @Nonnull
    public String func_70005_c_() {
        return this.func_145818_k_() ? this.chamberCustomName : "container.chamber";
    }

    public boolean func_145818_k_() {
        return this.chamberCustomName != null && !this.chamberCustomName.isEmpty();
    }

    @Nonnull
    public Container func_174876_a(@Nonnull InventoryPlayer playerInventory, @Nonnull EntityPlayer playerIn) {
        return new ContainerNull();
    }

    @Nonnull
    public String func_174875_k() {
        return "metallurgy:chamber";
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return SLOTS_BOTTOM;
        }
        return side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDES;
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack itemStackIn, @Nonnull EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nonnull EnumFacing direction) {
        return index == 1;
    }

    public void func_73660_a() {
        ItemStack METAL_STACK = this.func_70301_a(0);
        ItemStack FUEL_STACK = this.func_70301_a(1);
        PotionEffect potionEffect = this.potionEffect;
        if (potionEffect == null) {
            potionEffect = SublimationRecipes.getInstance().getSublimationResult(METAL_STACK);
        }
        if (this.fuelTime > 0) {
            --this.fuelTime;
        }
        int fuelValue = TileEntityFurnace.func_145952_a((ItemStack)FUEL_STACK);
        if (this.fuelTime > 0) {
            if (potionEffect != null) {
                if (!this.isActive()) {
                    this.activeTime = 1;
                    this.setState(true);
                    this.setPotionEffect(potionEffect);
                } else if (this.activeTime < potionEffect.func_76459_b()) {
                    ++this.activeTime;
                    int range = 6;
                    AxisAlignedBB axisAlignedBB = new AxisAlignedBB(this.field_174879_c, this.field_174879_c).func_186662_g((double)range);
                    List entityPlayers = this.field_145850_b.func_72872_a(EntityPlayer.class, axisAlignedBB);
                    for (EntityPlayer player : entityPlayers) {
                        if (player.func_70644_a(potionEffect.func_188419_a())) continue;
                        player.func_70690_d(new PotionEffect(potionEffect.func_188419_a(), potionEffect.func_76459_b() - this.activeTime));
                        UUID uuid = player.func_110124_au();
                        if (this.affectedPlayers.contains(uuid)) continue;
                        this.affectedPlayers.add(uuid);
                    }
                } else {
                    this.func_70299_a(0, ItemStack.field_190927_a);
                    this.setPotionEffect(null);
                    this.setState(false);
                    this.activeTime = 0;
                }
            }
        } else if (fuelValue > 0 && potionEffect != null) {
            Item item = FUEL_STACK.func_77973_b();
            FUEL_STACK.func_190918_g(1);
            this.fuelTime = fuelValue;
            if (FUEL_STACK.func_190926_b()) {
                ItemStack item1 = item.getContainerItem(FUEL_STACK);
                this.func_70299_a(1, item1);
            }
        } else if (!this.affectedPlayers.isEmpty()) {
            this.clearEffect();
        }
    }

    public boolean isActive() {
        return this.activeTime > 0;
    }

    public void setState(boolean active) {
        this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockChamber.ACTIVE, (Comparable)Boolean.valueOf(active)));
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.writeChamberToNBT(compound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.affectedPlayers.size(); ++i) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_186854_a("playerUUID", this.affectedPlayers.get(i));
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        if (!nbttaglist.func_82582_d()) {
            compound.func_74782_a("affectedPlayers", (NBTBase)nbttaglist);
        }
        return compound;
    }

    public void writeChamberToNBT(NBTTagCompound compound) {
        compound.func_74768_a("activeTime", this.activeTime);
        compound.func_74768_a("fuelTime", this.fuelTime);
        if (this.potionEffect != null) {
            this.potionEffect.func_82719_a(compound);
        }
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.chamberCustomName);
        }
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readChamberFromNBT(compound);
        NBTTagList nbttaglist = compound.func_150295_c("affectedPlayers", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            this.affectedPlayers.add(nbttagcompound.func_186857_a("playerUUID"));
        }
    }

    public void readChamberFromNBT(NBTTagCompound compound) {
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        this.fuelTime = compound.func_74762_e("fuelTime");
        this.activeTime = compound.func_74762_e("activeTime");
        this.potionEffect = null;
        if (compound.func_74764_b("Id")) {
            this.potionEffect = PotionEffect.func_82722_b((NBTTagCompound)compound);
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.chamberCustomName = compound.func_74779_i("CustomName");
        }
    }

    public void clearEffect() {
        if (!this.field_145850_b.field_72995_K && this.potionEffect != null) {
            for (WorldServer worldServer : this.field_145850_b.func_73046_m().field_71305_c) {
                for (UUID uuid : this.affectedPlayers) {
                    EntityPlayer player = worldServer.func_152378_a(uuid);
                    if (player == null) continue;
                    player.func_184589_d(this.potionEffect.func_188419_a());
                }
            }
        }
        this.affectedPlayers.clear();
    }

    public boolean shouldRefresh(@Nonnull World world, @Nonnull BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.readChamberFromNBT(tag);
    }
}

