/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.tileentity;

import blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler;
import it.hurts.metallurgy_reforged.block.BlockAlloyer;
import it.hurts.metallurgy_reforged.block.BlockCrusher;
import it.hurts.metallurgy_reforged.container.ContainerCrusher;
import it.hurts.metallurgy_reforged.item.ModItems;
import it.hurts.metallurgy_reforged.recipe.CrusherRecipes;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.commons.lang3.ArrayUtils;

@Optional.Interface(modid="immersiveengineering", iface="blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler$IExternalHeatable")
public class TileEntityCrusher
extends TileEntityLockable
implements ITickable,
ISidedInventory,
ExternalHeaterHandler.IExternalHeatable {
    private static final int[] slotsTop = Slots.INPUT_SLOT.slots();
    private static final int[] slotsBottom = Slots.OUTPUT_SLOT.slots();
    private static final int[] slotsSides = Slots.FUEL_SLOT.slots();
    private IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    private IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    private IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private String customName;
    private int burnTime;
    private int totalBurnTime;
    private int crushTime;
    public static final int TOTAL_CRUSHING_TIME = 140;
    private boolean isPoweredByThermite;

    public static boolean isItemFuel(ItemStack fuel) {
        return TileEntityFurnace.func_145952_a((ItemStack)fuel) > 0;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.inventory.get(index);
        boolean isEmptyOrNotEqualToTheSlotStack = stack.func_190926_b() || !stack.func_77969_a(itemstack) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (Slots.INPUT_SLOT.contains(index) && isEmptyOrNotEqualToTheSlotStack) {
            this.crushTime = 0;
            this.func_70296_d();
        }
    }

    @Nonnull
    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.crusher";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        this.burnTime = compound.func_74762_e("burn_time");
        this.crushTime = compound.func_74762_e("crush_time");
        this.totalBurnTime = compound.func_74762_e("total_burn_time");
        this.isPoweredByThermite = compound.func_74767_n("powered_by_thermite");
        if (compound.func_150297_b("custom_name", 8)) {
            this.setCustomName(compound.func_74779_i("custom_name"));
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("burn_time", (int)((short)this.burnTime));
        compound.func_74768_a("total_burn_time", (int)((short)this.totalBurnTime));
        compound.func_74768_a("crush_time", (int)((short)this.crushTime));
        compound.func_74757_a("powered_by_thermite", this.isPoweredByThermite);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
        if (this.func_145818_k_()) {
            compound.func_74778_a("custom_name", this.customName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, compound);
    }

    public void onDataPacket(@Nonnull NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void sendUpdate() {
        if (this.field_145850_b != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 8);
            this.func_70296_d();
        }
    }

    public void func_73660_a() {
        boolean oldBurningState = this.isBurning();
        if (this.isBurning()) {
            --this.burnTime;
            if (this.canCrush()) {
                this.crushTime = !this.isPoweredByThermite ? ++this.crushTime : Math.min(this.crushTime += 2, 140);
                if (this.crushTime >= 140) {
                    this.crushItem();
                    this.crushTime = 0;
                    this.func_70296_d();
                }
            }
        } else {
            ItemStack fuelStack = (ItemStack)this.inventory.get(Slots.FUEL_SLOT.slots[0]);
            Item fuelItem = fuelStack.func_77973_b();
            if (!fuelStack.func_190926_b() && this.canCrush()) {
                this.isPoweredByThermite = fuelStack.func_77973_b() == ModItems.dustThermite;
                this.totalBurnTime = this.burnTime = TileEntityFurnace.func_145952_a((ItemStack)fuelStack);
                fuelStack.func_190918_g(1);
                if (fuelStack.func_190926_b()) {
                    ItemStack containerItem = fuelItem.getContainerItem(fuelStack);
                    this.inventory.set(Slots.FUEL_SLOT.slots[0], (Object)containerItem);
                }
                this.func_70296_d();
            }
            if (this.crushTime > 0) {
                this.crushTime = Math.max(this.crushTime - 2, 0);
            }
        }
        if (oldBurningState != this.isBurning()) {
            BlockCrusher.setState(this.isBurning(), this.field_145850_b, this.field_174879_c);
        }
    }

    public int doHeatTick(int energyAvailable, boolean redstone) {
        if (this.canCrush() || redstone) {
            this.totalBurnTime = 111;
            this.burnTime = Math.min(this.burnTime += 2, this.totalBurnTime);
            if (this.canCrush() && this.totalBurnTime == this.burnTime && this.crushTime < 140) {
                ++this.crushTime;
            }
            if (!((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockAlloyer.BURNING)).booleanValue()) {
                BlockAlloyer.setState(true, this.field_145850_b, this.field_174879_c);
            }
            this.sendUpdate();
        }
        if (!this.isBurning()) {
            return 0;
        }
        if (this.burnTime < this.totalBurnTime) {
            return ExternalHeaterHandler.defaultFurnaceEnergyCost;
        }
        return ExternalHeaterHandler.defaultFurnaceSpeedupCost + ExternalHeaterHandler.defaultFurnaceEnergyCost;
    }

    private boolean canCrush() {
        ItemStack input = (ItemStack)this.inventory.get(Slots.INPUT_SLOT.slots[0]);
        if (input.func_190926_b()) {
            return false;
        }
        ItemStack result = CrusherRecipes.getInstance().getCrushingResult(input);
        if (result.func_190926_b()) {
            return false;
        }
        ItemStack output = (ItemStack)this.inventory.get(Slots.OUTPUT_SLOT.slots[0]);
        ItemStack output1 = (ItemStack)this.inventory.get(Slots.OUTPUT_SLOT.slots[1]);
        ItemStack output2 = (ItemStack)this.inventory.get(Slots.OUTPUT_SLOT.slots[2]);
        int totalAmount = output.func_190916_E() + result.func_190916_E();
        int totalAmount1 = output1.func_190916_E() + result.func_190916_E();
        int totalAmount2 = output2.func_190916_E() + result.func_190916_E();
        if (output.func_190926_b() || output1.func_190926_b() || output2.func_190926_b()) {
            return true;
        }
        if (!(output.func_77969_a(result) || output1.func_77969_a(result) || output2.func_77969_a(result))) {
            return false;
        }
        if (totalAmount <= this.func_70297_j_() && totalAmount <= output.func_77976_d()) {
            return true;
        }
        if (totalAmount1 <= this.func_70297_j_() && totalAmount1 <= output1.func_77976_d()) {
            return true;
        }
        return totalAmount2 <= this.func_70297_j_() && totalAmount2 <= output2.func_77976_d();
    }

    private void crushItem() {
        if (this.canCrush()) {
            ItemStack input = (ItemStack)this.inventory.get(Slots.INPUT_SLOT.slots[0]);
            ItemStack recipeResult = CrusherRecipes.getInstance().getCrushingResult(input);
            ItemStack output = (ItemStack)this.inventory.get(Slots.OUTPUT_SLOT.slots[0]);
            ItemStack output1 = (ItemStack)this.inventory.get(Slots.OUTPUT_SLOT.slots[1]);
            ItemStack output2 = (ItemStack)this.inventory.get(Slots.OUTPUT_SLOT.slots[2]);
            int limit = output.func_190916_E() + recipeResult.func_190916_E();
            int limit1 = output1.func_190916_E() + recipeResult.func_190916_E();
            int limit2 = output2.func_190916_E() + recipeResult.func_190916_E();
            if (output.func_190926_b()) {
                this.inventory.set(Slots.OUTPUT_SLOT.slots[0], (Object)recipeResult.func_77946_l());
            } else if (ItemStack.func_179545_c((ItemStack)output, (ItemStack)recipeResult) && limit <= this.func_70297_j_() && limit <= output.func_77976_d()) {
                output.func_190917_f(recipeResult.func_190916_E());
            } else if (output1.func_190926_b()) {
                this.inventory.set(Slots.OUTPUT_SLOT.slots[1], (Object)recipeResult.func_77946_l());
            } else if (ItemStack.func_179545_c((ItemStack)output1, (ItemStack)recipeResult) && limit1 <= this.func_70297_j_() && limit1 <= output1.func_77976_d()) {
                output1.func_190917_f(recipeResult.func_190916_E());
            } else if (output2.func_190926_b()) {
                this.inventory.set(Slots.OUTPUT_SLOT.slots[2], (Object)recipeResult.func_77946_l());
            } else if (ItemStack.func_179545_c((ItemStack)output2, (ItemStack)recipeResult) && limit2 <= this.func_70297_j_() && limit2 <= output2.func_77976_d()) {
                output2.func_190917_f(recipeResult.func_190916_E());
            }
            input.func_190918_g(1);
        }
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        if (Slots.OUTPUT_SLOT.contains(index)) {
            return false;
        }
        if (Slots.FUEL_SLOT.contains(index)) {
            ItemStack fuelStack = (ItemStack)this.inventory.get(index);
            return TileEntityCrusher.isItemFuel(stack) || SlotFurnaceFuel.func_178173_c_((ItemStack)stack) && fuelStack.func_77973_b() != Items.field_151133_ar;
        }
        if (Slots.INPUT_SLOT.contains(index)) {
            return !CrusherRecipes.getInstance().getCrushingResult(stack).func_190926_b();
        }
        return false;
    }

    @Nonnull
    public String func_174875_k() {
        return "minecraft:crusher";
    }

    @Nonnull
    public Container func_174876_a(@Nonnull InventoryPlayer inventory, @Nonnull EntityPlayer player) {
        return new ContainerCrusher(inventory, (IInventory)this);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.burnTime;
            }
            case 1: {
                return this.totalBurnTime;
            }
            case 2: {
                return this.crushTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.burnTime = value;
                break;
            }
            case 1: {
                this.totalBurnTime = value;
                break;
            }
            case 2: {
                this.crushTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 3;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return side == EnumFacing.DOWN ? slotsBottom : (side == EnumFacing.UP ? slotsTop : slotsSides);
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack itemStackIn, @Nonnull EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nonnull EnumFacing direction) {
        return Slots.OUTPUT_SLOT.contains(index);
    }

    public static enum Slots {
        INPUT_SLOT(0),
        OUTPUT_SLOT(2, 3, 4),
        FUEL_SLOT(1);

        private final int[] slots;

        private Slots(int ... slots) {
            this.slots = slots;
        }

        public int[] slots() {
            return Arrays.copyOf(this.slots, this.slots.length);
        }

        public boolean contains(int i) {
            return ArrayUtils.contains((int[])this.slots, (int)i);
        }
    }
}

