/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.util;

import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.Utils;
import jline.internal.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class EventUtils {
    private static final Metal[] metalllarray = (Metal[])ModMetals.metalMap.values().stream().filter(metal -> metal != null && metal.hasArmorSet()).toArray(Metal[]::new);
    private static final int metalIndex = Utils.random.nextInt(metalllarray.length);

    public static boolean isEntityWearingArmor(EntityLivingBase entity, Metal metal) {
        boolean fullArmored = true;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || entity.func_184582_a(slot).func_77973_b() == metal.getArmorPiece(slot)) continue;
            fullArmored = false;
        }
        return fullArmored;
    }

    public static boolean isPlayerWearingSpecificArmorPiece(EntityPlayer player, EntityEquipmentSlot slot, Item armorEquip) {
        return ((ItemStack)player.field_71071_by.field_70460_b.get(slot.func_188454_b())).func_77973_b() == armorEquip;
    }

    public static int getArmorPiecesCount(EntityPlayer player, Item[] armor) {
        NonNullList armorList = player.field_71071_by.field_70460_b;
        int count = 0;
        for (int i = 0; i < armorList.size(); ++i) {
            if (!((ItemStack)armorList.get(3 - i)).func_77973_b().equals(armor[i])) continue;
            ++count;
        }
        return count;
    }

    @Nullable
    public static Metal getRandomMetalBasedOnDifficulty(World world) {
        float chance = 0.0f;
        switch (world.func_175659_aa().func_151525_a()) {
            case 0: {
                chance = 0.0f;
                break;
            }
            case 1: {
                chance = 5.0f;
                break;
            }
            case 2: {
                chance = 10.0f;
                break;
            }
            case 3: {
                chance = 20.0f;
            }
        }
        if (Utils.random.nextFloat() * 100.0f < chance) {
            return metalllarray[metalIndex];
        }
        return null;
    }
}

