/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.util;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Multimap;
import it.hurts.metallurgy_reforged.item.ItemMetal;
import it.hurts.metallurgy_reforged.item.armor.ItemArmorBase;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.MetalStats;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.material.ToolStats;
import it.hurts.metallurgy_reforged.util.BlockUtils;
import it.hurts.metallurgy_reforged.util.Constants;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class ItemUtils {
    public static void initItem(Item item, String name, CreativeTabs tab) {
        item.func_77655_b("metallurgy." + name);
        item.setRegistryName("metallurgy", name);
        item.func_77637_a(tab);
    }

    public static boolean isItemStackASpecificToolMaterial(Metal metal, ItemStack toolStack, String ... except) {
        Item item = toolStack.func_77973_b();
        if (!toolStack.func_190926_b() && item instanceof ItemTool) {
            ItemTool tool = (ItemTool)toolStack.func_77973_b();
            boolean valid = tool.func_77861_e().equalsIgnoreCase(metal.getToolMaterial().name());
            for (String type : except) {
                String toolName = metal.getStats().getName() + "_" + type;
                if (!tool.func_77658_a().equalsIgnoreCase(toolName)) continue;
                valid = false;
            }
            return valid;
        }
        return false;
    }

    public static boolean equalsWildcard(ItemStack wild, ItemStack check) {
        if (wild.func_190926_b() || check.func_190926_b()) {
            return check.equals(wild);
        }
        return wild.func_77973_b() == check.func_77973_b() && (wild.func_77952_i() == Short.MAX_VALUE || check.func_77952_i() == Short.MAX_VALUE || wild.func_77952_i() == check.func_77952_i());
    }

    public static void editInventoryStackSize(NonNullList<ItemStack> inventory, int slot, int amount) {
        if (slot >= 0 && slot < inventory.size() && !((ItemStack)inventory.get(slot)).func_190926_b()) {
            ((ItemStack)inventory.get(slot)).func_190917_f(amount);
            if (((ItemStack)inventory.get(slot)).func_190916_E() <= 0) {
                inventory.set(slot, (Object)ItemStack.field_190927_a);
            }
        }
    }

    public static boolean isItemStackSpecificArmorMaterial(Metal metal, ItemStack armor) {
        return !armor.func_190926_b() && armor.func_77973_b() instanceof ItemArmorBase && ((ItemArmorBase)armor.func_77973_b()).func_82812_d().func_179242_c().equalsIgnoreCase(metal.getArmorMaterial().func_179242_c());
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerCustomItemModel(Item item, int meta) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerCustomItemModel(Item item, int meta, String subdir) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("metallurgy:" + subdir + (!subdir.equals("") ? "/" : "") + item.getRegistryName().func_110623_a(), "inventory"));
    }

    public static Metal getMetalFromItem(Item item) {
        if (item instanceof ItemMetal) {
            ItemMetal metalItem = (ItemMetal)item;
            for (Map.Entry<String, Metal> entry : ModMetals.metalMap.entrySet()) {
                if (!metalItem.getMetalStats().getName().equals(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        if (item instanceof ItemBlock) {
            return BlockUtils.getMetalFromBlock(((ItemBlock)item).func_179223_d());
        }
        return null;
    }

    public static void editModifier(Multimap<String, AttributeModifier> modifierMultimap, IAttribute attribute, UUID id, double amount) {
        Collection modifiers = modifierMultimap.get((Object)attribute.func_111108_a());
        Optional<AttributeModifier> modifierOptional = modifiers.stream().filter(attributeModifier -> attributeModifier.func_111167_a().equals(id)).findFirst();
        if (modifierOptional.isPresent()) {
            AttributeModifier modifier = modifierOptional.get();
            modifiers.remove(modifier);
            modifiers.add(new AttributeModifier(modifier.func_111167_a(), modifier.func_111166_b(), modifier.func_111164_d() + amount, modifier.func_111169_c()));
        }
    }

    public static void setToolAttributes(@Nonnull EntityEquipmentSlot equipmentSlot, Multimap<String, AttributeModifier> multimap, MetalStats metalStats) {
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            ToolStats toolStats = metalStats.getToolStats();
            multimap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(Constants.ModAttributes.MAX_HEALTH, "Metallurgy Axe Max Health", toolStats.getMaxHealth(), 0));
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(Constants.ModAttributes.MOVEMENT_SPEED, "Metallurgy Axe Movement Speed", toolStats.getMovementSpeed(), 0));
            ItemUtils.editModifier(multimap, SharedMonsterAttributes.field_111264_e, Constants.ModAttributes.ATTACK_DAMAGE, toolStats.getAttackDamageAttribute());
            ItemUtils.editModifier(multimap, SharedMonsterAttributes.field_188790_f, Constants.ModAttributes.ATTACK_SPEED, toolStats.getAttackSpeed());
            multimap.put((Object)EntityPlayer.REACH_DISTANCE.func_111108_a(), (Object)new AttributeModifier(Constants.ModAttributes.REACH_DISTANCE, "Metallurgy Axe Reach Distance", toolStats.getReachDistance(), 0));
        }
    }

    public static Metal getMetalFromOreDictStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        int n = 0;
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        int[] nArray = ids;
        int n2 = nArray.length;
        if (n < n2) {
            int id = nArray[n];
            String ore = OreDictionary.getOreName((int)id);
            String snakeOre = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, ore);
            Object[] snakeArray = snakeOre.split("_");
            String metalName = String.join((CharSequence)"_", (CharSequence[])ArrayUtils.removeElement((Object[])snakeArray, (Object)snakeArray[0]));
            return ModMetals.metalMap.get(metalName);
        }
        return null;
    }
}

