/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.util;

import it.hurts.metallurgy_reforged.block.BlockTypes;
import it.hurts.metallurgy_reforged.block.ModBlocks;
import it.hurts.metallurgy_reforged.config.RegistrationConfig;
import it.hurts.metallurgy_reforged.item.ModItems;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.ModMetals;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MetallurgyTabs
extends CreativeTabs {
    public static final CreativeTabs tabArmor;
    public static final CreativeTabs tabBlock;
    public static final CreativeTabs tabDust;
    public static final CreativeTabs tabFluid;
    public static final CreativeTabs tabIngot;
    public static final CreativeTabs tabNugget;
    public static final CreativeTabs tabSpecial;
    public static final CreativeTabs tabOre;
    public static final CreativeTabs tabTool;
    private static final Optional<BlockTypes> firstEnabledBlockType;
    private static final Optional<EnumTools> firstEnabledToolType;
    private final int type;

    public MetallurgyTabs(int type, String name) {
        super(MetallurgyTabs.getUName(name));
        this.type = type;
    }

    private static String getUName(String name) {
        return "metallurgy." + name;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ItemStack func_78016_d() {
        if (this.type == 6) {
            return new ItemStack((Block)ModBlocks.crusher);
        }
        Optional<Metal> firstAvailableMetal = ModMetals.metalMap.values().stream().findFirst();
        if (!firstAvailableMetal.isPresent()) {
            return ItemStack.field_190927_a;
        }
        switch (this.type) {
            case 0: {
                return new ItemStack((Item)firstAvailableMetal.get().getArmorPiece(EntityEquipmentSlot.CHEST));
            }
            case 1: {
                return new ItemStack((Block)firstAvailableMetal.get().getBlock(firstEnabledBlockType.get()));
            }
            case 2: {
                return new ItemStack((Item)(RegistrationConfig.categoryItems.enableMetalDusts ? firstAvailableMetal.get().getDust() : ModItems.phosphorus));
            }
            case 3: {
                return FluidUtil.getFilledBucket((FluidStack)firstAvailableMetal.get().getMolten().getFluidStack());
            }
            case 4: {
                return new ItemStack((Item)firstAvailableMetal.get().getIngot());
            }
            case 5: {
                return new ItemStack((Item)firstAvailableMetal.get().getNugget());
            }
            case 7: {
                return ModMetals.ADAMANTINE != null ? new ItemStack((Block)Objects.requireNonNull(ModMetals.ADAMANTINE.getOre())) : ItemStack.field_190927_a;
            }
            case 8: {
                return new ItemStack(firstAvailableMetal.get().getTool(firstEnabledToolType.get()));
            }
        }
        return ItemStack.field_190927_a;
    }

    public void func_78018_a(@Nonnull NonNullList<ItemStack> p_78018_1_) {
        if (this.type == 3) {
            ModMetals.metalMap.forEach((s, metal) -> {
                if (FluidRegistry.getFluidName((Fluid)metal.getMolten()) != null) {
                    p_78018_1_.add((Object)FluidUtil.getFilledBucket((FluidStack)metal.getMolten().getFluidStack()));
                }
            });
        } else {
            super.func_78018_a(p_78018_1_);
        }
    }

    static {
        firstEnabledBlockType = Arrays.stream(BlockTypes.values()).filter(BlockTypes::isEnabled).findFirst();
        firstEnabledToolType = Arrays.stream(EnumTools.values()).filter(EnumTools::isEnabled).findFirst();
        tabArmor = RegistrationConfig.categoryItems.enableMetalArmorSets ? new MetallurgyTabs(0, "armors") : null;
        tabBlock = firstEnabledBlockType.isPresent() ? new MetallurgyTabs(1, "blocks") : null;
        tabDust = new MetallurgyTabs(2, "dusts");
        tabFluid = new MetallurgyTabs(3, "fluids");
        tabIngot = new MetallurgyTabs(4, "ingots");
        tabNugget = RegistrationConfig.categoryItems.enableMetalNuggets ? new MetallurgyTabs(5, "nuggets") : null;
        tabSpecial = new MetallurgyTabs(6, "special");
        tabOre = new MetallurgyTabs(7, "ores");
        tabTool = firstEnabledToolType.isPresent() ? new MetallurgyTabs(8, "tools") : null;
    }
}

