/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.world;

import gnu.trove.map.hash.TIntObjectHashMap;
import it.hurts.metallurgy_reforged.world.ModWorldGen;
import java.util.ArrayDeque;
import java.util.Random;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class WorldTickHandler {
    public static WorldTickHandler instance = new WorldTickHandler();
    public static TIntObjectHashMap<ArrayDeque<ChunkPos>> chunksToGenerate = new TIntObjectHashMap();

    @SubscribeEvent
    public void onTickEnd(TickEvent.WorldTickEvent event) {
        if (event.side != Side.SERVER) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            World world = event.world;
            int dimension = world.field_73011_w.getDimension();
            ArrayDeque chunks = (ArrayDeque)chunksToGenerate.get(dimension);
            if (chunks != null && !chunks.isEmpty()) {
                ChunkPos c = (ChunkPos)chunks.pollFirst();
                long worldSeed = world.func_72905_C();
                Random random = new Random(worldSeed);
                long xSeed = random.nextLong() >> 3;
                long zSeed = random.nextLong() >> 3;
                random.setSeed(xSeed * (long)c.field_77276_a + zSeed * (long)c.field_77275_b ^ worldSeed);
                ModWorldGen.instance.generateWorld(random, c.field_77276_a, c.field_77275_b, world, false);
                chunksToGenerate.put(dimension, (Object)chunks);
            } else if (chunks != null) {
                chunksToGenerate.remove(dimension);
            }
        }
    }
}

