/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.world.spawn;

import com.google.common.base.Predicate;
import it.hurts.metallurgy_reforged.world.spawn.IOreSpawn;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BaseOreSpawn
implements IOreSpawn {
    private final Block blockToReplace;
    private final ResourceLocation[] biomes;

    public BaseOreSpawn(Block blockToReplace, ResourceLocation[] biomes) {
        this.blockToReplace = blockToReplace;
        this.biomes = biomes;
    }

    @Override
    public boolean canOreSpawn(World world, BlockPos pos, IBlockState state, Random random) {
        return BaseOreSpawn.isInBiome(world, pos, this.biomes);
    }

    @Override
    public Predicate<IBlockState> getBlockPredicate() {
        return BlockMatcher.func_177642_a((Block)this.blockToReplace);
    }

    private static boolean isInBiome(World world, BlockPos pos, ResourceLocation[] biomes) {
        if (biomes.length == 0) {
            return true;
        }
        for (ResourceLocation biome : biomes) {
            if (!world.func_180494_b(pos).getRegistryName().equals((Object)biome)) continue;
            return true;
        }
        return false;
    }
}

