/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.minesafety;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.doubledoordev.minesafety.ItemDepthGauge;
import net.doubledoordev.minesafety.MineSafetyConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod(value="minesafety")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MineSafety {
    private Random random = new Random();
    private static ItemDepthGauge depthGauge = new ItemDepthGauge(new Item.Properties().func_200916_a(ItemGroup.field_78040_i));
    private DamageSource UNSAFE_MINE = new DamageSource("mineSafetyUnsafeY").func_76351_m();
    private String NBTKey = "minesafetyCooldown";

    @SubscribeEvent
    public static void onRegisterItem(RegistryEvent.Register<Item> event) {
        event.getRegistry().register(depthGauge.setRegistryName("depthgauge"));
    }

    public MineSafety() {
        MinecraftForge.EVENT_BUS.register(MineSafetyConfig.class);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, MineSafetyConfig.spec);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void drawTextEvent(RenderGameOverlayEvent.Text event) {
        Minecraft mc = Minecraft.func_71410_x();
        ArrayList list = event.getLeft();
        int yPos = mc.field_71439_g.func_180425_c().func_177956_o();
        for (int i = 0; i < 35; ++i) {
            if (!mc.field_71439_g.field_71071_by.func_70301_a(i).func_77969_a(new ItemStack((IItemProvider)depthGauge))) continue;
            if (yPos <= (Integer)MineSafetyConfig.GENERAL.yLevel.get()) {
                list.add("\u00a74Y=" + yPos);
                continue;
            }
            list.add("Y=" + yPos);
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END || event.side.isClient()) {
            return;
        }
        if ((double)this.random.nextFloat() < (Double)MineSafetyConfig.GENERAL.chance.get()) {
            return;
        }
        PlayerEntity player = event.player;
        CompoundNBT data = player.getPersistentData();
        int coolDown = data.func_74762_e(this.NBTKey);
        if (player.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() instanceof ArmorItem) {
            return;
        }
        if (!data.func_74764_b(this.NBTKey)) {
            data.func_74768_a(this.NBTKey, 20 * (Integer)MineSafetyConfig.GENERAL.timeout.get());
        }
        if (player.field_70163_u <= (double)((Integer)MineSafetyConfig.GENERAL.yLevel.get()).intValue() && !player.func_130014_f_().func_175710_j(new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v)) && coolDown == 0) {
            if (!((List)MineSafetyConfig.GENERAL.dimBlacklist.get()).isEmpty()) {
                Iterator iterator = ((List)MineSafetyConfig.GENERAL.dimBlacklist.get()).iterator();
                while (iterator.hasNext()) {
                    int dim = (Integer)iterator.next();
                    if (player.field_70170_p.field_73011_w.func_186058_p().func_186068_a() == dim) continue;
                    this.damagePlayerAndNotify(data, player);
                }
            } else {
                this.damagePlayerAndNotify(data, player);
            }
        } else if (coolDown < 0) {
            data.func_74768_a(this.NBTKey, 0);
        } else {
            data.func_74768_a(this.NBTKey, coolDown - 1);
        }
    }

    private void damagePlayerAndNotify(CompoundNBT compoundNBT, PlayerEntity player) {
        if (player.func_70097_a(this.UNSAFE_MINE, 1.0f + 0.2f * this.random.nextFloat())) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent((String)MineSafetyConfig.GENERAL.message.get(), new Object[0]){}, true);
            compoundNBT.func_74768_a(this.NBTKey, 20 * (Integer)MineSafetyConfig.GENERAL.timeout.get());
        }
    }
}

