/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.minesafety;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class MineSafetyConfig {
    public static final General GENERAL;
    static final ForgeConfigSpec spec;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(General::new);
        spec = (ForgeConfigSpec)specPair.getRight();
        GENERAL = (General)specPair.getLeft();
    }

    public static class General {
        public ForgeConfigSpec.IntValue yLevel;
        public ForgeConfigSpec.IntValue timeout;
        public ForgeConfigSpec.DoubleValue chance;
        public ForgeConfigSpec.ConfigValue<List<? extends Integer>> dimBlacklist;
        public ForgeConfigSpec.ConfigValue<String> message;

        public static List<? extends Integer> dimBlacklistList() {
            return new ArrayList();
        }

        General(ForgeConfigSpec.Builder builder) {
            builder.comment("General configuration settings").push("General");
            this.yLevel = builder.comment("The Y level at which you should wear a helmet.").translation("minesafety.config.yLevel").defineInRange("yLevel", 50, 0, 256);
            this.timeout = builder.comment("The minimum time in seconds between 2 hits from this mod.").translation("minesafety.config.timeout").defineInRange("timeout", 1, 0, Integer.MAX_VALUE);
            this.chance = builder.comment("The chance you get damaged this tick, in percent.").translation("minesafety.config.chance").defineInRange("chance", 0.03, 0.0, 1.0);
            this.dimBlacklist = builder.comment("Dimension damage BLACKLIST, MineSafety damage will be disabled in these dimensions only!").translation("minesafety.config.dimlist").defineList("dimBlacklist", General.dimBlacklistList(), p -> p instanceof Integer);
            this.message = builder.comment("The message displayed in-game when user takes damage from no helmet.").translation("minesafety.config.message").define("message", (Object)"Ouch! Falling rocks... I should wear a helmet.");
        }
    }
}

