/*
 * Decompiled with CFR 0.152.
 */
package com.bespectacled.modernbeta.biome;

import com.bespectacled.modernbeta.biome.BetaBiomes;
import com.bespectacled.modernbeta.biome.IOldBiomeSource;
import com.bespectacled.modernbeta.biome.layer.BetaBiomeLayer;
import com.bespectacled.modernbeta.biome.layer.BetaOceanLayer;
import com.bespectacled.modernbeta.util.BiomeUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3642;
import net.minecraft.class_5321;
import net.minecraft.class_5505;

public class BetaBiomeSource
extends class_1966
implements IOldBiomeSource {
    public static final Codec<BetaBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(betaBiomeSource -> betaBiomeSource.seed), (App)class_5505.method_31148((class_5321)class_2378.field_25114).forGetter(betaBiomeSource -> betaBiomeSource.biomeRegistry), (App)class_2487.field_25128.fieldOf("settings").forGetter(settings -> settings.settings)).apply((Applicative)instance, instance.stable(BetaBiomeSource::new)));
    private final long seed;
    public final class_2378<class_1959> biomeRegistry;
    private final class_2487 settings;
    private final class_3642 biomeSampler;
    private final class_3642 oceanSampler;
    private static class_1959[] landBiomeLookupTable = new class_1959[4096];
    private static class_1959[] oceanBiomeLookupTable = new class_1959[4096];
    private final Map<String, class_2960> biomeMappings;
    private boolean generateOceans = false;
    private boolean generateBetaOceans = true;
    private boolean generateIceDesert = false;
    private boolean generateSkyDim = false;
    private boolean generateVanillaBiomesBeta = false;
    private static final double[] TEMP_HUMID_POINT = new double[2];

    public BetaBiomeSource(long seed, class_2378<class_1959> registry, class_2487 settings) {
        super(BetaBiomes.getBiomeList(settings.method_10545("generateVanillaBiomesBeta") ? settings.method_10577("generateVanillaBiomesBeta") : false).stream().map(registryKey -> () -> (class_1959)registry.method_29107(registryKey)));
        this.seed = seed;
        this.biomeRegistry = registry;
        this.settings = settings;
        if (settings.method_10545("generateOceans")) {
            this.generateOceans = settings.method_10577("generateOceans");
        }
        if (settings.method_10545("generateBetaOceans")) {
            this.generateBetaOceans = settings.method_10577("generateBetaOceans");
        }
        if (settings.method_10545("generateIceDesert")) {
            this.generateIceDesert = settings.method_10577("generateIceDesert");
        }
        if (settings.method_10545("generateSkyDim")) {
            this.generateSkyDim = settings.method_10577("generateSkyDim");
        }
        if (settings.method_10545("generateVanillaBiomesBeta")) {
            this.generateVanillaBiomesBeta = settings.method_10577("generateVanillaBiomesBeta");
        }
        this.biomeMappings = BetaBiomes.BETA_MAPPINGS;
        this.biomeSampler = this.generateVanillaBiomesBeta ? BetaBiomeLayer.build(seed, false, 4, -1) : null;
        this.oceanSampler = this.generateVanillaBiomesBeta ? BetaOceanLayer.build(seed, false, 6, -1) : null;
        BiomeUtil.setSeed(this.seed);
        this.generateBiomeLookup(registry);
    }

    public class_1959 method_16359(int biomeX, int biomeY, int biomeZ) {
        int absX = biomeX << 2;
        int absZ = biomeZ << 2;
        if (this.generateSkyDim) {
            return (class_1959)this.biomeRegistry.method_10223(BetaBiomes.SKY_ID);
        }
        if (this.generateVanillaBiomesBeta) {
            return this.biomeSampler.method_16341(this.biomeRegistry, biomeX, biomeZ);
        }
        BiomeUtil.fetchTempHumidAtPoint(TEMP_HUMID_POINT, absX, absZ);
        return this.fetchBiome(TEMP_HUMID_POINT[0], TEMP_HUMID_POINT[1], BetaBiomes.BiomeType.LAND);
    }

    @Override
    public class_1959 getOceanBiomeForNoiseGen(int biomeX, int biomeZ) {
        int absX = biomeX << 2;
        int absZ = biomeZ << 2;
        if (this.generateVanillaBiomesBeta) {
            return this.oceanSampler.method_16341(this.biomeRegistry, biomeX, biomeZ);
        }
        return this.getLayeredBiomeForNoiseGen(absX, 0, absZ, BetaBiomes.BiomeType.OCEAN);
    }

    private class_1959 getLayeredBiomeForNoiseGen(int x, int y, int z, BetaBiomes.BiomeType type) {
        BiomeUtil.fetchTempHumidAtPoint(TEMP_HUMID_POINT, x, z);
        if (this.generateBetaOceans || this.generateOceans) {
            return this.fetchBiome(TEMP_HUMID_POINT[0], TEMP_HUMID_POINT[1], type);
        }
        return this.fetchBiome(TEMP_HUMID_POINT[0], TEMP_HUMID_POINT[1], BetaBiomes.BiomeType.LAND);
    }

    private class_1959 fetchBiome(double temp, double humid, BetaBiomes.BiomeType type) {
        return this.getBiomeFromLookup(temp, humid, type);
    }

    public void fetchBiomes(double[] temps, double[] humids, class_1959[] landBiomes, class_1959[] oceanBiomes) {
        int sizeX = 16;
        int sizeZ = 16;
        for (int i = 0; i < sizeX * sizeZ; ++i) {
            if (landBiomes != null) {
                landBiomes[i] = this.getBiomeFromLookup(temps[i], humids[i], BetaBiomes.BiomeType.LAND);
            }
            if (oceanBiomes == null) continue;
            oceanBiomes[i] = this.getBiomeFromLookup(temps[i], humids[i], BetaBiomes.BiomeType.OCEAN);
        }
    }

    private void generateBiomeLookup(class_2378<class_1959> registry) {
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                BetaBiomeSource.landBiomeLookupTable[i + j * 64] = this.getBiome((float)i / 63.0f, (float)j / 63.0f, registry, BetaBiomes.BiomeType.LAND);
                BetaBiomeSource.oceanBiomeLookupTable[i + j * 64] = this.getOceanBiome((float)i / 63.0f, (float)j / 63.0f, registry);
            }
        }
    }

    private class_1959 getBiomeFromLookup(double temp, double humid, BetaBiomes.BiomeType type) {
        int i = (int)(temp * 63.0);
        int j = (int)(humid * 63.0);
        class_1959 biome = landBiomeLookupTable[i + j * 64];
        switch (type) {
            case OCEAN: {
                biome = oceanBiomeLookupTable[i + j * 64];
            }
        }
        return biome;
    }

    private class_1959 getBiome(float temp, float humid, class_2378<class_1959> registry, BetaBiomes.BiomeType type) {
        Map<String, class_2960> mappings = this.biomeMappings;
        humid *= temp;
        if (this.generateSkyDim) {
            return (class_1959)registry.method_10223(BetaBiomes.SKY_ID);
        }
        if (temp < 0.1f) {
            if (this.generateIceDesert) {
                return (class_1959)registry.method_10223(mappings.get("ice_desert"));
            }
            return (class_1959)registry.method_10223(mappings.get("tundra"));
        }
        if (humid < 0.2f) {
            if (temp < 0.5f) {
                return (class_1959)registry.method_10223(mappings.get("tundra"));
            }
            if (temp < 0.95f) {
                return (class_1959)registry.method_10223(mappings.get("savanna"));
            }
            return (class_1959)registry.method_10223(mappings.get("desert"));
        }
        if (humid > 0.5f && temp < 0.7f) {
            return (class_1959)registry.method_10223(mappings.get("swampland"));
        }
        if (temp < 0.5f) {
            return (class_1959)registry.method_10223(mappings.get("taiga"));
        }
        if (temp < 0.97f) {
            if (humid < 0.35f) {
                return (class_1959)registry.method_10223(mappings.get("shrubland"));
            }
            return (class_1959)registry.method_10223(mappings.get("forest"));
        }
        if (humid < 0.45f) {
            return (class_1959)registry.method_10223(mappings.get("plains"));
        }
        if (humid < 0.9f) {
            return (class_1959)registry.method_10223(mappings.get("seasonal_forest"));
        }
        return (class_1959)registry.method_10223(mappings.get("rainforest"));
    }

    private class_1959 getOceanBiome(float temp, float humid, class_2378<class_1959> registry) {
        humid *= temp;
        if (temp < 0.1f) {
            return (class_1959)registry.method_10223(this.biomeMappings.get("frozen_ocean"));
        }
        if (humid < 0.2f) {
            if (temp < 0.5f) {
                return (class_1959)registry.method_10223(this.biomeMappings.get("frozen_ocean"));
            }
            if (temp < 0.95f) {
                return (class_1959)registry.method_10223(this.biomeMappings.get("ocean"));
            }
            return (class_1959)registry.method_10223(this.biomeMappings.get("ocean"));
        }
        if (humid > 0.5f && temp < 0.7f) {
            return (class_1959)registry.method_10223(this.biomeMappings.get("cold_ocean"));
        }
        if (temp < 0.5f) {
            return (class_1959)registry.method_10223(this.biomeMappings.get("frozen_ocean"));
        }
        if (temp < 0.97f) {
            if (humid < 0.35f) {
                return (class_1959)registry.method_10223(this.biomeMappings.get("ocean"));
            }
            return (class_1959)registry.method_10223(this.biomeMappings.get("ocean"));
        }
        if (humid < 0.45f) {
            return (class_1959)registry.method_10223(this.biomeMappings.get("ocean"));
        }
        if (humid < 0.9f) {
            return (class_1959)registry.method_10223(this.biomeMappings.get("lukewarm_ocean"));
        }
        return (class_1959)registry.method_10223(this.biomeMappings.get("warm_ocean"));
    }

    public boolean isSkyDim() {
        return this.generateSkyDim;
    }

    public boolean method_8754(class_3195<?> structureFeature) {
        return this.field_9392.computeIfAbsent(structureFeature, s -> this.field_20643.stream().anyMatch(biome -> biome.method_30970().method_30980(s)));
    }

    @Override
    public boolean usesVanillaBiomes() {
        return this.generateVanillaBiomesBeta;
    }

    protected Codec<? extends class_1966> method_28442() {
        return CODEC;
    }

    @Environment(value=EnvType.CLIENT)
    public class_1966 method_27985(long seed) {
        return new BetaBiomeSource(seed, this.biomeRegistry, this.settings);
    }

    public static void register() {
        class_2378.method_10230((class_2378)class_2378.field_25096, (class_2960)new class_2960("modern_beta", "beta_biome_source"), CODEC);
    }
}

