/*
 * Decompiled with CFR 0.152.
 */
package com.bespectacled.modernbeta.biome;

import com.bespectacled.modernbeta.biome.IndevBiomes;
import com.bespectacled.modernbeta.util.IndevUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5505;

public class IndevBiomeSource
extends class_1966 {
    public static final Codec<IndevBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(indevBiomeSource -> indevBiomeSource.seed), (App)class_5505.method_31148((class_5321)class_2378.field_25114).forGetter(indevBiomeSource -> indevBiomeSource.biomeRegistry), (App)class_2487.field_25128.fieldOf("settings").forGetter(indevBiomeSource -> indevBiomeSource.settings)).apply((Applicative)instance, instance.stable(IndevBiomeSource::new)));
    private final long seed;
    public final class_2378<class_1959> biomeRegistry;
    private final class_2487 settings;
    private IndevUtil.Type type;
    private IndevUtil.Theme theme;
    private int width;
    private int length;
    private int height;

    public IndevBiomeSource(long seed, class_2378<class_1959> registry, class_2487 settings) {
        super(IndevBiomes.getBiomeList().stream().map(registryKey -> () -> (class_1959)registry.method_29107(registryKey)));
        this.seed = seed;
        this.biomeRegistry = registry;
        this.settings = settings;
        this.theme = IndevUtil.Theme.NORMAL;
        this.type = IndevUtil.Type.ISLAND;
        this.width = 256;
        this.length = 256;
        this.height = 128;
        if (this.settings.method_10545("levelType")) {
            this.type = IndevUtil.Type.values()[settings.method_10550("levelType")];
        }
        if (this.settings.method_10545("levelTheme")) {
            this.theme = IndevUtil.Theme.values()[settings.method_10550("levelTheme")];
        }
        if (this.settings.method_10545("levelWidth")) {
            this.width = settings.method_10550("levelWidth");
        }
        if (this.settings.method_10545("levelLength")) {
            this.length = settings.method_10550("levelLength");
        }
        if (this.settings.method_10545("levelHeight")) {
            this.height = settings.method_10550("levelHeight");
        }
    }

    public class_1959 method_16359(int biomeX, int biomeY, int biomeZ) {
        class_1959 biome;
        int absX = biomeX << 2;
        int absZ = biomeZ << 2;
        if (IndevUtil.inIndevRegion(absX, absZ, this.width, this.length)) {
            switch (this.theme) {
                case NORMAL: {
                    biome = (class_1959)this.biomeRegistry.method_10223(IndevBiomes.INDEV_NORMAL_ID);
                    break;
                }
                case HELL: {
                    biome = (class_1959)this.biomeRegistry.method_10223(IndevBiomes.INDEV_HELL_ID);
                    break;
                }
                case PARADISE: {
                    biome = (class_1959)this.biomeRegistry.method_10223(IndevBiomes.INDEV_PARADISE_ID);
                    break;
                }
                case WOODS: {
                    biome = (class_1959)this.biomeRegistry.method_10223(IndevBiomes.INDEV_WOODS_ID);
                    break;
                }
                case SNOWY: {
                    biome = (class_1959)this.biomeRegistry.method_10223(IndevBiomes.INDEV_SNOWY_ID);
                    break;
                }
                default: {
                    biome = (class_1959)this.biomeRegistry.method_10223(IndevBiomes.INDEV_NORMAL_ID);
                    break;
                }
            }
        } else {
            switch (this.theme) {
                case NORMAL: {
                    biome = (class_1959)this.biomeRegistry.method_10223(IndevBiomes.INDEV_EDGE_ID);
                    break;
                }
                case HELL: {
                    biome = (class_1959)this.biomeRegistry.method_10223(IndevBiomes.INDEV_HELL_EDGE_ID);
                    break;
                }
                case PARADISE: {
                    biome = (class_1959)this.biomeRegistry.method_10223(IndevBiomes.INDEV_PARADISE_EDGE_ID);
                    break;
                }
                case WOODS: {
                    biome = (class_1959)this.biomeRegistry.method_10223(IndevBiomes.INDEV_WOODS_EDGE_ID);
                    break;
                }
                case SNOWY: {
                    biome = (class_1959)this.biomeRegistry.method_10223(IndevBiomes.INDEV_SNOWY_EDGE_ID);
                    break;
                }
                default: {
                    biome = (class_1959)this.biomeRegistry.method_10223(IndevBiomes.INDEV_EDGE_ID);
                }
            }
        }
        return biome;
    }

    protected Codec<? extends class_1966> method_28442() {
        return CODEC;
    }

    @Environment(value=EnvType.CLIENT)
    public class_1966 method_27985(long seed) {
        return new IndevBiomeSource(seed, this.biomeRegistry, this.settings);
    }

    public static void register() {
        class_2378.method_10230((class_2378)class_2378.field_25096, (class_2960)new class_2960("modern_beta", "indev_biome_source"), CODEC);
    }
}

