/*
 * Decompiled with CFR 0.152.
 */
package com.bespectacled.modernbeta.biome;

import com.bespectacled.modernbeta.biome.IOldBiomeSource;
import com.bespectacled.modernbeta.biome.InfdevBiomes;
import com.bespectacled.modernbeta.biome.layer.BetaBiomeLayer;
import com.bespectacled.modernbeta.biome.layer.BetaOceanLayer;
import com.bespectacled.modernbeta.util.BiomeUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3642;
import net.minecraft.class_5321;
import net.minecraft.class_5505;

public class InfdevBiomeSource
extends class_1966
implements IOldBiomeSource {
    public static final Codec<InfdevBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(infdevBiomeSource -> infdevBiomeSource.seed), (App)class_5505.method_31148((class_5321)class_2378.field_25114).forGetter(infdevBiomeSource -> infdevBiomeSource.biomeRegistry), (App)class_2487.field_25128.fieldOf("settings").forGetter(infdevBiomeSource -> infdevBiomeSource.settings)).apply((Applicative)instance, instance.stable(InfdevBiomeSource::new)));
    private final long seed;
    public final class_2378<class_1959> biomeRegistry;
    private final class_2487 settings;
    private final class_3642 biomeSampler;
    private final class_3642 oceanSampler;
    private boolean infdevWinterMode = false;
    private boolean infdevPlus = false;
    private boolean generateVanillaBiomesInfdev = false;
    private static final double[] TEMP_HUMID_POINT = new double[2];

    public InfdevBiomeSource(long seed, class_2378<class_1959> registry, class_2487 settings) {
        super(InfdevBiomes.getBiomeList(settings.method_10545("generateVanillaBiomesInfdev") ? settings.method_10577("generateVanillaBiomesInfdev") : false).stream().map(registryKey -> () -> (class_1959)registry.method_29107(registryKey)));
        this.seed = seed;
        this.biomeRegistry = registry;
        this.settings = settings;
        this.infdevWinterMode = false;
        this.infdevPlus = false;
        if (settings.method_10545("infdevWinterMode")) {
            this.infdevWinterMode = settings.method_10577("infdevWinterMode");
        }
        if (settings.method_10545("infdevPlus")) {
            this.infdevPlus = settings.method_10577("infdevPlus");
        }
        if (settings.method_10545("generateVanillaBiomesInfdev")) {
            this.generateVanillaBiomesInfdev = settings.method_10577("generateVanillaBiomesInfdev");
        }
        this.biomeSampler = this.generateVanillaBiomesInfdev ? BetaBiomeLayer.build(seed, false, 4, -1) : null;
        this.oceanSampler = this.generateVanillaBiomesInfdev ? BetaOceanLayer.build(seed, false, 6, -1) : null;
        BiomeUtil.setSeed(this.seed);
    }

    public class_1959 method_16359(int biomeX, int biomeY, int biomeZ) {
        class_1959 biome;
        int absX = biomeX << 2;
        int absZ = biomeZ << 2;
        if (this.generateVanillaBiomesInfdev) {
            biome = this.biomeSampler.method_16341(this.biomeRegistry, biomeX, biomeZ);
        } else if (this.infdevPlus) {
            BiomeUtil.fetchTempHumidAtPoint(TEMP_HUMID_POINT, absX, absZ);
            biome = InfdevBiomeSource.getBiome((float)TEMP_HUMID_POINT[0], (float)TEMP_HUMID_POINT[1], this.biomeRegistry);
        } else {
            biome = this.infdevWinterMode ? (class_1959)this.biomeRegistry.method_10223(InfdevBiomes.INFDEV_WINTER_ID) : (class_1959)this.biomeRegistry.method_10223(InfdevBiomes.INFDEV_ID);
        }
        return biome;
    }

    @Override
    public class_1959 getOceanBiomeForNoiseGen(int biomeX, int biomeZ) {
        return this.oceanSampler.method_16341(this.biomeRegistry, biomeX, biomeZ);
    }

    public static class_1959 getBiome(float temp, float humid, class_2378<class_1959> registry) {
        if (temp < 0.5f) {
            return (class_1959)registry.method_10223(InfdevBiomes.INFDEV_WINTER_ID);
        }
        return (class_1959)registry.method_10223(InfdevBiomes.INFDEV_ID);
    }

    protected Codec<? extends class_1966> method_28442() {
        return CODEC;
    }

    @Environment(value=EnvType.CLIENT)
    public class_1966 method_27985(long seed) {
        return new InfdevBiomeSource(seed, this.biomeRegistry, this.settings);
    }

    public static void register() {
        class_2378.method_10230((class_2378)class_2378.field_25096, (class_2960)new class_2960("modern_beta", "infdev_biome_source"), CODEC);
    }

    @Override
    public boolean usesVanillaBiomes() {
        return this.generateVanillaBiomesInfdev;
    }
}

