/*
 * Decompiled with CFR 0.152.
 */
package com.bespectacled.modernbeta.carver;

import com.mojang.serialization.Codec;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2939;
import net.minecraft.class_3133;
import net.minecraft.class_3532;

public class BetaCaveCarver
extends class_2939<class_3133> {
    public BetaCaveCarver(Codec<class_3133> codec, int heightLimit) {
        super(codec, heightLimit);
    }

    public boolean shouldCarve(Random random, int chunkX, int chunkZ, class_3133 config) {
        return true;
    }

    public boolean carve(class_2791 chunk, Function<class_2338, class_1959> posToBiome, Random random, int seaLevel, int chunkX, int chunkZ, int mainChunkX, int mainChunkZ, BitSet carvingMask, class_3133 carverConfig) {
        int caveCount = random.nextInt(random.nextInt(random.nextInt(40) + 1) + 1);
        if (random.nextInt(this.getMaxCaveCount()) != 0) {
            caveCount = 0;
        }
        for (int i = 0; i < caveCount; ++i) {
            double x = chunkX * 16 + random.nextInt(16);
            double y = this.getCaveY(random);
            double z = chunkZ * 16 + random.nextInt(16);
            int tunnelCount = 1;
            if (random.nextInt(4) == 0) {
                this.carveCave(chunk, random, mainChunkX, mainChunkZ, x, y, z);
                tunnelCount += random.nextInt(4);
            }
            for (int j = 0; j < tunnelCount; ++j) {
                float f = random.nextFloat() * 3.141593f * 2.0f;
                float f1 = (random.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float tunnelSysWidth = this.getTunnelSystemWidth(random);
                this.carveTunnels(chunk, random, mainChunkX, mainChunkZ, x, y, z, tunnelSysWidth, f, f1, 0, 0, 1.0);
            }
        }
        return false;
    }

    protected void carveCave(class_2791 chunk, Random random, int mainChunkX, int mainChunkZ, double x, double y, double z) {
        this.carveTunnels(chunk, random, mainChunkX, mainChunkZ, x, y, z, 1.0f + random.nextFloat() * 6.0f, 0.0f, 0.0f, -1, -1, 0.5);
    }

    protected void carveTunnels(class_2791 chunk, Random rand, int mainChunkX, int mainChunkZ, double x, double y, double z, float tunnelSysWidth, float f1, float f2, int branch, int branchCount, double tunnelWHRatio) {
        boolean vary;
        float f3 = 0.0f;
        float f4 = 0.0f;
        Random random = new Random(rand.nextLong());
        if (branchCount <= 0) {
            int someNumMaxStarts = 112;
            branchCount = someNumMaxStarts - random.nextInt(someNumMaxStarts / 4);
        }
        boolean noStarts = false;
        if (branch == -1) {
            branch = branchCount / 2;
            noStarts = true;
        }
        int randBranch = random.nextInt(branchCount / 2) + branchCount / 4;
        boolean bl = vary = random.nextInt(6) == 0;
        while (branch < branchCount) {
            double yaw = 1.5 + (double)(class_3532.method_15374((float)((float)branch * 3.141593f / (float)branchCount)) * tunnelSysWidth * 1.0f);
            double pitch = yaw * tunnelWHRatio;
            float f5 = class_3532.method_15362((float)f2);
            float f6 = class_3532.method_15374((float)f2);
            x += (double)(class_3532.method_15362((float)f1) * f5);
            y += (double)f6;
            z += (double)(class_3532.method_15374((float)f1) * f5);
            f2 *= vary ? 0.92f : 0.7f;
            f2 += f4 * 0.1f;
            f1 += f3 * 0.1f;
            f4 *= 0.9f;
            f3 *= 0.75f;
            f4 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f3 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (!noStarts && branch == randBranch && tunnelSysWidth > 1.0f) {
                this.carveTunnels(chunk, rand, mainChunkX, mainChunkZ, x, y, z, random.nextFloat() * 0.5f + 0.5f, f1 - 1.570796f, f2 / 3.0f, branch, branchCount, 1.0);
                this.carveTunnels(chunk, rand, mainChunkX, mainChunkZ, x, y, z, random.nextFloat() * 0.5f + 0.5f, f1 + 1.570796f, f2 / 3.0f, branch, branchCount, 1.0);
                return;
            }
            if (noStarts || random.nextInt(4) != 0) {
                if (!this.method_12707(mainChunkX, mainChunkZ, x, z, branch, branchCount, tunnelSysWidth)) {
                    return;
                }
                this.method_16580(chunk, null, 0L, 64, mainChunkX, mainChunkZ, x, y, z, yaw, pitch, null);
                if (noStarts) break;
            }
            ++branch;
        }
    }

    protected boolean method_16580(class_2791 chunk, Function<class_2338, class_1959> posToBiome, long seed, int seaLevel, int mainChunkX, int mainChunkZ, double x, double y, double z, double yaw, double pitch, BitSet carvingMask) {
        double ctrX = mainChunkX * 16 + 8;
        double ctrZ = mainChunkZ * 16 + 8;
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        if (x < ctrX - 16.0 - yaw * 2.0 || z < ctrZ - 16.0 - yaw * 2.0 || x > ctrX + 16.0 + yaw * 2.0 || z > ctrZ + 16.0 + yaw * 2.0) {
            return false;
        }
        int minX = class_3532.method_15357((double)(x - yaw)) - mainChunkX * 16 - 1;
        int maxX = class_3532.method_15357((double)(x + yaw)) - mainChunkX * 16 + 1;
        int minY = class_3532.method_15357((double)(y - pitch)) - 1;
        int maxY = class_3532.method_15357((double)(y + pitch)) + 1;
        int minZ = class_3532.method_15357((double)(z - yaw)) - mainChunkZ * 16 - 1;
        int maxZ = class_3532.method_15357((double)(z + yaw)) - mainChunkZ * 16 + 1;
        if (minX < 0) {
            minX = 0;
        }
        if (maxX > 16) {
            maxX = 16;
        }
        if (minY < 1) {
            minY = 1;
        }
        if (maxY > 120) {
            maxY = 120;
        }
        if (minZ < 0) {
            minZ = 0;
        }
        if (maxZ > 16) {
            maxZ = 16;
        }
        if (super.method_12711(chunk, mainChunkX, mainChunkZ, minX, maxX, minY, maxY, minZ, maxZ)) {
            return false;
        }
        for (int relX = minX; relX < maxX; ++relX) {
            double scaledRelX = ((double)(relX + mainChunkX * 16) + 0.5 - x) / yaw;
            for (int relZ = minZ; relZ < maxZ; ++relZ) {
                double scaledRelZ = ((double)(relZ + mainChunkZ * 16) + 0.5 - z) / yaw;
                boolean isGrassBlock = false;
                int setY = maxY;
                for (int relY = maxY - 1; relY >= minY; --relY) {
                    double scaledRelY = ((double)relY + 0.5 - y) / pitch;
                    if (this.method_16582(scaledRelX, scaledRelY, scaledRelZ, -1)) {
                        class_2248 block = chunk.method_8320(new class_2338(relX, setY, relZ)).method_26204();
                        if (block == class_2246.field_10219) {
                            isGrassBlock = true;
                        }
                        if (block == class_2246.field_10340 || block == class_2246.field_10566 || block == class_2246.field_10219) {
                            if (relY < 10) {
                                chunk.method_12010((class_2338)blockPos.method_10103(relX, setY, relZ), class_2246.field_10164.method_9564(), false);
                            } else {
                                chunk.method_12010((class_2338)blockPos.method_10103(relX, setY, relZ), class_2246.field_10543.method_9564(), false);
                                if (isGrassBlock && chunk.method_8320(new class_2338(relX, setY - 1, relZ)).method_26204() == class_2246.field_10566) {
                                    chunk.method_12010((class_2338)blockPos.method_10103(relX, setY - 1, relZ), class_2246.field_10219.method_9564(), false);
                                }
                            }
                        }
                    }
                    --setY;
                }
            }
        }
        return true;
    }

    protected boolean method_12707(int mainChunkX, int mainChunkZ, double x, double z, int branch, int branchCount, float baseWidth) {
        double ctrX = mainChunkX * 16 + 8;
        double d1 = x - ctrX;
        double ctrZ = mainChunkZ * 16 + 8;
        double d2 = z - ctrZ;
        double d3 = branchCount - branch;
        double d4 = baseWidth + 2.0f + 16.0f;
        return !(d1 * d1 + d2 * d2 - d3 * d3 > d4 * d4);
    }

    protected boolean method_12711(class_2791 chunk, int mainChunkX, int mainChunkZ, int relMinX, int relMaxX, int minY, int maxY, int relMinZ, int relMaxZ) {
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        for (int relX = relMinX; relX < relMaxX; ++relX) {
            for (int relZ = relMinZ; relZ < relMaxZ; ++relZ) {
                for (int relY = maxY + 1; relY >= minY - 1; --relY) {
                    if (relY < 0 || relY >= 128) continue;
                    class_2248 block = chunk.method_8320((class_2338)blockPos.method_10103(relX, relY, relZ)).method_26204();
                    if (block.equals(class_2246.field_10382)) {
                        return true;
                    }
                    if (relY == minY - 1 || !this.isOnBoundary(relMinX, relMaxX, relMinZ, relMaxZ, relX, relZ)) continue;
                    relY = minY;
                }
            }
        }
        return false;
    }

    protected boolean method_16582(double scaledRelativeX, double scaledRelativeY, double scaledRelativeZ, int y) {
        return scaledRelativeY > -0.7 && scaledRelativeX * scaledRelativeX + scaledRelativeY * scaledRelativeY + scaledRelativeZ * scaledRelativeZ < 1.0;
    }

    private boolean isOnBoundary(int minX, int maxX, int minZ, int maxZ, int relX, int relZ) {
        return relX != minX && relX != maxX - 1 && relZ != minZ && relZ != maxZ - 1;
    }

    protected int getMaxCaveCount() {
        return 15;
    }

    protected int getCaveY(Random random) {
        return random.nextInt(random.nextInt(120) + 8);
    }

    protected float getTunnelSystemWidth(Random random) {
        float width = random.nextFloat() * 2.0f + random.nextFloat();
        return width;
    }
}

