/*
 * Decompiled with CFR 0.152.
 */
package com.bespectacled.modernbeta.carver;

import com.mojang.serialization.Codec;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2939;
import net.minecraft.class_3133;
import net.minecraft.class_3532;

public class IndevCaveCarver
extends class_2939<class_3133> {
    private float radius;

    public IndevCaveCarver(Codec<class_3133> codec, int heightLimit, float radius) {
        super(codec, heightLimit);
        this.radius = radius;
    }

    public boolean shouldCarve(Random random, int chunkX, int chunkZ, class_3133 config) {
        return random.nextFloat() <= config.field_13738;
    }

    public boolean carve(class_2791 chunk, Function<class_2338, class_1959> posToBiome, Random random, int seaLevel, int chunkX, int chunkZ, int mainChunkX, int mainChunkZ, BitSet carvingMask, class_3133 carverConfig) {
        random = new Random();
        float caveX = chunkX * 16 + random.nextInt(16);
        float caveY = this.getCaveY(random);
        float caveZ = chunkZ * 16 + random.nextInt(16);
        int caveLen = (int)((random.nextFloat() + random.nextFloat()) * 200.0f);
        float theta = random.nextFloat() * (float)Math.PI * 2.0f;
        float phi = random.nextFloat() * (float)Math.PI * 2.0f;
        float caveRadius = random.nextFloat() * random.nextFloat() * this.radius;
        this.carveTunnels(chunk, random, mainChunkX, mainChunkZ, caveX, caveY, caveZ, caveLen, caveRadius, theta, phi);
        return true;
    }

    protected void carveTunnels(class_2791 chunk, Random random, int mainChunkX, int mainChunkZ, double caveX, double caveY, double caveZ, float caveLen, float caveRadius, float theta, float phi) {
        float deltaTheta = 0.0f;
        float deltaPhi = 0.0f;
        int len = 0;
        while ((float)len < caveLen) {
            caveX += (double)(class_3532.method_15374((float)theta) * class_3532.method_15362((float)phi));
            caveZ += (double)(class_3532.method_15362((float)theta) * class_3532.method_15362((float)phi));
            caveY += (double)class_3532.method_15374((float)phi);
            theta += deltaTheta * 0.2f;
            deltaTheta = deltaTheta * 0.9f + (random.nextFloat() - random.nextFloat());
            phi = phi / 2.0f + deltaPhi / 4.0f;
            deltaPhi = deltaPhi * 0.75f + (random.nextFloat() - random.nextFloat());
            if (random.nextFloat() >= 0.25f) {
                float centerX = (float)caveX + (random.nextFloat() * 4.0f - 2.0f) * 0.2f;
                float centerY = (float)caveY + (random.nextFloat() * 4.0f - 2.0f) * 0.2f;
                float centerZ = (float)caveZ + (random.nextFloat() * 4.0f - 2.0f) * 0.2f;
                float radius = ((float)this.field_16653 - centerY) / (float)this.field_16653;
                radius = 1.2f + (radius * 3.5f + 1.0f) * caveRadius;
                this.fillOblateSpheroid(chunk, centerX, centerY, centerZ, radius *= class_3532.method_15374((float)((float)len * (float)Math.PI / caveLen)), class_2246.field_10124);
            }
            ++len;
        }
    }

    protected void fillOblateSpheroid(class_2791 chunk, float centerX, float centerY, float centerZ, float radius, class_2248 fillBlock) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int x = (int)(centerX - radius); x < (int)(centerX + radius); ++x) {
            for (int y = (int)(centerY - radius); y < (int)(centerY + radius); ++y) {
                for (int z = (int)(centerZ - radius); z < (int)(centerZ + radius); ++z) {
                    class_2248 someBlock;
                    float dx = (float)x - centerX;
                    float dy = (float)y - centerY;
                    float dz = (float)z - centerZ;
                    if (!(dx * dx + dy * dy * 2.0f + dz * dz < radius * radius) || (someBlock = chunk.method_8320((class_2338)mutable.method_10103(x, y, z)).method_26204()) != class_2246.field_10340) continue;
                    chunk.method_12010((class_2338)mutable.method_10103(x, y, z), fillBlock.method_9564(), false);
                }
            }
        }
    }

    protected boolean method_16580(class_2791 chunk, Function<class_2338, class_1959> posToBiome, long seed, int seaLevel, int mainChunkX, int mainChunkZ, double x, double y, double z, double yaw, double pitch, BitSet carvingMask) {
        return true;
    }

    protected boolean method_12707(int mainChunkX, int mainChunkZ, double x, double z, int branch, int branchCount, float baseWidth) {
        return true;
    }

    protected boolean method_12711(class_2791 chunk, int mainChunkX, int mainChunkZ, int relMinX, int relMaxX, int minY, int maxY, int relMinZ, int relMaxZ) {
        return false;
    }

    protected int getCaveY(Random random) {
        return random.nextInt(this.field_16653);
    }

    protected boolean method_16582(double scaledRelativeX, double scaledRelativeY, double scaledRelativeZ, int y) {
        return false;
    }
}

