/*
 * Decompiled with CFR 0.152.
 */
package com.bespectacled.modernbeta.feature;

import com.bespectacled.modernbeta.biome.BetaBiomeSource;
import com.bespectacled.modernbeta.biome.BetaBiomes;
import com.bespectacled.modernbeta.util.BiomeUtil;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_2493;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import net.minecraft.class_5281;

public class BetaFreezeTopLayerFeature
extends class_3031<class_3111> {
    private Long seed = 0L;
    private static final double[] TEMPS = new double[256];
    private static final double[] HUMIDS = new double[256];

    public BetaFreezeTopLayerFeature(Codec<class_3111> codec) {
        super(codec);
    }

    public boolean generate(class_5281 world, class_2794 chunkGenerator, Random random, class_2338 blockPos, class_3111 defaultFeatureConfig) {
        if (!(chunkGenerator.method_12098() instanceof BetaBiomeSource)) {
            return false;
        }
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2338.class_2339 mutableDown = new class_2338.class_2339();
        int chunkX = blockPos.method_10263() >> 4;
        int chunkZ = blockPos.method_10260() >> 4;
        BetaBiomeSource betaSource = (BetaBiomeSource)chunkGenerator.method_12098();
        if (betaSource.isSkyDim()) {
            Arrays.fill(TEMPS, 0, TEMPS.length, (double)((class_1959)betaSource.biomeRegistry.method_10223(BetaBiomes.SKY_ID)).method_8712());
            Arrays.fill(HUMIDS, 0, HUMIDS.length, (double)((class_1959)betaSource.biomeRegistry.method_10223(BetaBiomes.SKY_ID)).method_8715());
        } else {
            BiomeUtil.fetchTempHumid(chunkX << 4, chunkZ << 4, TEMPS, HUMIDS);
        }
        int i = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int curX = blockPos.method_10263() + x;
                int curZ = blockPos.method_10260() + z;
                int curY = world.method_8624(class_2902.class_2903.field_13197, curX, curZ);
                mutable.method_10103(curX, curY, curZ);
                mutableDown.method_10101((class_2382)mutable).method_10104(class_2350.field_11033, 1);
                if (this.canSetIce((class_4538)world, (class_2338)mutableDown, false, TEMPS[i])) {
                    world.method_8652((class_2338)mutableDown, class_2246.field_10295.method_9564(), 2);
                }
                if (this.canSetSnow((class_4538)world, (class_2338)mutable, TEMPS[i])) {
                    world.method_8652((class_2338)mutable, class_2246.field_10477.method_9564(), 2);
                    class_2680 blockState = world.method_8320((class_2338)mutableDown);
                    if (blockState.method_28498((class_2769)class_2493.field_11522)) {
                        world.method_8652((class_2338)mutableDown, (class_2680)blockState.method_11657((class_2769)class_2493.field_11522, (Comparable)Boolean.valueOf(true)), 2);
                    }
                }
                ++i;
            }
        }
        return true;
    }

    private boolean canSetIce(class_4538 worldView, class_2338 blockPos, boolean doWaterCheck, double temp) {
        if (temp >= 0.5) {
            return false;
        }
        if (blockPos.method_10264() >= 0 && blockPos.method_10264() < 256 && worldView.method_8314(class_1944.field_9282, blockPos) < 10) {
            class_2680 blockState = worldView.method_8320(blockPos);
            class_3610 fluidState = worldView.method_8316(blockPos);
            if (fluidState.method_15772() == class_3612.field_15910 && blockState.method_26204() instanceof class_2404) {
                boolean boolean7;
                if (!doWaterCheck) {
                    return true;
                }
                boolean bl = boolean7 = worldView.method_22351(blockPos.method_10067()) && worldView.method_22351(blockPos.method_10078()) && worldView.method_22351(blockPos.method_10095()) && worldView.method_22351(blockPos.method_10072());
                if (!boolean7) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean canSetSnow(class_4538 worldView, class_2338 blockPos, double temp) {
        class_2680 blockState;
        double heightTemp = temp - (double)(blockPos.method_10264() - 64) / 64.0 * 0.3;
        if (heightTemp >= 0.5) {
            return false;
        }
        return blockPos.method_10264() >= 0 && blockPos.method_10264() < 256 && worldView.method_8314(class_1944.field_9282, blockPos) < 10 && (blockState = worldView.method_8320(blockPos)).method_26215() && class_2246.field_10477.method_9564().method_26184(worldView, blockPos);
    }
}

