/*
 * Decompiled with CFR 0.152.
 */
package com.bespectacled.modernbeta.gen;

import com.bespectacled.modernbeta.ModernBeta;
import com.bespectacled.modernbeta.biome.IndevBiomeSource;
import com.bespectacled.modernbeta.decorator.BetaDecorator;
import com.bespectacled.modernbeta.gen.settings.IndevGeneratorSettings;
import com.bespectacled.modernbeta.noise.OldNoiseGeneratorCombined;
import com.bespectacled.modernbeta.noise.OldNoiseGeneratorOctaves;
import com.bespectacled.modernbeta.util.BlockStates;
import com.bespectacled.modernbeta.util.GenUtil;
import com.bespectacled.modernbeta.util.IndevUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3233;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3532;
import net.minecraft.class_3754;
import net.minecraft.class_3780;
import net.minecraft.class_3790;
import net.minecraft.class_5138;
import net.minecraft.class_5311;
import org.apache.logging.log4j.Level;

public class IndevChunkGenerator
extends class_3754 {
    public static final Codec<IndevChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1966.field_24713.fieldOf("biome_source").forGetter(generator -> generator.biomeSource), (App)Codec.LONG.fieldOf("seed").stable().forGetter(generator -> generator.field_24748), (App)IndevGeneratorSettings.CODEC.fieldOf("settings").forGetter(generator -> generator.settings)).apply((Applicative)instance, instance.stable(IndevChunkGenerator::new)));
    private final IndevGeneratorSettings settings;
    private final class_5311 structuresConfig;
    private final IndevBiomeSource biomeSource;
    private final long seed;
    private OldNoiseGeneratorCombined heightNoise1;
    private OldNoiseGeneratorCombined heightNoise2;
    private OldNoiseGeneratorOctaves heightNoise3;
    private OldNoiseGeneratorOctaves islandNoise;
    private OldNoiseGeneratorOctaves noise5;
    private OldNoiseGeneratorOctaves noise6;
    private OldNoiseGeneratorCombined erodeNoise1;
    private OldNoiseGeneratorCombined erodeNoise2;
    private OldNoiseGeneratorOctaves sandNoiseOctaves;
    private OldNoiseGeneratorOctaves gravelNoiseOctaves;
    private OldNoiseGeneratorOctaves forestNoiseOctaves;
    private class_2248[][][] blockArr;
    private int[] heightmap;
    private IndevUtil.Theme theme;
    private IndevUtil.Type type;
    private class_2680 fluidBlock;
    private int width;
    private int length;
    private int height;
    private int layers;
    private int waterLevel;
    private int groundLevel;
    private float caveRadius;
    private int spawnX;
    private int spawnZ;
    private boolean pregenerated = false;
    private static final class_2338.class_2339 POS = new class_2338.class_2339();
    private static final Random RAND = new Random();
    private static final ObjectList<class_3443> STRUCTURE_LIST = new ObjectArrayList(10);
    private static final ObjectList<class_3780> JIGSAW_LIST = new ObjectArrayList(32);

    public IndevChunkGenerator(class_1966 biomes, long seed, IndevGeneratorSettings settings) {
        super(biomes, seed, () -> settings.wrapped);
        this.settings = settings;
        this.structuresConfig = settings.wrapped.method_28007();
        this.seed = seed;
        this.biomeSource = (IndevBiomeSource)biomes;
        RAND.setSeed(seed);
        this.forestNoiseOctaves = new OldNoiseGeneratorOctaves(RAND, 8, false);
        this.theme = IndevUtil.Theme.NORMAL;
        this.type = IndevUtil.Type.ISLAND;
        this.width = 256;
        this.length = 256;
        this.height = 128;
        if (this.settings.settings.method_10545("levelType")) {
            this.type = IndevUtil.Type.values()[settings.settings.method_10550("levelType")];
        }
        if (this.settings.settings.method_10545("levelTheme")) {
            this.theme = IndevUtil.Theme.values()[settings.settings.method_10550("levelTheme")];
        }
        if (this.settings.settings.method_10545("levelWidth")) {
            this.width = settings.settings.method_10550("levelWidth");
        }
        if (this.settings.settings.method_10545("levelLength")) {
            this.length = settings.settings.method_10550("levelLength");
        }
        if (this.settings.settings.method_10545("levelHeight")) {
            this.height = settings.settings.method_10550("levelHeight");
        }
        if (this.settings.settings.method_10545("caveRadius")) {
            this.caveRadius = settings.settings.method_10583("caveRadius");
        }
        this.fluidBlock = this.theme == IndevUtil.Theme.HELL ? BlockStates.LAVA : BlockStates.WATER;
        this.waterLevel = this.height / 2;
        this.layers = this.type == IndevUtil.Type.FLOATING ? (this.height - 64) / 48 + 1 : 1;
        this.spawnX = 0;
        this.spawnZ = 0;
        this.pregenerated = false;
        BetaDecorator.COUNT_ALPHA_NOISE_DECORATOR.setOctaves(this.forestNoiseOctaves);
    }

    public static void register() {
        class_2378.method_10230((class_2378)class_2378.field_25097, (class_2960)new class_2960("modern_beta", "indev"), CODEC);
    }

    protected Codec<? extends class_2794> method_28506() {
        return CODEC;
    }

    public void method_12088(class_1936 worldAccess, class_5138 structureAccessor, class_2791 chunk) {
        class_1923 pos = chunk.method_12004();
        this.spawnX = worldAccess.method_8401().method_215();
        this.spawnZ = worldAccess.method_8401().method_166();
        if (IndevUtil.inIndevRegion(pos.method_8326(), pos.method_8328(), this.width, this.length)) {
            if (!this.pregenerated) {
                this.blockArr = this.pregenerateTerrain(this.blockArr);
                this.pregenerated = true;
            }
            this.setTerrain(structureAccessor, chunk, this.blockArr);
        } else if (this.type != IndevUtil.Type.FLOATING) {
            if (this.type == IndevUtil.Type.ISLAND) {
                this.generateWaterBorder(chunk);
            } else {
                this.generateWorldBorder(chunk);
            }
        }
    }

    private void setTerrain(class_5138 structureAccessor, class_2791 chunk, class_2248[][][] blockArr) {
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        int offsetX = (chunkX + this.width / 16 / 2) * 16;
        int offsetZ = (chunkZ + this.length / 16 / 2) * 16;
        class_2902 heightmapOCEAN = chunk.method_12032(class_2902.class_2903.field_13195);
        class_2902 heightmapSURFACE = chunk.method_12032(class_2902.class_2903.field_13194);
        GenUtil.collectStructures(chunk, structureAccessor, STRUCTURE_LIST, JIGSAW_LIST);
        ObjectListIterator structureListIterator = STRUCTURE_LIST.iterator();
        ObjectListIterator jigsawListIterator = JIGSAW_LIST.iterator();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int absX = x + (chunkX << 4);
                int absZ = z + (chunkZ << 4);
                for (int y = 0; y < this.height; ++y) {
                    class_2248 blockToSet = blockArr[offsetX + x][y][offsetZ + z];
                    while (structureListIterator.hasNext()) {
                        class_3443 curStructurePiece = (class_3443)structureListIterator.next();
                        class_3341 blockBox = curStructurePiece.method_14935();
                        int sX = Math.max(0, Math.max(blockBox.field_14381 - absX, absX - blockBox.field_14378));
                        int sY = y - (blockBox.field_14380 + (curStructurePiece instanceof class_3790 ? ((class_3790)curStructurePiece).method_16646() : 0));
                        int sZ = Math.max(0, Math.max(blockBox.field_14379 - absZ, absZ - blockBox.field_14376));
                        if (sY >= 0 || sX != 0 || sZ != 0) continue;
                        if (sY == -1) {
                            blockToSet = class_2246.field_10219;
                            continue;
                        }
                        if (sY >= -2) {
                            blockToSet = class_2246.field_10566;
                            continue;
                        }
                        if (sY < -4) continue;
                        blockToSet = class_2246.field_10340;
                    }
                    structureListIterator.back(STRUCTURE_LIST.size());
                    while (jigsawListIterator.hasNext()) {
                        class_3780 curJigsawJunction = (class_3780)jigsawListIterator.next();
                        int jX = absX - curJigsawJunction.method_16610();
                        int jY = y - curJigsawJunction.method_16611();
                        int jZ = absZ - curJigsawJunction.method_16609();
                        if (jY >= 0 || jX != 0 || jZ != 0) continue;
                        if (jY == -1) {
                            blockToSet = class_2246.field_10219;
                            continue;
                        }
                        if (jY >= -2) {
                            blockToSet = class_2246.field_10566;
                            continue;
                        }
                        if (jY < -4) continue;
                        blockToSet = class_2246.field_10340;
                    }
                    jigsawListIterator.back(JIGSAW_LIST.size());
                    if (blockToSet != class_2246.field_10124) {
                        chunk.method_12010((class_2338)POS.method_10103(x, y, z), BlockStates.getBlockState(blockToSet), false);
                    }
                    if (this.type == IndevUtil.Type.FLOATING) continue;
                    if (y <= 1 && blockToSet == class_2246.field_10124) {
                        chunk.method_12010((class_2338)POS.method_10103(x, y, z), BlockStates.LAVA, false);
                    } else if (y <= 1) {
                        chunk.method_12010((class_2338)POS.method_10103(x, y, z), BlockStates.BEDROCK, false);
                    }
                    heightmapOCEAN.method_12597(x, y, z, BlockStates.getBlockState(blockToSet));
                    heightmapSURFACE.method_12597(x, y, z, BlockStates.getBlockState(blockToSet));
                }
            }
        }
    }

    private class_2248[][][] pregenerateTerrain(class_2248[][][] blockArr) {
        blockArr = new class_2248[this.width][this.height][this.length];
        this.fillBlockArr(blockArr);
        for (int l = 0; l < this.layers; ++l) {
            this.waterLevel = this.type == IndevUtil.Type.FLOATING ? this.height - 32 - l * 48 : this.waterLevel;
            this.groundLevel = this.waterLevel - 2;
            this.heightNoise1 = new OldNoiseGeneratorCombined(new OldNoiseGeneratorOctaves(RAND, 8, true), new OldNoiseGeneratorOctaves(RAND, 8, true));
            this.heightNoise2 = new OldNoiseGeneratorCombined(new OldNoiseGeneratorOctaves(RAND, 8, true), new OldNoiseGeneratorOctaves(RAND, 8, true));
            this.heightNoise3 = new OldNoiseGeneratorOctaves(RAND, 6, true);
            this.islandNoise = new OldNoiseGeneratorOctaves(RAND, 2, true);
            this.noise5 = new OldNoiseGeneratorOctaves(RAND, 8, true);
            this.noise6 = new OldNoiseGeneratorOctaves(RAND, 8, true);
            this.erodeNoise1 = new OldNoiseGeneratorCombined(new OldNoiseGeneratorOctaves(RAND, 8, true), new OldNoiseGeneratorOctaves(RAND, 8, true));
            this.erodeNoise2 = new OldNoiseGeneratorCombined(new OldNoiseGeneratorOctaves(RAND, 8, true), new OldNoiseGeneratorOctaves(RAND, 8, true));
            this.sandNoiseOctaves = new OldNoiseGeneratorOctaves(RAND, 8, true);
            this.gravelNoiseOctaves = new OldNoiseGeneratorOctaves(RAND, 8, true);
            this.heightmap = this.generateHeightmap(this.heightmap);
            this.erodeTerrain(this.heightmap);
            ModernBeta.LOGGER.log(Level.INFO, "[Indev] Soiling..");
            for (int x = 0; x < this.width; ++x) {
                double var1 = Math.abs(((double)x / ((double)this.width - 1.0) - 0.5) * 2.0);
                for (int z = 0; z < this.length; ++z) {
                    double var2 = Math.max(var1, Math.abs((double)z / ((double)this.length - 1.0) - 0.5) * 2.0);
                    var2 = var2 * var2 * var2;
                    int dirtTransition = this.heightmap[x + z * this.width] + this.waterLevel;
                    int dirtThickness = (int)(this.noise5.generateIndevNoiseOctaves(x, z) / 24.0) - 4;
                    int stoneTransition = dirtTransition + dirtThickness;
                    this.heightmap[x + z * this.width] = Math.max(dirtTransition, stoneTransition);
                    if (this.heightmap[x + z * this.width] > this.height - 2) {
                        this.heightmap[x + z * this.width] = this.height - 2;
                    }
                    if (this.heightmap[x + z * this.width] <= 0) {
                        this.heightmap[x + z * this.width] = 1;
                    }
                    double var4 = this.noise6.generateIndevNoiseOctaves((double)x * 2.3, (double)z * 2.3) / 24.0;
                    int var5 = (int)(Math.sqrt(Math.abs(var4)) * Math.signum(var4) * 20.0) + this.waterLevel;
                    if ((var5 = (int)((double)var5 * (1.0 - var2) + var2 * (double)this.height)) > this.waterLevel) {
                        var5 = this.height;
                    }
                    for (int y = 0; y < this.height; ++y) {
                        class_2248 someBlock;
                        class_2248 blockToSet = class_2246.field_10124;
                        if (y <= dirtTransition) {
                            blockToSet = class_2246.field_10566;
                        }
                        if (y <= stoneTransition) {
                            blockToSet = class_2246.field_10340;
                        }
                        if (this.type == IndevUtil.Type.FLOATING && y < var5) {
                            blockToSet = class_2246.field_10124;
                        }
                        if (!(someBlock = blockArr[x][y][z]).equals(class_2246.field_10124)) continue;
                        blockArr[x][y][z] = blockToSet;
                    }
                }
            }
            this.buildIndevSurface(blockArr, this.heightmap);
            this.carveTerrain(blockArr);
            this.floodFluid(blockArr);
            this.floodLava(blockArr);
            this.plantIndevSurface(blockArr);
        }
        return blockArr;
    }

    private int[] generateHeightmap(int[] heightmap) {
        ModernBeta.LOGGER.log(Level.INFO, "[Indev] Raising..");
        if (heightmap == null) {
            heightmap = new int[this.width * this.length];
        }
        for (int x = 0; x < this.width; ++x) {
            double islandVar1 = Math.abs(((double)x / ((double)this.width - 1.0) - 0.5) * 2.0);
            for (int z = 0; z < this.length; ++z) {
                double islandVar2 = Math.abs(((double)z / ((double)this.length - 1.0) - 0.5) * 2.0);
                double heightLow = this.heightNoise1.generateCombinedIndevNoiseOctaves((float)x * 1.3f, (float)z * 1.3f) / 6.0 - 4.0;
                double heightHigh = this.heightNoise2.generateCombinedIndevNoiseOctaves((float)x * 1.3f, (float)z * 1.3f) / 5.0 + 10.0 - 4.0;
                double heightCheck = this.heightNoise3.generateIndevNoiseOctaves(x, z) / 8.0;
                if (heightCheck > 0.0) {
                    heightHigh = heightLow;
                }
                double heightResult = Math.max(heightLow, heightHigh) / 2.0;
                if (this.type == IndevUtil.Type.ISLAND) {
                    double islandVar3 = Math.sqrt(islandVar1 * islandVar1 + islandVar2 * islandVar2) * (double)1.2f;
                    islandVar3 = Math.min(islandVar3, this.islandNoise.generateIndevNoiseOctaves((float)x * 0.05f, (float)z * 0.05f) / 4.0 + 1.0);
                    if ((islandVar3 = Math.max(islandVar3, Math.max(islandVar1, islandVar2))) > 1.0) {
                        islandVar3 = 1.0;
                    } else if (islandVar3 < 0.0) {
                        islandVar3 = 0.0;
                    }
                    islandVar3 *= islandVar3;
                    heightResult = heightResult * (1.0 - islandVar3) - islandVar3 * 10.0 + 5.0;
                    if (heightResult < 0.0) {
                        heightResult -= heightResult * heightResult * (double)0.2f;
                    }
                } else if (heightResult < 0.0) {
                    heightResult *= 0.8;
                }
                heightmap[x + z * this.width] = (int)heightResult;
            }
        }
        return heightmap;
    }

    private void erodeTerrain(int[] heightmap) {
        ModernBeta.LOGGER.log(Level.INFO, "[Indev] Eroding..");
        for (int x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.length; ++z) {
                int var2;
                double var1 = this.erodeNoise1.generateCombinedIndevNoiseOctaves(x << 1, z << 1) / 8.0;
                int n = var2 = this.erodeNoise2.generateCombinedIndevNoiseOctaves(x << 1, z << 1) > 0.0 ? 1 : 0;
                if (!(var1 > 2.0)) continue;
                int var3 = heightmap[x + z * this.width];
                heightmap[x + z * this.width] = var3 = ((var3 - var2) / 2 << 1) + var2;
            }
        }
    }

    private void buildIndevSurface(class_2248[][][] blockArr, int[] heightmap) {
        ModernBeta.LOGGER.log(Level.INFO, "[Indev] Growing..");
        int seaLevel = this.waterLevel - 1;
        if (this.theme == IndevUtil.Theme.PARADISE) {
            seaLevel += 2;
        }
        for (int x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.length; ++z) {
                boolean genGravel;
                boolean genSand = this.sandNoiseOctaves.generateIndevNoiseOctaves(x, z) > 8.0;
                boolean bl = genGravel = this.gravelNoiseOctaves.generateIndevNoiseOctaves(x, z) > 12.0;
                if (this.type == IndevUtil.Type.ISLAND) {
                    boolean bl2 = genSand = this.sandNoiseOctaves.generateIndevNoiseOctaves(x, z) > -8.0;
                }
                if (this.theme == IndevUtil.Theme.PARADISE) {
                    boolean bl3 = genSand = this.sandNoiseOctaves.generateIndevNoiseOctaves(x, z) > -32.0;
                }
                if (this.theme == IndevUtil.Theme.HELL || this.theme == IndevUtil.Theme.WOODS) {
                    genSand = this.sandNoiseOctaves.generateIndevNoiseOctaves(x, z) > -8.0;
                }
                int heightResult = heightmap[x + z * this.width];
                class_2248 block = blockArr[x][heightResult][z];
                class_2248 blockAbove = blockArr[x][heightResult + 1][z];
                if ((blockAbove == this.fluidBlock.method_26204() || blockAbove == class_2246.field_10124) && heightResult <= this.waterLevel - 1 && genGravel) {
                    blockArr[x][heightResult][z] = class_2246.field_10255;
                }
                if (blockAbove != class_2246.field_10124) continue;
                class_2248 surfaceBlock = null;
                if (heightResult <= seaLevel && genSand) {
                    class_2248 class_22482 = surfaceBlock = this.theme == IndevUtil.Theme.HELL ? class_2246.field_10219 : class_2246.field_10102;
                }
                if (block == class_2246.field_10124 || surfaceBlock == null) continue;
                blockArr[x][heightResult][z] = surfaceBlock;
            }
        }
    }

    private void carveTerrain(class_2248[][][] blockArr) {
        ModernBeta.LOGGER.log(Level.INFO, "[Indev] Carving..");
        int caveCount = this.width * this.length * this.height / 256 / 64 << 1;
        for (int i = 0; i < caveCount; ++i) {
            float caveX = RAND.nextFloat() * (float)this.width;
            float caveY = RAND.nextFloat() * (float)this.height;
            float caveZ = RAND.nextFloat() * (float)this.length;
            int caveLen = (int)((RAND.nextFloat() + RAND.nextFloat()) * 200.0f);
            float theta = RAND.nextFloat() * (float)Math.PI * 2.0f;
            float deltaTheta = 0.0f;
            float phi = RAND.nextFloat() * (float)Math.PI * 2.0f;
            float deltaPhi = 0.0f;
            float caveRadius = RAND.nextFloat() * RAND.nextFloat() * this.caveRadius;
            for (int len = 0; len < caveLen; ++len) {
                caveX += class_3532.method_15374((float)theta) * class_3532.method_15362((float)phi);
                caveZ += class_3532.method_15362((float)theta) * class_3532.method_15362((float)phi);
                caveY += class_3532.method_15374((float)phi);
                theta += deltaTheta * 0.2f;
                deltaTheta = deltaTheta * 0.9f + (RAND.nextFloat() - RAND.nextFloat());
                phi = phi / 2.0f + deltaPhi / 4.0f;
                deltaPhi = deltaPhi * 0.75f + (RAND.nextFloat() - RAND.nextFloat());
                if (!(RAND.nextFloat() >= 0.25f)) continue;
                float centerX = caveX + (RAND.nextFloat() * 4.0f - 2.0f) * 0.2f;
                float centerY = caveY + (RAND.nextFloat() * 4.0f - 2.0f) * 0.2f;
                float centerZ = caveZ + (RAND.nextFloat() * 4.0f - 2.0f) * 0.2f;
                float radius = ((float)this.height - centerY) / (float)this.height;
                radius = 1.2f + (radius * 3.5f + 1.0f) * caveRadius;
                this.fillOblateSpheroid(blockArr, centerX, centerY, centerZ, radius *= class_3532.method_15374((float)((float)len * (float)Math.PI / (float)caveLen)), class_2246.field_10124);
            }
        }
    }

    private void fillOblateSpheroid(class_2248[][][] blockArr, float centerX, float centerY, float centerZ, float radius, class_2248 fillBlock) {
        for (int x = (int)(centerX - radius); x < (int)(centerX + radius); ++x) {
            for (int y = (int)(centerY - radius); y < (int)(centerY + radius); ++y) {
                for (int z = (int)(centerZ - radius); z < (int)(centerZ + radius); ++z) {
                    class_2248 someBlock;
                    float dx = (float)x - centerX;
                    float dy = (float)y - centerY;
                    float dz = (float)z - centerZ;
                    if (!(dx * dx + dy * dy * 2.0f + dz * dz < radius * radius) || !this.inLevelBounds(x, y, z) || (someBlock = blockArr[x][y][z]) != class_2246.field_10340) continue;
                    blockArr[x][y][z] = fillBlock;
                }
            }
        }
    }

    private void floodFluid(class_2248[][][] blockArr) {
        ModernBeta.LOGGER.log(Level.INFO, "[Indev] Watering..");
        class_2248 toFill = this.fluidBlock.method_26204();
        if (this.type == IndevUtil.Type.FLOATING) {
            return;
        }
        for (int x = 0; x < this.width; ++x) {
            this.flood(blockArr, x, this.waterLevel - 1, 0, toFill);
            this.flood(blockArr, x, this.waterLevel - 1, this.length - 1, toFill);
        }
        for (int z = 0; z < this.length; ++z) {
            this.flood(blockArr, this.width - 1, this.waterLevel - 1, z, toFill);
            this.flood(blockArr, 0, this.waterLevel - 1, z, toFill);
        }
        int waterSourceCount = this.width * this.length / 800;
        for (int i = 0; i < waterSourceCount; ++i) {
            int randX = RAND.nextInt(this.width);
            int randZ = RAND.nextInt(this.length);
            int randY = RAND.nextBoolean() ? this.waterLevel - 1 : this.waterLevel - 2;
            this.flood(blockArr, randX, randY, randZ, toFill);
        }
    }

    private void floodLava(class_2248[][][] blockArr) {
        ModernBeta.LOGGER.log(Level.INFO, "[Indev] Melting..");
        if (this.type == IndevUtil.Type.FLOATING) {
            return;
        }
        int lavaSourceCount = this.width * this.length * this.height / 20000;
        int lavaHeight = this.groundLevel;
        for (int i = 0; i < lavaSourceCount; ++i) {
            int randX = RAND.nextInt(this.width);
            int randZ = RAND.nextInt(this.length);
            int randY = (int)((float)(this.waterLevel - 3) * RAND.nextFloat() * RAND.nextFloat());
            this.flood(blockArr, randX, randY, randZ, class_2246.field_10164);
        }
    }

    private void flood(class_2248[][][] blockArr, int x, int y, int z, class_2248 toFill) {
        ArrayList<class_243> posToFill = new ArrayList<class_243>();
        posToFill.add(new class_243((double)x, (double)y, (double)z));
        while (posToFill.size() > 0) {
            class_243 curPos = (class_243)posToFill.get(0);
            x = (int)curPos.field_1352;
            y = (int)curPos.field_1351;
            z = (int)curPos.field_1350;
            class_2248 someBlock = blockArr[x][y][z];
            if (someBlock == class_2246.field_10124) {
                blockArr[x][y][z] = toFill;
                if (y - 1 >= 0) {
                    posToFill.add(new class_243((double)x, (double)(y - 1), (double)z));
                }
                if (x - 1 >= 0) {
                    posToFill.add(new class_243((double)(x - 1), (double)y, (double)z));
                }
                if (x + 1 < this.width) {
                    posToFill.add(new class_243((double)(x + 1), (double)y, (double)z));
                }
                if (z - 1 >= 0) {
                    posToFill.add(new class_243((double)x, (double)y, (double)(z - 1)));
                }
                if (z + 1 < this.length) {
                    posToFill.add(new class_243((double)x, (double)y, (double)(z + 1)));
                }
            }
            posToFill.remove(0);
        }
    }

    private void plantIndevSurface(class_2248[][][] blockArr) {
        ModernBeta.LOGGER.log(Level.INFO, "[Indev] Planting..");
        if (this.theme == IndevUtil.Theme.HELL) {
            return;
        }
        for (int x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.length; ++z) {
                for (int y = 0; y < this.height - 2; ++y) {
                    class_2248 block = blockArr[x][y][z];
                    class_2248 blockAbove = blockArr[x][y + 1][z];
                    if (!block.equals(class_2246.field_10566) || !blockAbove.equals(class_2246.field_10124)) continue;
                    blockArr[x][y][z] = class_2246.field_10219;
                }
            }
        }
    }

    private void generateWorldBorder(class_2791 chunk) {
        class_2680 topBlock = BlockStates.GRASS_BLOCK;
        if (this.theme == IndevUtil.Theme.HELL) {
            topBlock = BlockStates.DIRT;
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < this.height; ++y) {
                    if (y < this.waterLevel) {
                        chunk.method_12010((class_2338)POS.method_10103(x, y, z), BlockStates.BEDROCK, false);
                        continue;
                    }
                    if (y != this.waterLevel) continue;
                    chunk.method_12010((class_2338)POS.method_10103(x, y, z), topBlock, false);
                }
            }
        }
    }

    private void generateWaterBorder(class_2791 chunk) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < this.height; ++y) {
                    if (y < this.waterLevel - 10) {
                        chunk.method_12010((class_2338)POS.method_10103(x, y, z), BlockStates.BEDROCK, false);
                        continue;
                    }
                    if (y == this.waterLevel - 10) {
                        chunk.method_12010((class_2338)POS.method_10103(x, y, z), BlockStates.DIRT, false);
                        continue;
                    }
                    if (y >= this.waterLevel) continue;
                    chunk.method_12010((class_2338)POS.method_10103(x, y, z), this.fluidBlock, false);
                }
            }
        }
    }

    private void countBlocks(class_2248[][][] blockArr) {
        int countStone = 0;
        int countDirt = 0;
        int countAir = 0;
        for (int x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.length; ++z) {
                for (int y = 0; y < this.height; ++y) {
                    class_2248 someBlock = blockArr[x][y][z];
                    if (someBlock.equals(class_2246.field_10340)) {
                        ++countStone;
                    }
                    if (someBlock.equals(class_2246.field_10566)) {
                        ++countDirt;
                    }
                    if (!someBlock.equals(class_2246.field_10124)) continue;
                    ++countAir;
                }
            }
        }
        ModernBeta.LOGGER.log(Level.DEBUG, "Block count, stone/dirt/air: " + countStone + ", " + countDirt + ", " + countAir);
    }

    private void fillBlockArr(class_2248[][][] blockArr) {
        for (int x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.length; ++z) {
                for (int y = 0; y < this.height; ++y) {
                    blockArr[x][y][z] = class_2246.field_10124;
                }
            }
        }
    }

    private boolean inLevelBounds(int x, int y, int z) {
        return x >= 0 && x < this.width && y >= 0 && y < this.height && z >= 0 && z < this.length;
    }

    public void method_12110(class_3233 chunkRegion, class_2791 chunk) {
    }

    public int method_16397(int x, int z, class_2902.class_2903 type) {
        class_2248 someBlock;
        int height = this.height - 1;
        if ((x += this.width / 2) < 0 || x >= this.width || (z += this.length / 2) < 0 || z >= this.length) {
            return this.waterLevel;
        }
        if (!this.pregenerated) {
            this.blockArr = this.pregenerateTerrain(this.blockArr);
            this.pregenerated = true;
        }
        int y = this.height - 1;
        while (y >= 0 && (someBlock = this.blockArr[x][y][z]).equals(class_2246.field_10124)) {
            height = y--;
        }
        if (height <= this.waterLevel) {
            height = this.waterLevel;
        }
        return height;
    }

    public int method_12104() {
        return 128;
    }

    public int method_16398() {
        return this.waterLevel;
    }

    public class_2794 method_27997(long seed) {
        return new IndevChunkGenerator(this.biomeSource.method_27985(seed), seed, this.settings);
    }

    public int getSpawnX() {
        return this.spawnX;
    }

    public int getSpawnZ() {
        return this.spawnZ;
    }

    public IndevUtil.Theme getTheme() {
        return this.theme;
    }
}

