/*
 * Decompiled with CFR 0.152.
 */
package com.bespectacled.modernbeta.gen;

import com.bespectacled.modernbeta.biome.InfdevBiomeSource;
import com.bespectacled.modernbeta.decorator.BetaDecorator;
import com.bespectacled.modernbeta.feature.BetaFeature;
import com.bespectacled.modernbeta.gen.IOldChunkGenerator;
import com.bespectacled.modernbeta.gen.settings.InfdevGeneratorSettings;
import com.bespectacled.modernbeta.noise.OldNoiseGeneratorOctaves;
import com.bespectacled.modernbeta.util.BlockStates;
import com.bespectacled.modernbeta.util.GenUtil;
import com.bespectacled.modernbeta.util.MutableBiomeArray;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2810;
import net.minecraft.class_2839;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2922;
import net.minecraft.class_2960;
import net.minecraft.class_3233;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3485;
import net.minecraft.class_3532;
import net.minecraft.class_3754;
import net.minecraft.class_3780;
import net.minecraft.class_3790;
import net.minecraft.class_4076;
import net.minecraft.class_4543;
import net.minecraft.class_5138;
import net.minecraft.class_5312;
import net.minecraft.class_5314;
import net.minecraft.class_5455;
import net.minecraft.class_5470;
import net.minecraft.class_5485;

public class InfdevChunkGenerator
extends class_3754
implements IOldChunkGenerator {
    public static final Codec<InfdevChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1966.field_24713.fieldOf("biome_source").forGetter(generator -> generator.biomeSource), (App)Codec.LONG.fieldOf("seed").stable().forGetter(generator -> generator.field_24748), (App)InfdevGeneratorSettings.CODEC.fieldOf("settings").forGetter(generator -> generator.settings)).apply((Applicative)instance, instance.stable(InfdevChunkGenerator::new)));
    private final InfdevGeneratorSettings settings;
    private final InfdevBiomeSource biomeSource;
    private final long seed;
    private boolean generateVanillaBiomes = false;
    private final OldNoiseGeneratorOctaves noiseOctavesA;
    private final OldNoiseGeneratorOctaves noiseOctavesB;
    private final OldNoiseGeneratorOctaves noiseOctavesC;
    private final OldNoiseGeneratorOctaves beachNoiseOctaves;
    private final OldNoiseGeneratorOctaves stoneNoiseOctaves;
    private final OldNoiseGeneratorOctaves forestNoiseOctaves;
    private static final Map<class_2338, Integer> GROUND_CACHE_Y = new HashMap<class_2338, Integer>();
    private static final int[][] CHUNK_Y = new int[16][16];
    private static final double[][] HEIGHTMAP = new double[33][4];
    private static final class_2338.class_2339 POS = new class_2338.class_2339();
    private static final Random RAND = new Random();
    private static final class_2919 FEATURE_RAND = new class_2919();
    private static final ObjectList<class_3443> STRUCTURE_LIST = new ObjectArrayList(10);
    private static final ObjectList<class_3780> JIGSAW_LIST = new ObjectArrayList(32);

    public InfdevChunkGenerator(class_1966 biomes, long seed, InfdevGeneratorSettings settings) {
        super(biomes, seed, () -> settings.wrapped);
        this.settings = settings;
        this.biomeSource = (InfdevBiomeSource)biomes;
        this.seed = seed;
        if (settings.settings.method_10545("generateVanillaBiomesInfdev")) {
            this.generateVanillaBiomes = settings.settings.method_10577("generateVanillaBiomesInfdev");
        }
        RAND.setSeed(seed);
        this.noiseOctavesA = new OldNoiseGeneratorOctaves(RAND, 16, false);
        this.noiseOctavesB = new OldNoiseGeneratorOctaves(RAND, 16, false);
        this.noiseOctavesC = new OldNoiseGeneratorOctaves(RAND, 8, false);
        this.beachNoiseOctaves = new OldNoiseGeneratorOctaves(RAND, 4, false);
        this.stoneNoiseOctaves = new OldNoiseGeneratorOctaves(RAND, 4, false);
        new OldNoiseGeneratorOctaves(RAND, 5, false);
        this.forestNoiseOctaves = new OldNoiseGeneratorOctaves(RAND, 5, false);
        BetaDecorator.COUNT_INFDEV_NOISE_DECORATOR.setOctaves(this.forestNoiseOctaves);
        GROUND_CACHE_Y.clear();
    }

    public static void register() {
        class_2378.method_10230((class_2378)class_2378.field_25097, (class_2960)new class_2960("modern_beta", "infdev"), CODEC);
    }

    protected Codec<? extends class_2794> method_28506() {
        return CODEC;
    }

    public void method_12088(class_1936 worldAccess, class_5138 structureAccessor, class_2791 chunk) {
        RAND.setSeed((long)chunk.method_12004().field_9181 * 341873128712L + (long)chunk.method_12004().field_9180 * 132897987541L);
        this.generateTerrain(chunk, structureAccessor);
        if (this.generateVanillaBiomes) {
            MutableBiomeArray mutableBiomes = MutableBiomeArray.inject(chunk.method_12036());
            class_1923 pos = chunk.method_12004();
            for (int x = 0; x < 4; ++x) {
                for (int z = 0; z < 4; ++z) {
                    int absZ;
                    int absX = pos.method_8326() + (x << 2);
                    int y = GenUtil.getSolidHeight(chunk, absX, absZ = pos.method_8328() + (z << 2));
                    if (y >= 60) continue;
                    class_1959 biome = this.biomeSource.getOceanBiomeForNoiseGen(absX >> 2, absZ >> 2);
                    mutableBiomes.setBiome(absX, 0, absZ, biome);
                }
            }
        }
        BetaFeature.OLD_FANCY_OAK.chunkReset();
    }

    public void method_12102(class_3233 chunkRegion, class_5138 structureAccessor) {
        int ctrX = chunkRegion.method_14336();
        int ctrZ = chunkRegion.method_14339();
        int ctrAbsX = ctrX * 16;
        int ctrAbsZ = ctrZ * 16;
        class_2791 ctrChunk = chunkRegion.method_8392(ctrX, ctrZ);
        class_1959 biome = GenUtil.getOceanBiome(ctrChunk, (class_2794)this, this.biomeSource, this.generateVanillaBiomes);
        long popSeed = FEATURE_RAND.method_12661(chunkRegion.method_8412(), ctrAbsX, ctrAbsZ);
        try {
            biome.method_8702(structureAccessor, (class_2794)this, chunkRegion, popSeed, FEATURE_RAND, new class_2338(ctrAbsX, 0, ctrAbsZ));
        }
        catch (Exception exception) {
            class_128 report = class_128.method_560((Throwable)exception, (String)"Biome decoration");
            report.method_562("Generation").method_578("CenterX", (Object)ctrX).method_578("CenterZ", (Object)ctrZ).method_578("Seed", (Object)popSeed).method_578("Biome", (Object)biome);
            throw new class_148(report);
        }
    }

    public void method_16129(class_5455 dynamicRegistryManager, class_5138 structureAccessor, class_2791 chunk, class_3485 structureManager, long seed) {
        class_1923 chunkPos = chunk.method_12004();
        class_1959 biome = GenUtil.getOceanBiome(chunk, (class_2794)this, this.biomeSource, this.generateVanillaBiomes);
        this.setStructureStart(class_5470.field_26302, dynamicRegistryManager, structureAccessor, chunk, structureManager, seed, chunkPos, biome);
        for (Supplier supplier : biome.method_30970().method_30975()) {
            this.setStructureStart((class_5312)supplier.get(), dynamicRegistryManager, structureAccessor, chunk, structureManager, seed, chunkPos, biome);
        }
    }

    private void setStructureStart(class_5312<?, ?> configuredStructureFeature, class_5455 dynamicRegistryManager, class_5138 structureAccessor, class_2791 chunk, class_3485 structureManager, long long7, class_1923 chunkPos, class_1959 biome) {
        class_3449 structureStart = structureAccessor.method_26975(class_4076.method_18681((class_1923)chunk.method_12004(), (int)0), configuredStructureFeature.field_24835, (class_2810)chunk);
        int refs = structureStart != null ? structureStart.method_23676() : 0;
        class_5314 structureConfig = this.settings.wrapped.method_28007().method_28600(configuredStructureFeature.field_24835);
        if (structureConfig != null) {
            class_3449 gotStart = configuredStructureFeature.method_28622(dynamicRegistryManager, (class_2794)this, (class_1966)this.biomeSource, structureManager, long7, chunkPos, biome, refs, structureConfig);
            structureAccessor.method_26976(class_4076.method_18681((class_1923)chunk.method_12004(), (int)0), configuredStructureFeature.field_24835, gotStart, (class_2810)chunk);
        }
    }

    public void method_12108(long seed, class_4543 biomeAccess, class_2791 chunk, class_2893.class_2894 carver) {
        class_4543 biomeAcc = biomeAccess.method_22392((class_1966)this.biomeSource);
        class_1923 chunkPos = chunk.method_12004();
        int mainChunkX = chunkPos.field_9181;
        int mainChunkZ = chunkPos.field_9180;
        int biomeX = mainChunkX << 2;
        int biomeZ = mainChunkZ << 2;
        int absX = biomeX << 2;
        int absZ = biomeZ << 2;
        class_1959 biome = GenUtil.getOceanBiome(chunk, (class_2794)this, this.biomeSource, this.generateVanillaBiomes);
        class_5485 genSettings = biome.method_30970();
        BitSet bitSet = ((class_2839)chunk).method_28510(carver);
        RAND.setSeed(this.seed);
        long l = RAND.nextLong() / 2L * 2L + 1L;
        long l1 = RAND.nextLong() / 2L * 2L + 1L;
        for (int chunkX = mainChunkX - 8; chunkX <= mainChunkX + 8; ++chunkX) {
            for (int chunkZ = mainChunkZ - 8; chunkZ <= mainChunkZ + 8; ++chunkZ) {
                List carverList = genSettings.method_30976(carver);
                ListIterator carverIterator = carverList.listIterator();
                while (carverIterator.hasNext()) {
                    class_2922 configuredCarver = (class_2922)((Supplier)carverIterator.next()).get();
                    RAND.setSeed((long)chunkX * l + (long)chunkZ * l1 ^ seed);
                    if (!configuredCarver.method_12669(RAND, chunkX, chunkZ)) continue;
                    configuredCarver.method_12668(chunk, arg_0 -> ((class_4543)biomeAcc).method_22393(arg_0), RAND, this.method_16398(), chunkX, chunkZ, mainChunkX, mainChunkZ, bitSet);
                }
            }
        }
    }

    public void method_12110(class_3233 chunkRegion, class_2791 chunk) {
        this.buildInfdevSurface(chunkRegion, chunk);
    }

    public void generateTerrain(class_2791 chunk, class_5138 structureAccessor) {
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        class_2902 heightmapOCEAN = chunk.method_12032(class_2902.class_2903.field_13195);
        class_2902 heightmapSURFACE = chunk.method_12032(class_2902.class_2903.field_13194);
        GenUtil.collectStructures(chunk, structureAccessor, STRUCTURE_LIST, JIGSAW_LIST);
        ObjectListIterator structureListIterator = STRUCTURE_LIST.iterator();
        ObjectListIterator jigsawListIterator = JIGSAW_LIST.iterator();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int bY;
                int bX = (chunkX << 2) + i;
                int bZ = (chunkZ << 2) + j;
                for (bY = 0; bY < HEIGHTMAP.length; ++bY) {
                    InfdevChunkGenerator.HEIGHTMAP[bY][0] = this.generateHeightmap(bX, bY, bZ);
                    InfdevChunkGenerator.HEIGHTMAP[bY][1] = this.generateHeightmap(bX, bY, bZ + 1);
                    InfdevChunkGenerator.HEIGHTMAP[bY][2] = this.generateHeightmap(bX + 1, bY, bZ);
                    InfdevChunkGenerator.HEIGHTMAP[bY][3] = this.generateHeightmap(bX + 1, bY, bZ + 1);
                }
                for (bY = 0; bY < 32; ++bY) {
                    double n1 = HEIGHTMAP[bY][0];
                    double n2 = HEIGHTMAP[bY][1];
                    double n3 = HEIGHTMAP[bY][2];
                    double n4 = HEIGHTMAP[bY][3];
                    double n5 = HEIGHTMAP[bY + 1][0];
                    double n7 = HEIGHTMAP[bY + 1][1];
                    double n8 = HEIGHTMAP[bY + 1][2];
                    double n9 = HEIGHTMAP[bY + 1][3];
                    for (int pY = 0; pY < 4; ++pY) {
                        double mixY = (double)pY / 4.0;
                        double nx1 = n1 + (n5 - n1) * mixY;
                        double nx2 = n2 + (n7 - n2) * mixY;
                        double nx3 = n3 + (n8 - n3) * mixY;
                        double nx4 = n4 + (n9 - n4) * mixY;
                        int y = (bY << 2) + pY;
                        for (int pX = 0; pX < 4; ++pX) {
                            double mixX = (double)pX / 4.0;
                            double nz1 = nx1 + (nx3 - nx1) * mixX;
                            double nz2 = nx2 + (nx4 - nx2) * mixX;
                            int x = pX + (i << 2);
                            int z = 0 + (j << 2);
                            for (int pZ = 0; pZ < 4; ++pZ) {
                                double mixZ = (double)pZ / 4.0;
                                double density = nz1 + (nz2 - nz1) * mixZ;
                                int absX = (chunk.method_12004().field_9181 << 4) + x;
                                int absZ = (chunk.method_12004().field_9180 << 4) + z;
                                double clampedDensity = class_3532.method_15350((double)(density / 200.0), (double)-1.0, (double)1.0);
                                clampedDensity = clampedDensity / 2.0 - clampedDensity * clampedDensity * clampedDensity / 24.0;
                                while (structureListIterator.hasNext()) {
                                    class_3443 curStructurePiece = (class_3443)structureListIterator.next();
                                    class_3341 blockBox = curStructurePiece.method_14935();
                                    int sX = Math.max(0, Math.max(blockBox.field_14381 - absX, absX - blockBox.field_14378));
                                    int sY = y - (blockBox.field_14380 + (curStructurePiece instanceof class_3790 ? ((class_3790)curStructurePiece).method_16646() : 0));
                                    int sZ = Math.max(0, Math.max(blockBox.field_14379 - absZ, absZ - blockBox.field_14376));
                                    clampedDensity += class_3754.method_16572((int)sX, (int)sY, (int)sZ) * 0.8;
                                }
                                structureListIterator.back(STRUCTURE_LIST.size());
                                while (jigsawListIterator.hasNext()) {
                                    class_3780 curJigsawJunction = (class_3780)jigsawListIterator.next();
                                    int jX = absX - curJigsawJunction.method_16610();
                                    int jY = y - curJigsawJunction.method_16611();
                                    int jZ = absZ - curJigsawJunction.method_16609();
                                    clampedDensity += class_3754.method_16572((int)jX, (int)jY, (int)jZ) * 0.4;
                                }
                                jigsawListIterator.back(JIGSAW_LIST.size());
                                class_2680 blockToSet = this.method_26262(clampedDensity, y);
                                chunk.method_12010((class_2338)POS.method_10103(x, y, z), blockToSet, false);
                                heightmapOCEAN.method_12597(x, y, z, blockToSet);
                                heightmapSURFACE.method_12597(x, y, z, blockToSet);
                                ++z;
                            }
                        }
                    }
                }
            }
        }
    }

    private double generateHeightmap(double x, double y, double z) {
        double res;
        double d;
        double d2;
        double elevGrad = y * 4.0 - 64.0;
        if (d2 < 0.0) {
            elevGrad *= 3.0;
        }
        double noise = this.noiseOctavesC.generateInfdevOctaves(x * 8.55515, y * 1.71103, z * 8.55515) / 2.0;
        if (d < -1.0) {
            res = class_3532.method_15350((double)(this.noiseOctavesA.generateInfdevOctaves(x * 684.412, y * 984.412, z * 684.412) / 512.0 - elevGrad), (double)-10.0, (double)10.0);
        } else if (noise > 1.0) {
            res = class_3532.method_15350((double)(this.noiseOctavesB.generateInfdevOctaves(x * 684.412, y * 984.412, z * 684.412) / 512.0 - elevGrad), (double)-10.0, (double)10.0);
        } else {
            double noise2 = class_3532.method_15350((double)(this.noiseOctavesA.generateInfdevOctaves(x * 684.412, y * 984.412, z * 684.412) / 512.0 - elevGrad), (double)-10.0, (double)10.0);
            double noise3 = class_3532.method_15350((double)(this.noiseOctavesB.generateInfdevOctaves(x * 684.412, y * 984.412, z * 684.412) / 512.0 - elevGrad), (double)-10.0, (double)10.0);
            double mix = (noise + 1.0) / 2.0;
            res = noise2 + (noise3 - noise2) * mix;
        }
        return res;
    }

    private void buildInfdevSurface(class_3233 region, class_2791 chunk) {
        double thirtysecond = 0.03125;
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int absX = (chunkX << 4) + x;
                int absZ = (chunkZ << 4) + z;
                boolean genSandBeach = this.beachNoiseOctaves.generateInfdevOctaves((double)absX * thirtysecond, (double)absZ * thirtysecond, 0.0) + RAND.nextDouble() * 0.2 > 0.0;
                boolean genGravelBeach = this.beachNoiseOctaves.generateInfdevOctaves((double)absZ * thirtysecond, 109.0134, (double)absX * thirtysecond) + RAND.nextDouble() * 0.2 > 3.0;
                int genStone = (int)(this.stoneNoiseOctaves.generateInfdevOctaves((double)absX * thirtysecond * 2.0, (double)absZ * thirtysecond * 2.0) / 3.0 + 3.0 + this.field_16577.nextDouble() * 0.25);
                int flag = -1;
                class_1959 curBiome = region.method_23753((class_2338)POS.method_10103(absX, 0, absZ));
                class_2680 biomeTopBlock = curBiome.method_30970().method_30985().method_15337();
                class_2680 biomeFillerBlock = curBiome.method_30970().method_30985().method_15336();
                class_2680 topBlock = biomeTopBlock;
                class_2680 fillerBlock = biomeFillerBlock;
                for (int y = 127; y >= 0; --y) {
                    if (y <= 0 + RAND.nextInt(5)) {
                        chunk.method_12010((class_2338)POS.method_10103(x, y, z), class_2246.field_9987.method_9564(), false);
                        continue;
                    }
                    POS.method_10103(x, y, z);
                    class_2248 someBlock = chunk.method_8320((class_2338)POS).method_26204();
                    if (someBlock.equals(class_2246.field_10124)) {
                        flag = -1;
                        continue;
                    }
                    if (!someBlock.equals(class_2246.field_10340)) continue;
                    if (flag == -1) {
                        if (genStone <= 0) {
                            topBlock = BlockStates.AIR;
                            fillerBlock = BlockStates.STONE;
                        } else if (y >= 60 && y <= 65) {
                            topBlock = biomeTopBlock;
                            fillerBlock = biomeFillerBlock;
                            if (genGravelBeach) {
                                topBlock = BlockStates.AIR;
                                fillerBlock = BlockStates.GRAVEL;
                            }
                            if (genSandBeach) {
                                topBlock = BlockStates.SAND;
                                fillerBlock = BlockStates.SAND;
                            }
                        }
                        if (y < this.method_16398() && topBlock.equals(BlockStates.AIR)) {
                            topBlock = BlockStates.WATER;
                        }
                        flag = genStone;
                        if (y >= this.method_16398() - 1) {
                            chunk.method_12010((class_2338)POS, topBlock, false);
                            continue;
                        }
                        chunk.method_12010((class_2338)POS, fillerBlock, false);
                        continue;
                    }
                    if (flag <= 0) continue;
                    chunk.method_12010((class_2338)POS, fillerBlock, false);
                    if (--flag != 0 || !fillerBlock.equals(BlockStates.SAND)) continue;
                    flag = RAND.nextInt(4);
                    fillerBlock = BlockStates.SANDSTONE;
                }
            }
        }
    }

    protected class_2680 method_26262(double density, int y) {
        class_2680 blockStateToSet = BlockStates.AIR;
        if (density > 0.0) {
            blockStateToSet = this.settings.wrapped.method_28005();
        } else if (y < this.method_16398()) {
            blockStateToSet = this.settings.wrapped.method_28006();
        }
        return blockStateToSet;
    }

    public int method_16397(int x, int z, class_2902.class_2903 type) {
        class_2338 structPos = new class_2338(x, 0, z);
        if (GROUND_CACHE_Y.get(structPos) == null) {
            this.sampleHeightmap(x, z);
        }
        int groundHeight = GROUND_CACHE_Y.get(structPos);
        if (type == class_2902.class_2903.field_13194 && groundHeight < this.method_16398()) {
            groundHeight = this.method_16398();
        }
        return groundHeight;
    }

    private void sampleHeightmap(int absX, int absZ) {
        int chunkX = absX >> 4;
        int chunkZ = absZ >> 4;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int bY;
                int bX = (chunkX << 2) + i;
                int bZ = (chunkZ << 2) + j;
                for (bY = 0; bY < HEIGHTMAP.length; ++bY) {
                    InfdevChunkGenerator.HEIGHTMAP[bY][0] = this.generateHeightmap(bX, bY, bZ);
                    InfdevChunkGenerator.HEIGHTMAP[bY][1] = this.generateHeightmap(bX, bY, bZ + 1);
                    InfdevChunkGenerator.HEIGHTMAP[bY][2] = this.generateHeightmap(bX + 1, bY, bZ);
                    InfdevChunkGenerator.HEIGHTMAP[bY][3] = this.generateHeightmap(bX + 1, bY, bZ + 1);
                }
                for (bY = 0; bY < 32; ++bY) {
                    double n1 = HEIGHTMAP[bY][0];
                    double n2 = HEIGHTMAP[bY][1];
                    double n3 = HEIGHTMAP[bY][2];
                    double n4 = HEIGHTMAP[bY][3];
                    double n5 = HEIGHTMAP[bY + 1][0];
                    double n7 = HEIGHTMAP[bY + 1][1];
                    double n8 = HEIGHTMAP[bY + 1][2];
                    double n9 = HEIGHTMAP[bY + 1][3];
                    for (int pY = 0; pY < 4; ++pY) {
                        double mixY = (double)pY / 4.0;
                        double nx1 = n1 + (n5 - n1) * mixY;
                        double nx2 = n2 + (n7 - n2) * mixY;
                        double nx3 = n3 + (n8 - n3) * mixY;
                        double nx4 = n4 + (n9 - n4) * mixY;
                        for (int pX = 0; pX < 4; ++pX) {
                            double mixX = (double)pX / 4.0;
                            double nz1 = nx1 + (nx3 - nx1) * mixX;
                            double nz2 = nx2 + (nx4 - nx2) * mixX;
                            int x = pX + (i << 2);
                            int z = 0 + (j << 2);
                            int y = (bY << 2) + pY;
                            for (int pZ = 0; pZ < 4; ++pZ) {
                                double mixZ = (double)pZ / 4.0;
                                double noiseValue = nz1 + (nz2 - nz1) * mixZ;
                                if (noiseValue > 0.0) {
                                    InfdevChunkGenerator.CHUNK_Y[x][z] = y;
                                }
                                ++z;
                            }
                        }
                    }
                }
            }
        }
        for (int pX = 0; pX < CHUNK_Y.length; ++pX) {
            for (int pZ = 0; pZ < CHUNK_Y[pX].length; ++pZ) {
                class_2338 structPos = new class_2338((chunkX << 4) + pX, 0, (chunkZ << 4) + pZ);
                GROUND_CACHE_Y.put(structPos, CHUNK_Y[pX][pZ] + 1);
            }
        }
    }

    public int method_12104() {
        return 128;
    }

    public int method_16398() {
        return this.settings.wrapped.method_28561();
    }

    public class_2794 method_27997(long seed) {
        return new InfdevChunkGenerator(this.biomeSource.method_27985(seed), seed, this.settings);
    }
}

