/*
 * Decompiled with CFR 0.152.
 */
package com.bespectacled.modernbeta.gen;

import com.bespectacled.modernbeta.biome.BetaBiomeSource;
import com.bespectacled.modernbeta.decorator.BetaDecorator;
import com.bespectacled.modernbeta.feature.BetaFeature;
import com.bespectacled.modernbeta.gen.settings.BetaGeneratorSettings;
import com.bespectacled.modernbeta.noise.OldNoiseGeneratorOctaves;
import com.bespectacled.modernbeta.structure.BetaStructure;
import com.bespectacled.modernbeta.util.BiomeUtil;
import com.bespectacled.modernbeta.util.BlockStates;
import com.bespectacled.modernbeta.util.GenUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2839;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2922;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3233;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3532;
import net.minecraft.class_3754;
import net.minecraft.class_3780;
import net.minecraft.class_3790;
import net.minecraft.class_4543;
import net.minecraft.class_5138;
import net.minecraft.class_5485;

public class SkylandsChunkGenerator
extends class_3754 {
    public static final Codec<SkylandsChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1966.field_24713.fieldOf("biome_source").forGetter(generator -> generator.biomeSource), (App)Codec.LONG.fieldOf("seed").stable().forGetter(generator -> generator.field_24748), (App)BetaGeneratorSettings.CODEC.fieldOf("settings").forGetter(generator -> generator.settings)).apply((Applicative)instance, instance.stable(SkylandsChunkGenerator::new)));
    private final BetaGeneratorSettings settings;
    private final BetaBiomeSource biomeSource;
    private final long seed;
    private boolean generateVanillaBiomes = false;
    private final OldNoiseGeneratorOctaves minLimitNoiseOctaves;
    private final OldNoiseGeneratorOctaves maxLimitNoiseOctaves;
    private final OldNoiseGeneratorOctaves mainNoiseOctaves;
    private final OldNoiseGeneratorOctaves beachNoiseOctaves;
    private final OldNoiseGeneratorOctaves stoneNoiseOctaves;
    private final OldNoiseGeneratorOctaves scaleNoiseOctaves;
    private final OldNoiseGeneratorOctaves depthNoiseOctaves;
    private final OldNoiseGeneratorOctaves forestNoiseOctaves;
    private double[] sandNoise;
    private double[] gravelNoise;
    private double[] stoneNoise;
    private double[] mainNoise;
    private double[] minLimitNoise;
    private double[] maxLimitNoise;
    private double[] scaleNoise;
    private double[] depthNoise;
    private double[] temps;
    private boolean generateSkyDim;
    private static final Map<class_2338, Integer> GROUND_CACHE_Y = new HashMap<class_2338, Integer>();
    private static final int[][] CHUNK_Y = new int[16][16];
    private static final double[] HEIGHTMAP = new double[397];
    private static final class_2338.class_2339 POS = new class_2338.class_2339();
    private static final Random RAND = new Random();
    private static final class_2919 FEATURE_RAND = new class_2919();
    private static final ObjectList<class_3443> STRUCTURE_LIST = new ObjectArrayList(10);
    private static final ObjectList<class_3780> JIGSAW_LIST = new ObjectArrayList(32);
    private static final double[] TEMPS = new double[256];
    private static final double[] HUMIDS = new double[256];
    private static final class_1959[] BIOMES = new class_1959[256];
    private static final class_1959[] OCEAN_BIOMES = new class_1959[256];
    private static final class_1959[] BEACH_BIOMES = new class_1959[256];

    public SkylandsChunkGenerator(class_1966 biomes, long seed, BetaGeneratorSettings settings) {
        super(biomes, seed, () -> settings.wrapped);
        this.settings = settings;
        this.biomeSource = (BetaBiomeSource)biomes;
        this.seed = seed;
        if (settings.settings.method_10545("generateVanillaBiomesBeta")) {
            this.generateVanillaBiomes = settings.settings.method_10577("generateVanillaBiomesBeta");
        }
        RAND.setSeed(seed);
        this.minLimitNoiseOctaves = new OldNoiseGeneratorOctaves(RAND, 16, false);
        this.maxLimitNoiseOctaves = new OldNoiseGeneratorOctaves(RAND, 16, false);
        this.mainNoiseOctaves = new OldNoiseGeneratorOctaves(RAND, 8, false);
        this.beachNoiseOctaves = new OldNoiseGeneratorOctaves(RAND, 4, false);
        this.stoneNoiseOctaves = new OldNoiseGeneratorOctaves(RAND, 4, false);
        this.scaleNoiseOctaves = new OldNoiseGeneratorOctaves(RAND, 10, false);
        this.depthNoiseOctaves = new OldNoiseGeneratorOctaves(RAND, 16, false);
        this.forestNoiseOctaves = new OldNoiseGeneratorOctaves(RAND, 8, false);
        if (settings.settings.method_10545("generateSkyDim")) {
            this.generateSkyDim = settings.settings.method_10577("generateSkyDim");
        }
        BetaDecorator.COUNT_BETA_NOISE_DECORATOR.setOctaves(this.forestNoiseOctaves);
        GROUND_CACHE_Y.clear();
    }

    public static void register() {
        class_2378.method_10230((class_2378)class_2378.field_25097, (class_2960)new class_2960("modern_beta", "skylands"), CODEC);
    }

    protected Codec<? extends class_2794> method_28506() {
        return CODEC;
    }

    public void method_12088(class_1936 worldAccess, class_5138 structureAccessor, class_2791 chunk) {
        RAND.setSeed((long)chunk.method_12004().field_9181 * 341873128712L + (long)chunk.method_12004().field_9180 * 132897987541L);
        BiomeUtil.fetchTempHumid(chunk.method_12004().field_9181 << 4, chunk.method_12004().field_9180 << 4, TEMPS, HUMIDS);
        this.generateTerrain(chunk, TEMPS, structureAccessor);
        BetaFeature.OLD_FANCY_OAK.chunkReset();
    }

    public void method_12108(long seed, class_4543 biomeAccess, class_2791 chunk, class_2893.class_2894 carver) {
        class_4543 biomeAcc = biomeAccess.method_22392((class_1966)this.biomeSource);
        class_1923 chunkPos = chunk.method_12004();
        int mainChunkX = chunkPos.field_9181;
        int mainChunkZ = chunkPos.field_9180;
        int biomeX = mainChunkX << 2;
        int biomeZ = mainChunkZ << 2;
        int absX = biomeX << 2;
        int absZ = biomeZ << 2;
        class_5485 generationSettings = this.biomeSource.method_16359(biomeX, 0, biomeZ).method_30970();
        BitSet bitSet = ((class_2839)chunk).method_28510(carver);
        RAND.setSeed(this.seed);
        long l = RAND.nextLong() / 2L * 2L + 1L;
        long l1 = RAND.nextLong() / 2L * 2L + 1L;
        for (int chunkX = mainChunkX - 8; chunkX <= mainChunkX + 8; ++chunkX) {
            for (int chunkZ = mainChunkZ - 8; chunkZ <= mainChunkZ + 8; ++chunkZ) {
                List carverList = generationSettings.method_30976(carver);
                ListIterator carverIterator = carverList.listIterator();
                while (carverIterator.hasNext()) {
                    class_2922 configuredCarver = (class_2922)((Supplier)carverIterator.next()).get();
                    RAND.setSeed((long)chunkX * l + (long)chunkZ * l1 ^ seed);
                    if (!configuredCarver.method_12669(RAND, chunkX, chunkZ)) continue;
                    configuredCarver.method_12668(chunk, arg_0 -> ((class_4543)biomeAcc).method_22393(arg_0), RAND, this.method_16398(), chunkX, chunkZ, mainChunkX, mainChunkZ, bitSet);
                }
            }
        }
    }

    public void method_12110(class_3233 chunkRegion, class_2791 chunk) {
        this.buildBetaSurface(chunkRegion, chunk);
    }

    public void generateTerrain(class_2791 chunk, double[] temps, class_5138 structureAccessor) {
        int byte2 = 2;
        int byte33 = 33;
        int int3_0 = byte2 + 1;
        int int3_1 = byte2 + 1;
        class_2902 heightmapOCEAN = chunk.method_12032(class_2902.class_2903.field_13195);
        class_2902 heightmapSURFACE = chunk.method_12032(class_2902.class_2903.field_13194);
        GenUtil.collectStructures(chunk, structureAccessor, STRUCTURE_LIST, JIGSAW_LIST);
        ObjectListIterator structureListIterator = STRUCTURE_LIST.iterator();
        ObjectListIterator jigsawListIterator = JIGSAW_LIST.iterator();
        this.generateHeightmap(chunk.method_12004().field_9181 * byte2, 0, chunk.method_12004().field_9180 * byte2);
        for (int i = 0; i < byte2; ++i) {
            for (int j = 0; j < byte2; ++j) {
                for (int k = 0; k < 32; ++k) {
                    double quarter = 0.25;
                    double var1 = HEIGHTMAP[((i + 0) * int3_1 + (j + 0)) * byte33 + (k + 0)];
                    double var2 = HEIGHTMAP[((i + 0) * int3_1 + (j + 1)) * byte33 + (k + 0)];
                    double var3 = HEIGHTMAP[((i + 1) * int3_1 + (j + 0)) * byte33 + (k + 0)];
                    double var4 = HEIGHTMAP[((i + 1) * int3_1 + (j + 1)) * byte33 + (k + 0)];
                    double var5 = (HEIGHTMAP[((i + 0) * int3_1 + (j + 0)) * byte33 + (k + 1)] - var1) * quarter;
                    double var6 = (HEIGHTMAP[((i + 0) * int3_1 + (j + 1)) * byte33 + (k + 1)] - var2) * quarter;
                    double var7 = (HEIGHTMAP[((i + 1) * int3_1 + (j + 0)) * byte33 + (k + 1)] - var3) * quarter;
                    double var8 = (HEIGHTMAP[((i + 1) * int3_1 + (j + 1)) * byte33 + (k + 1)] - var4) * quarter;
                    for (int l = 0; l < 4; ++l) {
                        double eighth = 0.125;
                        double var10 = var1;
                        double var11 = var2;
                        double var12 = (var3 - var1) * eighth;
                        double var13 = (var4 - var2) * eighth;
                        for (int m = 0; m < 8; ++m) {
                            int x = m + i * 8;
                            int y = k * 4 + l;
                            int z = j * 8;
                            double var14 = 0.125;
                            double density = var10;
                            double var16 = (var11 - var10) * var14;
                            int absX = (chunk.method_12004().field_9181 << 4) + x;
                            for (int n = 0; n < 8; ++n) {
                                int absZ = (chunk.method_12004().field_9180 << 4) + z;
                                double temp = 0.0;
                                double clampedDensity = class_3532.method_15350((double)(density / 200.0), (double)-1.0, (double)1.0);
                                clampedDensity = clampedDensity / 2.0 - clampedDensity * clampedDensity * clampedDensity / 24.0;
                                while (structureListIterator.hasNext()) {
                                    class_3443 curStructurePiece = (class_3443)structureListIterator.next();
                                    class_3341 blockBox = curStructurePiece.method_14935();
                                    int sX = Math.max(0, Math.max(blockBox.field_14381 - absX, absX - blockBox.field_14378));
                                    int sY = y - (blockBox.field_14380 + (curStructurePiece instanceof class_3790 ? ((class_3790)curStructurePiece).method_16646() : 0));
                                    int sZ = Math.max(0, Math.max(blockBox.field_14379 - absZ, absZ - blockBox.field_14376));
                                    clampedDensity += class_3754.method_16572((int)sX, (int)sY, (int)sZ) * 0.8;
                                }
                                structureListIterator.back(STRUCTURE_LIST.size());
                                while (jigsawListIterator.hasNext()) {
                                    class_3780 curJigsawJunction = (class_3780)jigsawListIterator.next();
                                    int jX = absX - curJigsawJunction.method_16610();
                                    int jY = y - curJigsawJunction.method_16611();
                                    int jZ = absZ - curJigsawJunction.method_16609();
                                    clampedDensity += class_3754.method_16572((int)jX, (int)jY, (int)jZ) * 0.4;
                                }
                                jigsawListIterator.back(JIGSAW_LIST.size());
                                class_2680 blockToSet = this.getBlockState(clampedDensity, y, temp);
                                chunk.method_12010((class_2338)POS.method_10103(x, y, z), blockToSet, false);
                                heightmapOCEAN.method_12597(x, y, z, blockToSet);
                                heightmapSURFACE.method_12597(x, y, z, blockToSet);
                                ++z;
                                density += var16;
                            }
                            var10 += var12;
                            var11 += var13;
                        }
                        var1 += var5;
                        var2 += var6;
                        var3 += var7;
                        var4 += var8;
                    }
                }
            }
        }
    }

    private void generateHeightmap(int x, int y, int z) {
        int byte2 = 2;
        int byte33 = 33;
        int int3_0 = byte2 + 1;
        int int3_1 = byte2 + 1;
        double coordinateScale = 684.412;
        double heightScale = 684.412;
        double depthNoiseScaleX = 200.0;
        double depthNoiseScaleZ = 200.0;
        double depthNoiseScaleExponent = 0.5;
        double mainNoiseScaleX = 80.0;
        double mainNoiseScaleY = 160.0;
        double mainNoiseScaleZ = 80.0;
        double lowerLimitScale = 512.0;
        double upperLimitScale = 512.0;
        double[] temps = TEMPS;
        double[] humids = HUMIDS;
        this.scaleNoise = this.scaleNoiseOctaves.func_4109_a(this.scaleNoise, x, z, int3_0, int3_1, 1.121, 1.121, 0.5);
        this.depthNoise = this.depthNoiseOctaves.func_4109_a(this.depthNoise, x, z, int3_0, int3_1, depthNoiseScaleX, depthNoiseScaleZ, depthNoiseScaleExponent);
        this.mainNoise = this.mainNoiseOctaves.generateBetaNoiseOctaves(this.mainNoise, x, y, z, int3_0, byte33, int3_1, (coordinateScale *= 2.0) / mainNoiseScaleX, heightScale / mainNoiseScaleY, coordinateScale / mainNoiseScaleZ);
        this.minLimitNoise = this.minLimitNoiseOctaves.generateBetaNoiseOctaves(this.minLimitNoise, x, y, z, int3_0, byte33, int3_1, coordinateScale, heightScale, coordinateScale);
        this.maxLimitNoise = this.maxLimitNoiseOctaves.generateBetaNoiseOctaves(this.maxLimitNoise, x, y, z, int3_0, byte33, int3_1, coordinateScale, heightScale, coordinateScale);
        int i = 0;
        int j = 0;
        int k = 16 / int3_0;
        for (int l = 0; l < int3_0; ++l) {
            int idx0 = l * k + k / 2;
            for (int m = 0; m < int3_1; ++m) {
                double depthMod;
                int idx1 = m * k + k / 2;
                double curTemp = temps[idx0 * 16 + idx1];
                double curHumid = humids[idx0 * 16 + idx1] * curTemp;
                double humidMod = 1.0 - curHumid;
                humidMod *= humidMod;
                humidMod *= humidMod;
                humidMod = 1.0 - humidMod;
                double scaleMod = (this.scaleNoise[j] + 256.0) / 512.0;
                if ((scaleMod *= humidMod) > 1.0) {
                    scaleMod = 1.0;
                }
                if ((depthMod = this.depthNoise[j] / 8000.0) < 0.0) {
                    depthMod = -depthMod * 0.3;
                }
                if ((depthMod = depthMod * 3.0 - 2.0) > 1.0) {
                    depthMod = 1.0;
                }
                depthMod /= 8.0;
                depthMod = 0.0;
                if (scaleMod < 0.0) {
                    scaleMod = 0.0;
                }
                scaleMod += 0.5;
                depthMod = depthMod * (double)byte33 / 16.0;
                double depthMod2 = (double)byte33 / 16.0;
                ++j;
                for (int n = 0; n < byte33; ++n) {
                    double heightVal = 0.0;
                    double scaleMod2 = ((double)n - depthMod2) * 8.0 / scaleMod;
                    if (scaleMod2 < 0.0) {
                        scaleMod2 *= -1.0;
                    }
                    double minLimitMod = this.minLimitNoise[i] / lowerLimitScale;
                    double maxLimitMod = this.maxLimitNoise[i] / upperLimitScale;
                    double mainNoiseMod = (this.mainNoise[i] / 10.0 + 1.0) / 2.0;
                    heightVal = mainNoiseMod < 0.0 ? minLimitMod : (mainNoiseMod > 1.0 ? maxLimitMod : minLimitMod + (maxLimitMod - minLimitMod) * mainNoiseMod);
                    heightVal -= 8.0;
                    int int_32 = 32;
                    if (n > byte33 - int_32) {
                        double d13 = (float)(n - (byte33 - int_32)) / ((float)int_32 - 1.0f);
                        heightVal = heightVal * (1.0 - d13) + -30.0 * d13;
                    }
                    if (n < (int_32 = 8)) {
                        double d14 = (float)(int_32 - n) / ((float)int_32 - 1.0f);
                        heightVal = heightVal * (1.0 - d14) + -30.0 * d14;
                    }
                    SkylandsChunkGenerator.HEIGHTMAP[i] = heightVal;
                    ++i;
                }
            }
        }
    }

    private void buildBetaSurface(class_3233 region, class_2791 chunk) {
        byte seaLevel = (byte)this.method_16398();
        double thirtysecond = 0.03125;
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        BiomeUtil.fetchTempHumid(chunkX << 4, chunkZ << 4, TEMPS, HUMIDS);
        this.biomeSource.fetchBiomes(TEMPS, HUMIDS, BIOMES, null);
        this.stoneNoise = this.stoneNoiseOctaves.generateBetaNoiseOctaves(this.stoneNoise, chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, thirtysecond * 2.0, thirtysecond * 2.0, thirtysecond * 2.0);
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                int genStone = (int)(this.stoneNoise[z + x * 16] / 3.0 + 3.0 + RAND.nextDouble() * 0.25);
                int flag = -1;
                int absX = (chunkX << 4) + x;
                int absZ = (chunkZ << 4) + z;
                class_1959 curBiome = this.generateVanillaBiomes ? region.method_23753((class_2338)POS.method_10103(absX, 0, absZ)) : BIOMES[z + x * 16];
                class_2680 biomeTopBlock = curBiome.method_30970().method_30985().method_15337();
                class_2680 biomeFillerBlock = curBiome.method_30970().method_30985().method_15336();
                class_2680 topBlock = biomeTopBlock;
                class_2680 fillerBlock = biomeFillerBlock;
                for (int y = 127; y >= 0; --y) {
                    class_2248 someBlock = chunk.method_8320((class_2338)POS.method_10103(x, y, z)).method_26204();
                    if (someBlock.equals(class_2246.field_10124)) {
                        flag = -1;
                        continue;
                    }
                    if (!someBlock.equals(class_2246.field_10340)) continue;
                    if (flag == -1) {
                        if (genStone <= 0) {
                            topBlock = BlockStates.AIR;
                            fillerBlock = BlockStates.STONE;
                        }
                        flag = genStone;
                        if (y >= 0) {
                            chunk.method_12010((class_2338)POS.method_10103(x, y, z), topBlock, false);
                            continue;
                        }
                        chunk.method_12010((class_2338)POS.method_10103(x, y, z), fillerBlock, false);
                        continue;
                    }
                    if (flag <= 0) continue;
                    chunk.method_12010((class_2338)POS.method_10103(x, y, z), fillerBlock, false);
                    if (--flag != 0 || !fillerBlock.equals(BlockStates.SAND)) continue;
                    flag = RAND.nextInt(4);
                    fillerBlock = BlockStates.SANDSTONE;
                }
            }
        }
    }

    protected class_2680 getBlockState(double density, int y, double temp) {
        class_2680 blockStateToSet = BlockStates.AIR;
        if (density > 0.0) {
            blockStateToSet = this.settings.wrapped.method_28005();
        }
        return blockStateToSet;
    }

    public int method_16397(int x, int z, class_2902.class_2903 type) {
        class_2338 structPos = new class_2338(x, 0, z);
        SkylandsChunkGenerator.fillChunkY();
        if (GROUND_CACHE_Y.get(structPos) == null) {
            BiomeUtil.fetchTempHumid(x >> 4 << 4, z >> 4 << 4, TEMPS, HUMIDS);
            this.sampleHeightmap(x, z);
        }
        int groundHeight = GROUND_CACHE_Y.get(structPos);
        return groundHeight;
    }

    private static void fillChunkY() {
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                SkylandsChunkGenerator.CHUNK_Y[x][z] = 16;
            }
        }
    }

    private void sampleHeightmap(int absX, int absZ) {
        int byte2 = 2;
        int byte33 = 33;
        int int3_0 = byte2 + 1;
        int int3_1 = byte2 + 1;
        int chunkX = absX >> 4;
        int chunkZ = absZ >> 4;
        this.generateHeightmap(chunkX * byte2, 0, chunkZ * byte2);
        for (int i = 0; i < byte2; ++i) {
            for (int j = 0; j < byte2; ++j) {
                for (int k = 0; k < 16; ++k) {
                    double quarter = 0.25;
                    double var1 = HEIGHTMAP[((i + 0) * int3_1 + (j + 0)) * byte33 + (k + 0)];
                    double var2 = HEIGHTMAP[((i + 0) * int3_1 + (j + 1)) * byte33 + (k + 0)];
                    double var3 = HEIGHTMAP[((i + 1) * int3_1 + (j + 0)) * byte33 + (k + 0)];
                    double var4 = HEIGHTMAP[((i + 1) * int3_1 + (j + 1)) * byte33 + (k + 0)];
                    double var5 = (HEIGHTMAP[((i + 0) * int3_1 + (j + 0)) * byte33 + (k + 1)] - var1) * quarter;
                    double var6 = (HEIGHTMAP[((i + 0) * int3_1 + (j + 1)) * byte33 + (k + 1)] - var2) * quarter;
                    double var7 = (HEIGHTMAP[((i + 1) * int3_1 + (j + 0)) * byte33 + (k + 1)] - var3) * quarter;
                    double var8 = (HEIGHTMAP[((i + 1) * int3_1 + (j + 1)) * byte33 + (k + 1)] - var4) * quarter;
                    for (int l = 0; l < 4; ++l) {
                        double eighth = 0.125;
                        double var10 = var1;
                        double var11 = var2;
                        double var12 = (var3 - var1) * eighth;
                        double var13 = (var4 - var2) * eighth;
                        for (int m = 0; m < 8; ++m) {
                            int x = m + i * 8;
                            int y = k * 4 + l;
                            int z = j * 8;
                            double var14 = 0.125;
                            double density = var10;
                            double var16 = (var11 - var10) * var14;
                            for (int n = 0; n < 8; ++n) {
                                if (density > 0.0) {
                                    SkylandsChunkGenerator.CHUNK_Y[x][z] = y;
                                }
                                ++z;
                                density += var16;
                            }
                            var10 += var12;
                            var11 += var13;
                        }
                        var1 += var5;
                        var2 += var6;
                        var3 += var7;
                        var4 += var8;
                    }
                }
            }
        }
        for (int pX = 0; pX < CHUNK_Y.length; ++pX) {
            for (int pZ = 0; pZ < CHUNK_Y[pX].length; ++pZ) {
                class_2338 structPos = new class_2338((chunkX << 4) + pX, 0, (chunkZ << 4) + pZ);
                GROUND_CACHE_Y.put(structPos, CHUNK_Y[pX][pZ] + 1);
            }
        }
    }

    public class_2338 method_12103(class_3218 world, class_3195<?> feature, class_2338 center, int radius, boolean skipExistingChunks) {
        if (feature.equals((Object)class_3195.field_24854) || feature.equals((Object)class_3195.field_24850) || feature.equals((Object)class_3195.field_24857) || feature.equals(BetaStructure.OCEAN_SHRINE_STRUCTURE)) {
            return null;
        }
        return super.method_12103(world, feature, center, radius, skipExistingChunks);
    }

    public int method_12104() {
        return 128;
    }

    public int method_16398() {
        return 64;
    }

    public class_2794 method_27997(long seed) {
        return new SkylandsChunkGenerator(this.biomeSource.method_27985(seed), seed, this.settings);
    }

    public boolean isSkyDim() {
        return this.generateSkyDim;
    }
}

