/*
 * Decompiled with CFR 0.152.
 */
package com.bespectacled.modernbeta.mixin;

import com.bespectacled.modernbeta.ModernBeta;
import com.bespectacled.modernbeta.config.ModernBetaConfig;
import com.bespectacled.modernbeta.util.BiomeUtil;
import com.bespectacled.modernbeta.util.MutableBlockColors;
import net.minecraft.class_1920;
import net.minecraft.class_1926;
import net.minecraft.class_1933;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_324;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_324.class}, priority=1)
public class MixinBlockColors
implements MutableBlockColors {
    @Unique
    private static ModernBetaConfig BETA_CONFIG = ModernBeta.BETA_CONFIG;
    private static boolean useBetaColors = false;
    private static final class_2680 GRASS = class_2246.field_10479.method_9564();
    private static final class_2680 FERN = class_2246.field_10112.method_9564();
    private static final class_2680 TALL_GRASS = class_2246.field_10214.method_9564();
    private static final class_2680 TALL_FERN = class_2246.field_10313.method_9564();
    private static final double[] TEMP_HUMID = new double[2];

    @Override
    @Unique
    public void setSeed(long seed) {
        BiomeUtil.setSeed(MixinBlockColors.BETA_CONFIG.fixedSeed != 0L ? MixinBlockColors.BETA_CONFIG.fixedSeed : seed);
    }

    @Override
    @Unique
    public void setSeed(long seed, boolean isBetaWorld) {
        if (isBetaWorld) {
            BiomeUtil.setSeed(MixinBlockColors.BETA_CONFIG.fixedSeed != 0L ? MixinBlockColors.BETA_CONFIG.fixedSeed : seed);
        }
        useBetaColors = isBetaWorld;
    }

    @Inject(method={"method_1685"}, at={@At(value="HEAD")}, cancellable=true)
    @Dynamic(value="Reed color lambda method")
    private static void onReedColor(class_2680 state, class_1920 world, class_2338 pos, int tintIdx, CallbackInfoReturnable<Integer> info) {
        if (MixinBlockColors.BETA_CONFIG.renderBetaBiomeColor) {
            info.setReturnValue((Object)0xFFFFFF);
        }
    }

    @Inject(method={"method_1686"}, at={@At(value="HEAD")}, cancellable=true)
    @Dynamic(value="Two high grass color lambda method")
    private static void onDoubleTallGrassColor(class_2680 state, class_1920 world, class_2338 pos, int tintIdx, CallbackInfoReturnable<Integer> info) {
        if (MixinBlockColors.BETA_CONFIG.renderBetaBiomeColor && useBetaColors) {
            info.setReturnValue((Object)MixinBlockColors.getGrassColor(state, world, pos));
        }
    }

    @Inject(method={"method_1693"}, at={@At(value="HEAD")}, cancellable=true)
    @Dynamic(value="Grass color lambda method")
    private static void onGrassColor(class_2680 state, class_1920 world, class_2338 pos, int tintIdx, CallbackInfoReturnable<Integer> info) {
        if (MixinBlockColors.BETA_CONFIG.renderBetaBiomeColor && useBetaColors) {
            info.setReturnValue((Object)MixinBlockColors.getGrassColor(state, world, pos));
        }
    }

    @Inject(method={"method_1692"}, at={@At(value="HEAD")}, cancellable=true)
    @Dynamic(value="Foliage color lambda method")
    private static void onFoliageColor(class_2680 state, class_1920 world, class_2338 pos, int tintIdx, CallbackInfoReturnable<Integer> info) {
        if (MixinBlockColors.BETA_CONFIG.renderBetaBiomeColor && useBetaColors) {
            info.setReturnValue((Object)MixinBlockColors.getFoliageColor(world, pos));
        }
    }

    @Unique
    private static int getGrassColor(class_2680 state, class_1920 world, class_2338 pos) {
        if (world == null || pos == null) {
            return 8174955;
        }
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        if (state.equals(GRASS) || state.equals(FERN) || state.equals(TALL_GRASS) || state.equals(TALL_FERN)) {
            long shift = x * 3129871 + z * 6129781 + y;
            shift = shift * shift * 42317861L + shift * 11L;
            x = (int)((long)x + (shift >> 14 & 0x1FL));
            y = (int)((long)y + (shift >> 19 & 0x1FL));
            z = (int)((long)z + (shift >> 24 & 0x1FL));
        }
        BiomeUtil.fetchTempHumidAtPoint(TEMP_HUMID, x, z);
        return class_1933.method_8377((double)TEMP_HUMID[0], (double)TEMP_HUMID[1]);
    }

    @Unique
    private static int getFoliageColor(class_1920 world, class_2338 pos) {
        if (world == null || pos == null) {
            return 4764952;
        }
        int x = pos.method_10263();
        int z = pos.method_10260();
        BiomeUtil.fetchTempHumidAtPoint(TEMP_HUMID, x, z);
        return class_1926.method_8344((double)TEMP_HUMID[0], (double)TEMP_HUMID[1]);
    }
}

