/*
 * Decompiled with CFR 0.152.
 */
package com.bespectacled.modernbeta.mixin;

import com.bespectacled.modernbeta.ModernBeta;
import com.bespectacled.modernbeta.biome.IOldBiomeSource;
import com.bespectacled.modernbeta.config.ModernBetaConfig;
import com.bespectacled.modernbeta.gen.BetaChunkGenerator;
import com.bespectacled.modernbeta.gen.SkylandsChunkGenerator;
import com.bespectacled.modernbeta.util.BiomeUtil;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_761;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_638.class}, priority=1)
public abstract class MixinClientWorld
extends class_1937 {
    @Unique
    private class_2338 curBlockPos = new class_2338(0, 0, 0);
    @Unique
    private ModernBetaConfig BETA_CONFIG = ModernBeta.BETA_CONFIG;
    @Unique
    private boolean isBetaWorld = true;
    @Unique
    private boolean isOverworld = false;
    @Shadow
    private class_310 field_3729;
    @Unique
    private long worldSeed = 0L;

    private MixinClientWorld() {
        super(null, null, null, null, false, false, 0L);
    }

    @Unique
    private static void setSeed(long seed) {
        BiomeUtil.setSeed(seed);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(class_634 netHandler, class_638.class_5271 properties, class_5321<class_1937> worldKey, class_2874 dimensionType, int loadDistance, Supplier<class_3695> profiler, class_761 renderer, boolean debugWorld, long seed, CallbackInfo ci) {
        if (this.field_3729.method_1576() != null) {
            class_2794 generator = this.field_3729.method_1576().method_30002().method_14178().method_12129();
            this.setWorldProperties(generator, generator.field_24748);
        }
        this.isOverworld = worldKey.method_29177().equals((Object)class_2874.field_24753.method_29177());
        ModernBeta.setBlockColorsSeed(this.worldSeed, this.isBetaWorld);
    }

    @Unique
    private void setWorldProperties(class_2794 gen, long seed) {
        this.worldSeed = seed;
        this.isBetaWorld = false;
        if (gen instanceof BetaChunkGenerator || gen instanceof SkylandsChunkGenerator && !((SkylandsChunkGenerator)gen).isSkyDim()) {
            this.isBetaWorld = true;
            if (((IOldBiomeSource)gen.method_12098()).usesVanillaBiomes()) {
                this.isBetaWorld = false;
            }
            this.worldSeed = this.BETA_CONFIG.fixedSeed == 0L ? this.worldSeed : this.BETA_CONFIG.fixedSeed;
            MixinClientWorld.setSeed(this.worldSeed);
        }
    }

    @ModifyVariable(method={"method_23777"}, at=@At(value="HEAD"), index=1)
    private class_2338 captureBlockPos(class_2338 pos) {
        this.curBlockPos = pos;
        return pos;
    }

    @ModifyVariable(method={"method_23777"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/biome/Biome;getSkyColor()I"), index=6)
    private int injectBetaSkyColor(int skyColor) {
        if (this.isBetaWorld && this.BETA_CONFIG.renderBetaSkyColor && this.isOverworld) {
            skyColor = this.getBetaSkyColor(this.curBlockPos);
        }
        return skyColor;
    }

    private int getBetaSkyColor(class_2338 pos) {
        int x = pos.method_10263();
        int z = pos.method_10260();
        float temp = (float)BiomeUtil.fetchSkyTemp(x, z);
        int skyColor = MixinClientWorld.getSkyColorByTemp(temp);
        return skyColor;
    }

    @Unique
    private static int getSkyColorByTemp(float temp) {
        if ((temp /= 3.0f) < -1.0f) {
            temp = -1.0f;
        }
        if (temp > 1.0f) {
            temp = 1.0f;
        }
        return Color.getHSBColor(0.6222222f - temp * 0.05f, 0.5f + temp * 0.1f, 1.0f).getRGB();
    }
}

