/*
 * Decompiled with CFR 0.152.
 */
package com.bespectacled.modernbeta.mixin;

import com.bespectacled.modernbeta.biome.AlphaBiomeSource;
import com.bespectacled.modernbeta.biome.BetaBiomeSource;
import com.bespectacled.modernbeta.biome.IndevBiomeSource;
import com.bespectacled.modernbeta.biome.InfdevBiomeSource;
import com.bespectacled.modernbeta.gen.AlphaChunkGenerator;
import com.bespectacled.modernbeta.gen.BetaChunkGenerator;
import com.bespectacled.modernbeta.gen.IndevChunkGenerator;
import com.bespectacled.modernbeta.gen.InfdevChunkGenerator;
import com.bespectacled.modernbeta.gen.SkylandsChunkGenerator;
import com.bespectacled.modernbeta.gen.settings.AlphaGeneratorSettings;
import com.bespectacled.modernbeta.gen.settings.BetaGeneratorSettings;
import com.bespectacled.modernbeta.gen.settings.IndevGeneratorSettings;
import com.bespectacled.modernbeta.gen.settings.InfdevGeneratorSettings;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2487;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_3754;
import net.minecraft.class_5284;
import net.minecraft.class_5285;
import net.minecraft.class_5308;
import net.minecraft.class_5309;
import net.minecraft.class_5310;
import net.minecraft.class_5311;
import net.minecraft.class_5313;
import net.minecraft.class_5455;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_5285.class})
public class MixinGeneratorOptions {
    @Inject(method={"fromProperties"}, at={@At(value="HEAD")}, cancellable=true)
    private static void injectOverworldTwo(class_5455 dynamicRegistryManager, Properties properties, CallbackInfoReturnable<class_5285> cir) {
        if (properties.get("level-type") == null) {
            return;
        }
        String levelType = properties.get("level-type").toString().trim().toLowerCase();
        if (levelType.equals("beta") || levelType.equals("skylands") || levelType.equals("alpha") || levelType.equals("infdev") || levelType.equals("indev")) {
            class_3754 generator;
            String seedField = (String)MoreObjects.firstNonNull((Object)properties.get("level-seed"), (Object)"");
            long seed = new Random().nextLong();
            if (!seedField.isEmpty()) {
                try {
                    long parsedSeed = Long.parseLong(seedField);
                    if (parsedSeed != 0L) {
                        seed = parsedSeed;
                    }
                }
                catch (NumberFormatException var14) {
                    seed = seedField.hashCode();
                }
            }
            class_2385 dimensions = dynamicRegistryManager.method_30530(class_2378.field_25095);
            class_2385 biomes = dynamicRegistryManager.method_30530(class_2378.field_25114);
            class_2385 chunkgens = dynamicRegistryManager.method_30530(class_2378.field_26374);
            class_2370 dimensionOptions = class_2874.method_28517((class_2378)dimensions, (class_2378)biomes, (class_2378)chunkgens, (long)seed);
            String generate_structures = (String)properties.get("generate-structures");
            boolean generateStructures = generate_structures == null || Boolean.parseBoolean(generate_structures);
            Optional<class_5313> guaranteedStronghold = Optional.of(new class_5313(0, 0, 1));
            class_5311 structures = levelType.equals("indev") ? new class_5311(guaranteedStronghold, (Map)Maps.newHashMap((Map)class_5311.field_24822)) : new class_5311(true);
            class_5308 noiseSampler = new class_5308(1.0, 1.0, 40.0, 22.0);
            class_5309 noise = new class_5309(256, noiseSampler, new class_5310(-10, 3, 0), new class_5310(-30, 0, 0), 1, 2, 1.0, -0.46875, true, true, false, false);
            class_5284 type = new class_5284(structures, noise, class_2246.field_10340.method_9564(), class_2246.field_10382.method_9564(), -10, 0, 64, false);
            class_2487 betaSettings = BetaGeneratorSettings.createSettings();
            class_2487 alphaSettings = AlphaGeneratorSettings.createSettings();
            class_2487 indevSettings = IndevGeneratorSettings.createSettings();
            class_2487 infdevSettings = InfdevGeneratorSettings.createSettings();
            BetaGeneratorSettings betaGenSettings = new BetaGeneratorSettings(type, betaSettings);
            AlphaGeneratorSettings alphaGenSettings = new AlphaGeneratorSettings(type, alphaSettings);
            IndevGeneratorSettings indevGenSettings = new IndevGeneratorSettings(type, indevSettings);
            InfdevGeneratorSettings infdevGenSettings = new InfdevGeneratorSettings(type, infdevSettings);
            switch (levelType) {
                case "beta": {
                    generator = new BetaChunkGenerator(new BetaBiomeSource(seed, (class_2378<class_1959>)biomes, betaGenSettings.settings), seed, betaGenSettings);
                    break;
                }
                case "skylands": {
                    generator = new SkylandsChunkGenerator(new BetaBiomeSource(seed, (class_2378<class_1959>)biomes, betaGenSettings.settings), seed, betaGenSettings);
                    break;
                }
                case "alpha": {
                    generator = new AlphaChunkGenerator(new AlphaBiomeSource(seed, (class_2378<class_1959>)biomes, alphaGenSettings.settings), seed, alphaGenSettings);
                    break;
                }
                case "indev": {
                    generator = new IndevChunkGenerator(new IndevBiomeSource(seed, (class_2378<class_1959>)biomes, indevGenSettings.settings), seed, indevGenSettings);
                    break;
                }
                case "infdev": {
                    generator = new InfdevChunkGenerator(new InfdevBiomeSource(seed, (class_2378<class_1959>)biomes, infdevGenSettings.settings), seed, infdevGenSettings);
                    break;
                }
                default: {
                    generator = new BetaChunkGenerator(new BetaBiomeSource(seed, (class_2378<class_1959>)biomes, betaGenSettings.settings), seed, betaGenSettings);
                }
            }
            cir.setReturnValue((Object)new class_5285(seed, generateStructures, false, class_5285.method_28608((class_2378)dimensions, (class_2370)dimensionOptions, (class_2794)generator)));
        }
    }
}

