/*
 * Decompiled with CFR 0.152.
 */
package com.bespectacled.modernbeta.noise;

import com.bespectacled.modernbeta.noise.OldNoiseGenerator;
import com.bespectacled.modernbeta.util.MathHelper;
import java.util.Random;

public class OldNoiseGeneratorPerlin
extends OldNoiseGenerator {
    private int[] permutations = new int[512];
    public double xCoord;
    public double yCoord;
    public double zCoord;

    public OldNoiseGeneratorPerlin() {
        this(new Random(), false);
    }

    public OldNoiseGeneratorPerlin(Random random, boolean isIndev) {
        int i;
        if (!isIndev) {
            this.xCoord = random.nextDouble() * 256.0;
            this.yCoord = random.nextDouble() * 256.0;
            this.zCoord = random.nextDouble() * 256.0;
        }
        for (i = 0; i < 256; ++i) {
            this.permutations[i] = i;
        }
        for (i = 0; i < 256; ++i) {
            int j = random.nextInt(256 - i) + i;
            int k = this.permutations[i];
            this.permutations[i] = this.permutations[j];
            this.permutations[j] = k;
            this.permutations[i + 256] = this.permutations[i];
        }
    }

    public double generateNoise(double d, double d1, double d2) {
        double d3 = d + this.xCoord;
        double d4 = d1 + this.yCoord;
        double d5 = d2 + this.zCoord;
        int i = (int)d3;
        int j = (int)d4;
        int k = (int)d5;
        if (d3 < (double)i) {
            --i;
        }
        if (d4 < (double)j) {
            --j;
        }
        if (d5 < (double)k) {
            --k;
        }
        int l = i & 0xFF;
        int i1 = j & 0xFF;
        int j1 = k & 0xFF;
        double d6 = (d3 -= (double)i) * d3 * d3 * (d3 * (d3 * 6.0 - 15.0) + 10.0);
        double d7 = (d4 -= (double)j) * d4 * d4 * (d4 * (d4 * 6.0 - 15.0) + 10.0);
        double d8 = (d5 -= (double)k) * d5 * d5 * (d5 * (d5 * 6.0 - 15.0) + 10.0);
        int k1 = this.permutations[l] + i1;
        int l1 = this.permutations[k1] + j1;
        int i2 = this.permutations[k1 + 1] + j1;
        int j2 = this.permutations[l + 1] + i1;
        int k2 = this.permutations[j2] + j1;
        int l2 = this.permutations[j2 + 1] + j1;
        return this.lerp(d8, this.lerp(d7, this.lerp(d6, this.grad(this.permutations[l1], d3, d4, d5), this.grad(this.permutations[k2], d3 - 1.0, d4, d5)), this.lerp(d6, this.grad(this.permutations[i2], d3, d4 - 1.0, d5), this.grad(this.permutations[l2], d3 - 1.0, d4 - 1.0, d5))), this.lerp(d7, this.lerp(d6, this.grad(this.permutations[l1 + 1], d3, d4, d5 - 1.0), this.grad(this.permutations[k2 + 1], d3 - 1.0, d4, d5 - 1.0)), this.lerp(d6, this.grad(this.permutations[i2 + 1], d3, d4 - 1.0, d5 - 1.0), this.grad(this.permutations[l2 + 1], d3 - 1.0, d4 - 1.0, d5 - 1.0))));
    }

    public final double lerp(double d, double d1, double d2) {
        return d1 + d * (d2 - d1);
    }

    public final double func_4110_a(int i, double d, double d1) {
        int j = i & 0xF;
        double d2 = (double)(1 - ((j & 8) >> 3)) * d;
        double d3 = j >= 4 ? (j != 12 && j != 14 ? d1 : d) : 0.0;
        return ((j & 1) != 0 ? -d2 : d2) + ((j & 2) != 0 ? -d3 : d3);
    }

    public final double grad(int hash, double x, double y, double z) {
        switch (hash & 0xF) {
            case 0: {
                return x + y;
            }
            case 1: {
                return -x + y;
            }
            case 2: {
                return x - y;
            }
            case 3: {
                return -x - y;
            }
            case 4: {
                return x + z;
            }
            case 5: {
                return -x + z;
            }
            case 6: {
                return x - z;
            }
            case 7: {
                return -x - z;
            }
            case 8: {
                return y + z;
            }
            case 9: {
                return -y + z;
            }
            case 10: {
                return y - z;
            }
            case 11: {
                return -y - z;
            }
            case 12: {
                return y + x;
            }
            case 13: {
                return -y + z;
            }
            case 14: {
                return y - x;
            }
            case 15: {
                return -y - z;
            }
        }
        return 0.0;
    }

    public double func_801_a(double d, double d1) {
        return this.generateNoise(d, d1, 0.0);
    }

    public final double func_801_a_infdev(double double2, double double4) {
        return this.sampleInfdevNoise(double2, double4, 0.0);
    }

    public final double infdevA(double double2, double double4, double double6) {
        return this.sampleInfdevNoise(double2, double4, double6);
    }

    public void sampleBetaNoise(double[] ad, double d, double d1, double d2, int i, int j, int k, double d3, double d4, double d5, double d6) {
        if (j == 1) {
            int j3 = 0;
            double d12 = 1.0 / d6;
            for (int i4 = 0; i4 < i; ++i4) {
                double d14 = (d + (double)i4) * d3 + this.xCoord;
                int j4 = (int)d14;
                if (d14 < (double)j4) {
                    --j4;
                }
                int k4 = j4 & 0xFF;
                double d17 = (d14 -= (double)j4) * d14 * d14 * (d14 * (d14 * 6.0 - 15.0) + 10.0);
                for (int l4 = 0; l4 < k; ++l4) {
                    double d19 = (d2 + (double)l4) * d5 + this.zCoord;
                    int j5 = (int)d19;
                    if (d19 < (double)j5) {
                        --j5;
                    }
                    int l5 = j5 & 0xFF;
                    double d21 = (d19 -= (double)j5) * d19 * d19 * (d19 * (d19 * 6.0 - 15.0) + 10.0);
                    int l = this.permutations[k4] + 0;
                    int j1 = this.permutations[l] + l5;
                    int k1 = this.permutations[k4 + 1] + 0;
                    int l1 = this.permutations[k1] + l5;
                    double d9 = this.lerp(d17, this.func_4110_a(this.permutations[j1], d14, d19), this.grad(this.permutations[l1], d14 - 1.0, 0.0, d19));
                    double d11 = this.lerp(d17, this.grad(this.permutations[j1 + 1], d14, 0.0, d19 - 1.0), this.grad(this.permutations[l1 + 1], d14 - 1.0, 0.0, d19 - 1.0));
                    double d23 = this.lerp(d21, d9, d11);
                    int n = j3++;
                    ad[n] = ad[n] + d23 * d12;
                }
            }
            return;
        }
        int i1 = 0;
        double d7 = 1.0 / d6;
        int i2 = -1;
        double d13 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d18 = 0.0;
        for (int i5 = 0; i5 < i; ++i5) {
            double d20 = (d + (double)i5) * d3 + this.xCoord;
            int k5 = (int)d20;
            if (d20 < (double)k5) {
                --k5;
            }
            int i6 = k5 & 0xFF;
            double d22 = (d20 -= (double)k5) * d20 * d20 * (d20 * (d20 * 6.0 - 15.0) + 10.0);
            for (int j6 = 0; j6 < k; ++j6) {
                double d24 = (d2 + (double)j6) * d5 + this.zCoord;
                int k6 = (int)d24;
                if (d24 < (double)k6) {
                    --k6;
                }
                int l6 = k6 & 0xFF;
                double d25 = (d24 -= (double)k6) * d24 * d24 * (d24 * (d24 * 6.0 - 15.0) + 10.0);
                for (int i7 = 0; i7 < j; ++i7) {
                    double d26 = (d1 + (double)i7) * d4 + this.yCoord;
                    int j7 = (int)d26;
                    if (d26 < (double)j7) {
                        --j7;
                    }
                    int k7 = j7 & 0xFF;
                    double d27 = (d26 -= (double)j7) * d26 * d26 * (d26 * (d26 * 6.0 - 15.0) + 10.0);
                    if (i7 == 0 || k7 != i2) {
                        i2 = k7;
                        int j2 = this.permutations[i6] + k7;
                        int k2 = this.permutations[j2] + l6;
                        int l2 = this.permutations[j2 + 1] + l6;
                        int i3 = this.permutations[i6 + 1] + k7;
                        int k3 = this.permutations[i3] + l6;
                        int l3 = this.permutations[i3 + 1] + l6;
                        d13 = this.lerp(d22, this.grad(this.permutations[k2], d20, d26, d24), this.grad(this.permutations[k3], d20 - 1.0, d26, d24));
                        d15 = this.lerp(d22, this.grad(this.permutations[l2], d20, d26 - 1.0, d24), this.grad(this.permutations[l3], d20 - 1.0, d26 - 1.0, d24));
                        d16 = this.lerp(d22, this.grad(this.permutations[k2 + 1], d20, d26, d24 - 1.0), this.grad(this.permutations[k3 + 1], d20 - 1.0, d26, d24 - 1.0));
                        d18 = this.lerp(d22, this.grad(this.permutations[l2 + 1], d20, d26 - 1.0, d24 - 1.0), this.grad(this.permutations[l3 + 1], d20 - 1.0, d26 - 1.0, d24 - 1.0));
                    }
                    double d28 = this.lerp(d27, d13, d15);
                    double d29 = this.lerp(d27, d16, d18);
                    double d30 = this.lerp(d25, d28, d29);
                    int n = i1++;
                    ad[n] = ad[n] + d30 * d7;
                }
            }
        }
    }

    public void sampleAlphaNoise(double[] ad, double d, double d1, double d2, int i, int j, int k, double d3, double d4, double d5, double d6) {
        int l = 0;
        double d7 = 1.0 / d6;
        int i1 = -1;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        for (int l2 = 0; l2 < i; ++l2) {
            double d12 = (d + (double)l2) * d3 + this.xCoord;
            int i3 = (int)d12;
            if (d12 < (double)i3) {
                --i3;
            }
            int j3 = i3 & 0xFF;
            double d13 = (d12 -= (double)i3) * d12 * d12 * (d12 * (d12 * 6.0 - 15.0) + 10.0);
            for (int k3 = 0; k3 < k; ++k3) {
                double d14 = (d2 + (double)k3) * d5 + this.zCoord;
                int l3 = (int)d14;
                if (d14 < (double)l3) {
                    --l3;
                }
                int i4 = l3 & 0xFF;
                double d15 = (d14 -= (double)l3) * d14 * d14 * (d14 * (d14 * 6.0 - 15.0) + 10.0);
                for (int j4 = 0; j4 < j; ++j4) {
                    double d16 = (d1 + (double)j4) * d4 + this.yCoord;
                    int k4 = (int)d16;
                    if (d16 < (double)k4) {
                        --k4;
                    }
                    int l4 = k4 & 0xFF;
                    double d17 = (d16 -= (double)k4) * d16 * d16 * (d16 * (d16 * 6.0 - 15.0) + 10.0);
                    if (j4 == 0 || l4 != i1) {
                        i1 = l4;
                        int j1 = this.permutations[j3] + l4;
                        int k1 = this.permutations[j1] + i4;
                        int l1 = this.permutations[j1 + 1] + i4;
                        int i2 = this.permutations[j3 + 1] + l4;
                        int j2 = this.permutations[i2] + i4;
                        int k2 = this.permutations[i2 + 1] + i4;
                        d8 = this.lerp(d13, this.grad(this.permutations[k1], d12, d16, d14), this.grad(this.permutations[j2], d12 - 1.0, d16, d14));
                        d9 = this.lerp(d13, this.grad(this.permutations[l1], d12, d16 - 1.0, d14), this.grad(this.permutations[k2], d12 - 1.0, d16 - 1.0, d14));
                        d10 = this.lerp(d13, this.grad(this.permutations[k1 + 1], d12, d16, d14 - 1.0), this.grad(this.permutations[j2 + 1], d12 - 1.0, d16, d14 - 1.0));
                        d11 = this.lerp(d13, this.grad(this.permutations[l1 + 1], d12, d16 - 1.0, d14 - 1.0), this.grad(this.permutations[k2 + 1], d12 - 1.0, d16 - 1.0, d14 - 1.0));
                    }
                    double d18 = this.lerp(d17, d8, d9);
                    double d19 = this.lerp(d17, d10, d11);
                    double d20 = this.lerp(d15, d18, d19);
                    int n = l++;
                    ad[n] = ad[n] + d20 * d7;
                }
            }
        }
    }

    private static double generateIndevNoise(double double1) {
        return double1 * double1 * double1 * (double1 * (double1 * 6.0 - 15.0) + 10.0);
    }

    public final double sampleIndevNoise(double double2, double double4) {
        double double11 = 0.0;
        double double9 = double4;
        double double7 = double2;
        int integer3 = MathHelper.floor_double(double7) & 0xFF;
        int integer4 = MathHelper.floor_double(double9) & 0xFF;
        int integer5 = MathHelper.floor_double(0.0) & 0xFF;
        double7 -= (double)MathHelper.floor_double(double7);
        double9 -= (double)MathHelper.floor_double(double9);
        double11 = 0.0 - (double)MathHelper.floor_double(0.0);
        double double16 = OldNoiseGeneratorPerlin.generateIndevNoise(double7);
        double double18 = OldNoiseGeneratorPerlin.generateIndevNoise(double9);
        double double20 = OldNoiseGeneratorPerlin.generateIndevNoise(double11);
        int integer6 = this.permutations[integer3] + integer4;
        int integer13 = this.permutations[integer6] + integer5;
        integer6 = this.permutations[integer6 + 1] + integer5;
        integer3 = this.permutations[integer3 + 1] + integer4;
        integer4 = this.permutations[integer3] + integer5;
        integer3 = this.permutations[integer3 + 1] + integer5;
        return this.lerp(double20, this.lerp(double18, this.lerp(double16, this.grad(this.permutations[integer13], double7, double9, double11), this.grad(this.permutations[integer4], double7 - 1.0, double9, double11)), this.lerp(double16, this.grad(this.permutations[integer6], double7, double9 - 1.0, double11), this.grad(this.permutations[integer3], double7 - 1.0, double9 - 1.0, double11))), this.lerp(double18, this.lerp(double16, this.grad(this.permutations[integer13 + 1], double7, double9, double11 - 1.0), this.grad(this.permutations[integer4 + 1], double7 - 1.0, double9, double11 - 1.0)), this.lerp(double16, this.grad(this.permutations[integer6 + 1], double7, double9 - 1.0, double11 - 1.0), this.grad(this.permutations[integer3 + 1], double7 - 1.0, double9 - 1.0, double11 - 1.0))));
    }

    private double sampleInfdevNoise(double double2, double double4, double double6) {
        double double8 = double2 + this.xCoord;
        double double10 = double4 + this.yCoord;
        double double12 = double6 + this.zCoord;
        int integer2 = MathHelper.floor_double(double8) & 0xFF;
        int integer3 = MathHelper.floor_double(double10) & 0xFF;
        int integer4 = MathHelper.floor_double(double12) & 0xFF;
        double8 -= (double)MathHelper.floor_double(double8);
        double10 -= (double)MathHelper.floor_double(double10);
        double12 -= (double)MathHelper.floor_double(double12);
        double double17 = OldNoiseGeneratorPerlin.generateIndevNoise(double8);
        double double19 = OldNoiseGeneratorPerlin.generateIndevNoise(double10);
        double double21 = OldNoiseGeneratorPerlin.generateIndevNoise(double12);
        int integer5 = this.permutations[integer2] + integer3;
        int integer6 = this.permutations[integer5] + integer4;
        integer5 = this.permutations[integer5 + 1] + integer4;
        integer2 = this.permutations[integer2 + 1] + integer3;
        integer3 = this.permutations[integer2] + integer4;
        integer2 = this.permutations[integer2 + 1] + integer4;
        return this.lerp(double21, this.lerp(double19, this.lerp(double17, this.grad(this.permutations[integer6], double8, double10, double12), this.grad(this.permutations[integer3], double8 - 1.0, double10, double12)), this.lerp(double17, this.grad(this.permutations[integer5], double8, double10 - 1.0, double12), this.grad(this.permutations[integer2], double8 - 1.0, double10 - 1.0, double12))), this.lerp(double19, this.lerp(double17, this.grad(this.permutations[integer6 + 1], double8, double10, double12 - 1.0), this.grad(this.permutations[integer3 + 1], double8 - 1.0, double10, double12 - 1.0)), this.lerp(double17, this.grad(this.permutations[integer5 + 1], double8, double10 - 1.0, double12 - 1.0), this.grad(this.permutations[integer2 + 1], double8 - 1.0, double10 - 1.0, double12 - 1.0))));
    }
}

