/*
 * Decompiled with CFR 0.152.
 */
package com.bespectacled.modernbeta.util;

import com.bespectacled.modernbeta.noise.OldNoiseGeneratorOctaves2;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1959;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5458;

public class BiomeUtil {
    public static final int HORIZONTAL_SECTION_COUNT = (int)Math.round(Math.log(16.0) / Math.log(2.0)) - 2;
    public static final int VERTICAL_SECTION_COUNT = (int)Math.round(Math.log(256.0) / Math.log(2.0)) - 2;
    public static final int HORIZONTAL_BIT_MASK = (1 << HORIZONTAL_SECTION_COUNT) - 1;
    public static final int VERTICAL_BIT_MASK = (1 << VERTICAL_SECTION_COUNT) - 1;
    private static OldNoiseGeneratorOctaves2 tempNoiseOctaves = new OldNoiseGeneratorOctaves2(new Random(0L), 4);
    private static OldNoiseGeneratorOctaves2 humidNoiseOctaves = new OldNoiseGeneratorOctaves2(new Random(0L), 4);
    private static OldNoiseGeneratorOctaves2 noiseOctaves = new OldNoiseGeneratorOctaves2(new Random(0L), 2);
    private static final double[] TEMPS = new double[16];
    private static final double[] HUMIDS = new double[16];
    public static double[] noises = null;
    public static double[][] temps2D = new double[16][16];
    public static final List<class_5321<class_1959>> VANILLA_BIOMES;

    public static int computeBiomeIndex(int x, int y, int z) {
        int l = x >> 2 & HORIZONTAL_BIT_MASK;
        int m = class_3532.method_15340((int)(y >> 2), (int)0, (int)VERTICAL_BIT_MASK);
        int n = z >> 2 & HORIZONTAL_BIT_MASK;
        return m << HORIZONTAL_SECTION_COUNT + HORIZONTAL_SECTION_COUNT | n << HORIZONTAL_SECTION_COUNT | l;
    }

    public static void setSeed(long seed) {
        BiomeUtil.initOctaves(seed);
    }

    private static void initOctaves(long seed) {
        tempNoiseOctaves = new OldNoiseGeneratorOctaves2(new Random(seed * 9871L), 4);
        humidNoiseOctaves = new OldNoiseGeneratorOctaves2(new Random(seed * 39811L), 4);
        noiseOctaves = new OldNoiseGeneratorOctaves2(new Random(seed * 543321L), 2);
    }

    public static double fetchNoiseAtPoint(int x, int z) {
        double[] noises = null;
        noises = noiseOctaves.sample(noises, x, z, 1, 1, 0.05, 0.05, 0.3334);
        return noises[0];
    }

    public static void fetchTempHumidAtPoint(double[] arr, int x, int z) {
        double[] temps = tempNoiseOctaves.sample(null, x, z, 1, 1, 0.025f, 0.025f, 0.25);
        double[] humids = humidNoiseOctaves.sample(null, x, z, 1, 1, 0.05f, 0.05f, 0.3333333333333333);
        double[] noises = noiseOctaves.sample(null, x, z, 1, 1, 0.25, 0.25, 0.5882352941176471);
        double d = noises[0] * 1.1 + 0.5;
        double d1 = 0.01;
        double d2 = 1.0 - d1;
        double temp = (temps[0] * 0.15 + 0.7) * d2 + d * d1;
        d1 = 0.002;
        d2 = 1.0 - d1;
        double humid = (humids[0] * 0.15 + 0.5) * d2 + d * d1;
        if ((temp = 1.0 - (1.0 - temp) * (1.0 - temp)) < 0.0) {
            temp = 0.0;
        }
        if (humid < 0.0) {
            humid = 0.0;
        }
        if (temp > 1.0) {
            temp = 1.0;
        }
        if (humid > 1.0) {
            humid = 1.0;
        }
        arr[0] = temp;
        arr[1] = humid;
    }

    public static void fetchTempHumid(int x, int z, double[] temps, double[] humids) {
        int sizeX = 16;
        int sizeZ = 16;
        temps = tempNoiseOctaves.sample(temps, x, z, sizeX, sizeX, 0.025f, 0.025f, 0.25);
        humids = humidNoiseOctaves.sample(humids, x, z, sizeX, sizeX, 0.05f, 0.05f, 0.3333333333333333);
        noises = noiseOctaves.sample(noises, x, z, sizeX, sizeX, 0.25, 0.25, 0.5882352941176471);
        int i = 0;
        for (int j = 0; j < sizeX; ++j) {
            for (int k = 0; k < sizeZ; ++k) {
                double d = noises[i] * 1.1 + 0.5;
                double d1 = 0.01;
                double d2 = 1.0 - d1;
                double temp = (temps[i] * 0.15 + 0.7) * d2 + d * d1;
                d1 = 0.002;
                d2 = 1.0 - d1;
                double humid = (humids[i] * 0.15 + 0.5) * d2 + d * d1;
                if ((temp = 1.0 - (1.0 - temp) * (1.0 - temp)) < 0.0) {
                    temp = 0.0;
                }
                if (humid < 0.0) {
                    humid = 0.0;
                }
                if (temp > 1.0) {
                    temp = 1.0;
                }
                if (humid > 1.0) {
                    humid = 1.0;
                }
                temps[i] = temp;
                humids[i] = humid;
                ++i;
            }
        }
    }

    public static double fetchSkyTemp(int x, int z) {
        double[] skyTemps = null;
        skyTemps = tempNoiseOctaves.sample(skyTemps, x, z, 1, 1, 0.025f, 0.025f, 0.5);
        return skyTemps[0];
    }

    private static boolean isValidCategory(class_1959.class_1961 category) {
        return category != class_1959.class_1961.field_9371 && category != class_1959.class_1961.field_9366 && category != class_1959.class_1961.field_9360;
    }

    static {
        ArrayList<class_5321<class_1959>> biomes = new ArrayList<class_5321<class_1959>>();
        for (Map.Entry entry : class_5458.field_25933.method_29722()) {
            if (!BiomeUtil.isValidCategory(((class_1959)entry.getValue()).method_8688())) continue;
            biomes.add((class_5321<class_1959>)((class_5321)entry.getKey()));
        }
        VANILLA_BIOMES = biomes;
    }
}

