/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.morered;

import com.github.commoble.morered.BlockRegistrar;
import com.github.commoble.morered.ContainerRegistrar;
import com.github.commoble.morered.ItemRegistrar;
import com.github.commoble.morered.RecipeRegistrar;
import com.github.commoble.morered.ServerConfig;
import com.github.commoble.morered.TileEntityRegistrar;
import com.github.commoble.morered.client.ClientEvents;
import com.github.commoble.morered.gatecrafting_plinth.GatecraftingRecipeButtonPacket;
import com.github.commoble.morered.plate_blocks.LogicGateType;
import com.github.commoble.morered.wire_post.IPostsInChunk;
import com.github.commoble.morered.wire_post.PostsInChunk;
import com.github.commoble.morered.wire_post.PostsInChunkCapability;
import com.github.commoble.morered.wire_post.WireBreakPacket;
import com.github.commoble.morered.wire_post.WirePostTileEntity;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityEquipmentPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;

@Mod(value="morered")
public class MoreRed {
    public static final String MODID = "morered";
    public static final String CHANNEL_PROTOCOL_VERSION = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("morered", "main"), () -> "1", "1"::equals, "1"::equals);

    public static ResourceLocation getModRL(String name) {
        return new ResourceLocation(MODID, name);
    }

    public MoreRed() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        ServerConfig.initServerConfig();
        MoreRed.addModListeners(modBus);
        MoreRed.addForgeListeners(forgeBus);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientEvents.addClientListeners(modBus, forgeBus));
        LogicGateType.registerLogicGateTypes(BlockRegistrar.BLOCKS, ItemRegistrar.ITEMS);
    }

    public static void addModListeners(IEventBus modBus) {
        MoreRed.subscribedDeferredRegisters(modBus, BlockRegistrar.BLOCKS, ItemRegistrar.ITEMS, TileEntityRegistrar.TILES, ContainerRegistrar.CONTAINER_TYPES, RecipeRegistrar.RECIPE_SERIALIZERS);
        modBus.addListener(MoreRed::onCommonSetup);
    }

    public static void subscribedDeferredRegisters(IEventBus modBus, DeferredRegister<?> ... registers) {
        for (DeferredRegister<?> register : registers) {
            register.register(modBus);
        }
    }

    public static void onCommonSetup(FMLCommonSetupEvent event) {
        int packetID = 0;
        CHANNEL.registerMessage(packetID++, GatecraftingRecipeButtonPacket.class, GatecraftingRecipeButtonPacket::write, GatecraftingRecipeButtonPacket::read, GatecraftingRecipeButtonPacket::handle);
        CHANNEL.registerMessage(packetID++, WireBreakPacket.class, WireBreakPacket::write, WireBreakPacket::read, WireBreakPacket::handle);
        CapabilityManager.INSTANCE.register(IPostsInChunk.class, (Capability.IStorage)new PostsInChunkCapability.Storage(), PostsInChunk::new);
    }

    public static void addForgeListeners(IEventBus forgeBus) {
        forgeBus.addGenericListener(Chunk.class, MoreRed::onAttachChunkCapabilities);
        forgeBus.addListener(EventPriority.LOW, MoreRed::onEntityPlaceBlock);
    }

    public static void onAttachChunkCapabilities(AttachCapabilitiesEvent<Chunk> event) {
        event.addCapability(MoreRed.getModRL("posts_in_chunk"), (ICapabilityProvider)new PostsInChunk());
    }

    public static void onEntityPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        BlockPos pos = event.getPos();
        IWorld iworld = event.getWorld();
        BlockState state = event.getState();
        if (iworld instanceof World && !iworld.func_201670_d()) {
            World world = (World)iworld;
            Set<ChunkPos> chunkPositions = PostsInChunk.getRelevantChunkPositionsNearPos(pos);
            for (ChunkPos chunkPos : chunkPositions) {
                if (!world.func_175667_e(chunkPos.func_206849_h())) continue;
                Chunk chunk = world.func_212866_a_(chunkPos.field_77276_a, chunkPos.field_77275_b);
                chunk.getCapability(PostsInChunkCapability.INSTANCE).ifPresent(posts -> {
                    HashSet<BlockPos> checkedPostPositions = new HashSet<BlockPos>();
                    for (BlockPos postPos : posts.getPositions()) {
                        TileEntity te = world.func_175625_s(postPos);
                        if (!(te instanceof WirePostTileEntity)) continue;
                        Vec3d hit = ((WirePostTileEntity)te).doesBlockStateIntersectConnection(pos, state, checkedPostPositions);
                        if (hit != null) {
                            event.setCanceled(true);
                            Entity entity = event.getEntity();
                            if (entity instanceof ServerPlayerEntity) {
                                ServerPlayerEntity serverPlayer = (ServerPlayerEntity)entity;
                                serverPlayer.field_71135_a.func_147359_a((IPacket)new SEntityEquipmentPacket(serverPlayer.func_145782_y(), EquipmentSlotType.MAINHAND, serverPlayer.func_184586_b(Hand.MAIN_HAND)));
                                ((ServerWorld)world).func_195600_a(serverPlayer, (IParticleData)RedstoneParticleData.field_197564_a, false, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, 5, 0.05, 0.05, 0.05, 0.0);
                                serverPlayer.func_213823_a(SoundEvents.field_219713_mY, SoundCategory.BLOCKS, 0.5f, 2.0f);
                            }
                            return;
                        }
                        checkedPostPositions.add(postPos);
                    }
                });
            }
        }
    }
}

