/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.morered;

import com.github.commoble.morered.gatecrafting_plinth.GatecraftingRecipe;
import com.github.commoble.morered.gatecrafting_plinth.GatecraftingRecipeSerializer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class RecipeRegistrar {
    public static final DeferredRegister<IRecipeSerializer<?>> RECIPE_SERIALIZERS = new DeferredRegister(ForgeRegistries.RECIPE_SERIALIZERS, "morered");
    public static final IRecipeType<GatecraftingRecipe> GATECRAFTING_RECIPE_TYPE = IRecipeType.func_222147_a((String)"morered:gatecrafting");
    public static final RegistryObject<GatecraftingRecipeSerializer> GATECRAFTING_SERIALIZER = RECIPE_SERIALIZERS.register("gatecrafting", () -> new GatecraftingRecipeSerializer());

    public static List<IRecipe<CraftingInventory>> getAllGatecraftingRecipes(RecipeManager manager) {
        Map map = manager.field_199522_d.getOrDefault(GATECRAFTING_RECIPE_TYPE, Collections.emptyMap());
        return map.entrySet().stream().map(Map.Entry::getValue).sorted(Comparator.comparing(recipe -> recipe.func_77571_b().func_77977_a())).collect(Collectors.toList());
    }

    public static Optional<IRecipe<CraftingInventory>> getGatecraftingRecipe(RecipeManager manager, ResourceLocation id) {
        Map map = manager.field_199522_d.getOrDefault(GATECRAFTING_RECIPE_TYPE, Collections.emptyMap());
        return Optional.ofNullable(map.get(id));
    }
}

