/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.morered.client;

import com.github.commoble.morered.client.ClientConfig;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.LightUtil;
import org.lwjgl.system.MemoryStack;

public class BlockPreviewRenderer
extends BlockModelRenderer {
    private static BlockPreviewRenderer INSTANCE;

    public static BlockPreviewRenderer getInstance(BlockModelRenderer baseRenderer) {
        if (INSTANCE == null || BlockPreviewRenderer.INSTANCE.field_187499_a != baseRenderer.field_187499_a) {
            INSTANCE = new BlockPreviewRenderer(baseRenderer);
        }
        return INSTANCE;
    }

    public BlockPreviewRenderer(BlockModelRenderer baseRenderer) {
        super(baseRenderer.field_187499_a);
    }

    public static void renderBlockPreview(BlockPos pos, BlockState state, World world, Vec3d currentRenderPos, MatrixStack matrix, IRenderTypeBuffer renderTypeBuffer) {
        matrix.func_227860_a_();
        double offsetX = (double)pos.func_177958_n() - currentRenderPos.func_82615_a();
        double offsetY = (double)pos.func_177956_o() - currentRenderPos.func_82617_b();
        double offsetZ = (double)pos.func_177952_p() - currentRenderPos.func_82616_c();
        matrix.func_227861_a_(offsetX, offsetY, offsetZ);
        BlockRendererDispatcher blockDispatcher = Minecraft.func_71410_x().func_175602_ab();
        BlockPreviewRenderer renderer = BlockPreviewRenderer.getInstance(blockDispatcher.func_175019_b());
        renderer.renderModel((ILightReader)world, blockDispatcher.func_184389_a(state), state, pos, matrix, renderTypeBuffer.getBuffer(RenderType.func_228645_f_()), false, world.field_73012_v, state.func_209533_a(pos), OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
        matrix.func_227865_b_();
    }

    public void func_228800_a_(ILightReader world, BlockState state, BlockPos pos, IVertexBuilder buffer, MatrixStack.Entry matrixEntry, BakedQuad quadIn, float tintA, float tintB, float tintC, float tintD, int brightness0, int brightness1, int brightness2, int brightness3, int combinedOverlayIn) {
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        if (quadIn.func_178212_b()) {
            int i = this.field_187499_a.func_228054_a_(state, world, pos, quadIn.func_178211_c());
            r = (float)(i >> 16 & 0xFF) / 255.0f;
            g = (float)(i >> 8 & 0xFF) / 255.0f;
            b = (float)(i & 0xFF) / 255.0f;
        }
        if (quadIn.shouldApplyDiffuseLighting()) {
            float forgeLighting = LightUtil.diffuseLight((Direction)quadIn.func_178210_d());
            r *= forgeLighting;
            g *= forgeLighting;
            b *= forgeLighting;
        }
        BlockPreviewRenderer.addTransparentQuad(matrixEntry, quadIn, new float[]{tintA, tintB, tintC, tintD}, r, g, b, new int[]{brightness0, brightness1, brightness2, brightness3}, combinedOverlayIn, true, buffer);
    }

    public static void addTransparentQuad(MatrixStack.Entry matrixEntry, BakedQuad quad, float[] colorMuls, float r, float g, float b, int[] vertexLights, int combinedOverlayIn, boolean mulColor, IVertexBuilder buffer) {
        int[] vertexData = quad.func_178209_a();
        Vec3i faceVector3i = quad.func_178210_d().func_176730_m();
        Vector3f faceVector = new Vector3f((float)faceVector3i.func_177958_n(), (float)faceVector3i.func_177956_o(), (float)faceVector3i.func_177952_p());
        Matrix4f matrix = matrixEntry.func_227870_a_();
        faceVector.func_229188_a_(matrixEntry.func_227872_b_());
        int vertexDataEntries = vertexData.length / 8;
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(DefaultVertexFormats.field_176600_a.func_177338_f());
            IntBuffer intbuffer = bytebuffer.asIntBuffer();
            for (int vertexIndex = 0; vertexIndex < vertexDataEntries; ++vertexIndex) {
                ((Buffer)intbuffer).clear();
                intbuffer.put(vertexData, vertexIndex * 8, 8);
                float x = bytebuffer.getFloat(0);
                float y = bytebuffer.getFloat(4);
                float z = bytebuffer.getFloat(8);
                float red = colorMuls[vertexIndex] * r;
                float green = colorMuls[vertexIndex] * g;
                float blue = colorMuls[vertexIndex] * b;
                if (mulColor) {
                    float redMultiplier = (float)(bytebuffer.get(12) & 0xFF) / 255.0f;
                    float greenMultiplier = (float)(bytebuffer.get(13) & 0xFF) / 255.0f;
                    float blueMultiplier = (float)(bytebuffer.get(14) & 0xFF) / 255.0f;
                    red = redMultiplier * red;
                    green = greenMultiplier * green;
                    blue = blueMultiplier * blue;
                }
                float ALPHA = ClientConfig.INSTANCE.previewPlacementOpacity.get().floatValue();
                int light = buffer.applyBakedLighting(vertexLights[vertexIndex], bytebuffer);
                float texU = bytebuffer.getFloat(16);
                float texV = bytebuffer.getFloat(20);
                Vector4f posVector = new Vector4f(x, y, z, 1.0f);
                posVector.func_229372_a_(matrix);
                buffer.applyBakedNormals(faceVector, bytebuffer, matrixEntry.func_227872_b_());
                buffer.func_225588_a_(posVector.func_195910_a(), posVector.func_195913_b(), posVector.func_195914_c(), red, green, blue, ALPHA, texU, texV, combinedOverlayIn, light, faceVector.func_195899_a(), faceVector.func_195900_b(), faceVector.func_195902_c());
            }
        }
    }
}

