/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.morered.client;

import com.github.commoble.morered.BlockRegistrar;
import com.github.commoble.morered.ContainerRegistrar;
import com.github.commoble.morered.ItemRegistrar;
import com.github.commoble.morered.TileEntityRegistrar;
import com.github.commoble.morered.client.BlockPreviewRenderer;
import com.github.commoble.morered.client.ClientConfig;
import com.github.commoble.morered.client.ColorHandlers;
import com.github.commoble.morered.client.GatecraftingScreen;
import com.github.commoble.morered.client.WirePostRenderer;
import com.github.commoble.morered.plate_blocks.LogicGateType;
import com.github.commoble.morered.plate_blocks.PlateBlock;
import com.github.commoble.morered.plate_blocks.PlateBlockStateProperties;
import com.github.commoble.morered.util.BlockStateUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ClientEvents {
    public static void addClientListeners(IEventBus modBus, IEventBus forgeBus) {
        ClientConfig.initClientConfig();
        modBus.addListener(ClientEvents::onClientSetup);
        modBus.addListener(ClientEvents::onRegisterBlockColors);
        modBus.addListener(ClientEvents::onRegisterItemColors);
        forgeBus.addListener(ClientEvents::onHighlightBlock);
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        LogicGateType.TYPES.values().forEach(ClientEvents::setLogicGateRenderLayer);
        RenderTypeLookup.setRenderLayer((Block)((Block)BlockRegistrar.LATCH.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)BlockRegistrar.REDWIRE_POST.get()), (RenderType)RenderType.func_228643_e_());
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ContainerRegistrar.GATECRAFTING.get()), GatecraftingScreen::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)TileEntityRegistrar.REDWIRE_POST.get()), WirePostRenderer::new);
    }

    public static void setLogicGateRenderLayer(LogicGateType type) {
        RenderTypeLookup.setRenderLayer((Block)type.blockGetter.get(), (RenderType)RenderType.func_228643_e_());
    }

    public static void onRegisterBlockColors(ColorHandlerEvent.Block event) {
        BlockColors colors = event.getBlockColors();
        LogicGateType.TYPES.values().forEach(type -> colors.func_186722_a(ColorHandlers::getLogicFunctionBlockTint, new Block[]{type.blockGetter.get()}));
        colors.func_186722_a(ColorHandlers::getLatchBlockTint, new Block[]{(Block)BlockRegistrar.LATCH.get()});
        colors.func_186722_a(ColorHandlers::getRedwirePostBlockTint, new Block[]{(Block)BlockRegistrar.REDWIRE_POST.get()});
    }

    public static void onRegisterItemColors(ColorHandlerEvent.Item event) {
        ItemColors colors = event.getItemColors();
        LogicGateType.TYPES.values().forEach(type -> colors.func_199877_a(ColorHandlers::getLogicFunctionBlockItemTint, new IItemProvider[]{(IItemProvider)type.itemGetter.get()}));
        colors.func_199877_a(ColorHandlers::getLatchItemTint, new IItemProvider[]{(IItemProvider)ItemRegistrar.LATCH.get()});
        colors.func_199877_a(ColorHandlers::getRedwirePostItemTint, new IItemProvider[]{(IItemProvider)ItemRegistrar.REDWIRE_POST.get()});
    }

    public static void onHighlightBlock(DrawHighlightEvent.HighlightBlock event) {
        Block block;
        Hand hand;
        Item item;
        ClientPlayerEntity player;
        if (ClientConfig.INSTANCE.showPlacementPreview.get().booleanValue() && (player = Minecraft.func_71410_x().field_71439_g) != null && player.field_70170_p != null && (item = player.func_184586_b((hand = player.func_184600_cs()) == null ? Hand.MAIN_HAND : hand).func_77973_b()) instanceof BlockItem && (block = ((BlockItem)item).func_179223_d()) instanceof PlateBlock) {
            World world = player.field_70170_p;
            BlockRayTraceResult rayTrace = event.getTarget();
            Direction directionAwayFromTargetedBlock = rayTrace.func_216354_b();
            BlockPos placePos = rayTrace.func_216350_a().func_177972_a(directionAwayFromTargetedBlock);
            BlockState existingState = world.func_180495_p(placePos);
            if (existingState.isAir((IBlockReader)world, placePos) || existingState.func_185904_a().func_76222_j()) {
                Vec3d hitVec = rayTrace.func_216347_e();
                Direction attachmentDirection = directionAwayFromTargetedBlock.func_176734_d();
                Vec3d relativeHitVec = hitVec.func_178788_d(new Vec3d((Vec3i)placePos));
                Direction outputDirection = BlockStateUtil.getOutputDirectionFromRelativeHitVec(relativeHitVec, attachmentDirection);
                BlockStateUtil.getRotationIndexForDirection(attachmentDirection, outputDirection);
                BlockState state = PlateBlockStateProperties.getStateForPlacedGatePlate(block.func_176223_P(), placePos, attachmentDirection, relativeHitVec);
                BlockPreviewRenderer.renderBlockPreview(placePos, state, world, event.getInfo().func_216785_c(), event.getMatrix(), event.getBuffers());
            }
        }
    }
}

