/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.morered.client;

import com.github.commoble.morered.BlockRegistrar;
import com.github.commoble.morered.plate_blocks.InputState;
import com.github.commoble.morered.plate_blocks.LatchBlock;
import com.github.commoble.morered.plate_blocks.LogicFunction;
import com.github.commoble.morered.plate_blocks.LogicFunctions;
import com.github.commoble.morered.wire_post.WirePostBlock;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ILightReader;

public class ColorHandlers {
    public static final int NO_TINT = 0xFFFFFF;
    public static final int LIT = 0xFFFFFF;
    public static final int UNLIT = 0x560000;
    public static final int LIT_RED = 255;
    public static final int UNLIT_RED = 86;

    public static int getLogicFunctionBlockTint(BlockState state, ILightReader lightReader, BlockPos pos, int tintIndex) {
        return ColorHandlers.getLogicFunctionBlockStateTint(state, tintIndex);
    }

    public static int getLogicFunctionBlockStateTint(BlockState state, int tintIndex) {
        InputState input = InputState.getInput(state);
        return ColorHandlers.getLogicFunctionTint(tintIndex, input.a, input.b, input.c);
    }

    public static int getLogicFunctionBlockItemTint(ItemStack stack, int tintIndex) {
        Item item = stack.func_77973_b();
        if (item instanceof BlockItem) {
            return ColorHandlers.getLogicFunctionBlockStateTint(((BlockItem)item).func_179223_d().func_176223_P(), tintIndex);
        }
        return 0xFFFFFF;
    }

    public static int getLogicFunctionTint(int tintIndex, boolean a, boolean b, boolean c) {
        if (tintIndex < 1) {
            return 0xFFFFFF;
        }
        LogicFunction logicFunction = (LogicFunction)LogicFunctions.TINTINDEXES.getOrDefault(tintIndex, (Object)LogicFunctions.FALSE);
        return logicFunction.apply(a, b, c) ? 0xFFFFFF : 0x560000;
    }

    public static int getLatchBlockTint(BlockState state, ILightReader lightReader, BlockPos pos, int tintIndex) {
        return ColorHandlers.getLatchTint(state, tintIndex);
    }

    public static int getLatchItemTint(ItemStack stack, int tintIndex) {
        return ColorHandlers.getLatchTint(((LatchBlock)BlockRegistrar.LATCH.get()).func_176223_P(), tintIndex);
    }

    public static int getLatchTint(BlockState state, int tintIndex) {
        if (tintIndex == 18) {
            return (Boolean)state.func_177229_b((IProperty)LatchBlock.POWERED) != false && (Boolean)state.func_177229_b((IProperty)LatchBlock.INPUT_C) == false ? 0xFFFFFF : 0x560000;
        }
        if (tintIndex == 19) {
            return (Boolean)state.func_177229_b((IProperty)LatchBlock.POWERED) == false && (Boolean)state.func_177229_b((IProperty)LatchBlock.INPUT_A) == false ? 0xFFFFFF : 0x560000;
        }
        InputState input = InputState.getInput(state);
        return ColorHandlers.getLogicFunctionTint(tintIndex, input.a, input.b, input.c);
    }

    public static int getRedwirePostBlockTint(BlockState state, ILightReader lightReader, BlockPos pos, int tintIndex) {
        return ColorHandlers.getRedwirePostTint(state, tintIndex);
    }

    public static int getRedwirePostItemTint(ItemStack stack, int tintIndex) {
        return ColorHandlers.getRedwirePostTint(((WirePostBlock)BlockRegistrar.REDWIRE_POST.get()).func_176223_P(), tintIndex);
    }

    public static int getRedwirePostTint(BlockState state, int tintIndex) {
        if (tintIndex == 1) {
            int power = (Integer)state.func_177229_b((IProperty)WirePostBlock.POWER);
            double lerpFactor = (double)power / 15.0;
            return (int)MathHelper.func_219803_d((double)lerpFactor, (double)86.0, (double)255.0) << 16;
        }
        return 0xFFFFFF;
    }
}

