/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.morered.client;

import com.github.commoble.morered.BlockRegistrar;
import com.github.commoble.morered.MoreRed;
import com.github.commoble.morered.RecipeRegistrar;
import com.github.commoble.morered.gatecrafting_plinth.GatecraftingContainer;
import com.github.commoble.morered.gatecrafting_plinth.GatecraftingPlinthBlock;
import com.github.commoble.morered.gatecrafting_plinth.GatecraftingRecipeButtonPacket;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.gui.ScrollPanel;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

public class GatecraftingScreen
extends ContainerScreen<GatecraftingContainer> {
    public static final ResourceLocation TRADING_SCREEN = new ResourceLocation("minecraft:textures/gui/container/villager2.png");
    public static final ResourceLocation CRAFTING_SCREEN = new ResourceLocation("minecraft:textures/gui/container/crafting_table.png");
    public static final int SCROLLPANEL_X = 4;
    public static final int SCROLLPANEL_Y = 17;
    public static final int SCROLLPANEL_WIDTH = 97;
    public static final int SCROLLPANEL_HEIGHT = 142;
    private final String name;
    private GatecraftingScrollPanel scrollPanel;

    public GatecraftingScreen(GatecraftingContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.field_146999_f = 276;
        this.field_147000_g = 166;
        this.name = new TranslationTextComponent(((GatecraftingPlinthBlock)BlockRegistrar.GATECRAFTING_PLINTH.get()).func_149739_a(), new Object[0]).func_150254_d();
    }

    public void init() {
        super.init();
        int xStart = (this.width - this.field_146999_f) / 2;
        int yStart = (this.height - this.field_147000_g) / 2;
        ClientWorld world = this.minecraft.field_71441_e;
        ImmutableList recipes = world != null ? RecipeRegistrar.getAllGatecraftingRecipes(world.func_199532_z()) : ImmutableList.of();
        this.scrollPanel = new GatecraftingScrollPanel(this.minecraft, this, (List<IRecipe<CraftingInventory>>)recipes, xStart + 4, yStart + 17, 97, 142);
        this.children.add(this.scrollPanel);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        if (this.scrollPanel != null) {
            this.scrollPanel.render(mouseX, mouseY, 0.0f);
        }
        this.func_191948_b(mouseX, mouseY);
    }

    public void renderItemStack(ItemStack stack, int x, int y) {
        this.itemRenderer.func_180450_b(stack, x, y);
        this.itemRenderer.func_175030_a(this.font, stack, x, y);
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        if (this.minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.field_147006_u != null && this.field_147006_u.func_75216_d()) {
            this.renderTooltip(this.field_147006_u.func_75211_c(), mouseX, mouseY);
        } else if (this.scrollPanel != null && !this.scrollPanel.tooltipItem.func_190926_b()) {
            this.renderTooltip(this.scrollPanel.tooltipItem, mouseX, mouseY);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String playerName = this.field_213127_e.func_200200_C_().func_150254_d();
        this.font.func_211126_b(this.name, (float)(this.field_146999_f / 2 - this.font.func_78256_a(this.name) / 2), 6.0f, 0x404040);
        this.font.func_211126_b(playerName, 107.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xStart = (this.width - this.field_146999_f) / 2;
        int yStart = (this.height - this.field_147000_g) / 2;
        this.minecraft.func_110434_K().func_110577_a(TRADING_SCREEN);
        GatecraftingScreen.blit((int)xStart, (int)yStart, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (int)512, (int)256);
        int arrowU = 186;
        int arrowV = 36;
        int arrowWidth = 14;
        int arrowHeight = 18;
        int tiles = 4;
        int arrowScreenX = xStart + arrowU - tiles * arrowWidth;
        int arrowScreenY = yStart + arrowV;
        int blitWidth = arrowWidth * tiles;
        GatecraftingScreen.blit((int)arrowScreenX, (int)arrowScreenY, (int)blitWidth, (int)arrowHeight, (float)arrowU, (float)arrowV, (int)arrowWidth, (int)arrowHeight, (int)512, (int)256);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.scrollPanel.mouseDragged(mouseX, mouseY, button, deltaX, deltaY) || super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public static class GatecraftingScrollPanel
    extends ScrollPanel {
        private List<RecipeButton> buttons = new ArrayList<RecipeButton>();
        public ItemStack tooltipItem = ItemStack.field_190927_a;
        public final int totalButtonHeight;

        public GatecraftingScrollPanel(Minecraft client, GatecraftingScreen screen, List<IRecipe<CraftingInventory>> recipes, int left, int top, int width, int height) {
            super(client, width, height, top, left);
            int buttonWidth = 90;
            int totalButtonHeight = 0;
            ClientWorld world = client.field_71441_e;
            if (world != null) {
                for (IRecipe<CraftingInventory> recipe : RecipeRegistrar.getAllGatecraftingRecipes(world.func_199532_z())) {
                    RecipeButton recipeButton = new RecipeButton(screen, recipe, left, top + totalButtonHeight, buttonWidth);
                    this.buttons.add(recipeButton);
                    totalButtonHeight += recipeButton.getHeight();
                }
            }
            this.totalButtonHeight = totalButtonHeight;
        }

        public List<? extends IGuiEventListener> children() {
            return this.buttons;
        }

        protected int getContentHeight() {
            return this.totalButtonHeight;
        }

        protected void drawPanel(int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
            this.tooltipItem = ItemStack.field_190927_a;
            for (RecipeButton button : this.buttons) {
                button.scrollButton((int)this.scrollDistance);
                button.render(mouseX, mouseY, 0.0f);
                if (button.tooltipItem.func_190926_b()) continue;
                this.tooltipItem = button.tooltipItem;
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
    }

    public static class RecipeButton
    extends ExtendedButton {
        private final int baseY;
        private final GatecraftingScreen screen;
        private final IRecipe<CraftingInventory> recipe;
        public ItemStack tooltipItem = ItemStack.field_190927_a;

        public RecipeButton(GatecraftingScreen screen, IRecipe<CraftingInventory> recipe, int x, int y, int width) {
            super(x, y, width, RecipeButton.getHeightForRecipe(recipe), "", button -> RecipeButton.onButtonClicked((GatecraftingContainer)screen.field_147002_h, recipe));
            this.baseY = y;
            this.screen = screen;
            this.recipe = recipe;
        }

        public static void onButtonClicked(GatecraftingContainer container, IRecipe<CraftingInventory> recipe) {
            MoreRed.CHANNEL.sendToServer((Object)new GatecraftingRecipeButtonPacket(recipe.func_199560_c()));
            container.attemptRecipeAssembly(Optional.of(recipe));
        }

        public static int getHeightForRecipe(IRecipe<?> recipe) {
            int rows = 1 + (recipe.func_192400_c().size() - 1) / 3;
            return rows * 18 + 5;
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return false;
        }

        public void renderButton(int mouseX, int mouseY, float partial) {
            this.tooltipItem = ItemStack.field_190927_a;
            if (this.visible) {
                super.renderButton(mouseX, mouseY, partial);
                NonNullList ingredients = this.recipe.func_192400_c();
                int ingredientCount = ingredients.size();
                for (int ingredientIndex = 0; ingredientIndex < ingredientCount; ++ingredientIndex) {
                    ItemStack stack = RecipeButton.getIngredientVariant(((Ingredient)ingredients.get(ingredientIndex)).func_193365_a());
                    int itemRow = ingredientIndex / 3;
                    int itemColumn = ingredientIndex % 3;
                    int itemOffsetX = 2 + itemColumn * 18;
                    int itemOffsetY = 2 + itemRow * 18;
                    int itemX = this.x + itemOffsetX;
                    int itemY = this.y + itemOffsetY;
                    int itemEndX = itemX + 18;
                    int itemEndY = itemY + 18;
                    this.screen.renderItemStack(stack, itemX, itemY);
                    if (mouseX < itemX || mouseX >= itemEndX || mouseY < itemY || mouseY >= itemEndY) continue;
                    this.tooltipItem = stack;
                }
                if (ingredientCount > 0) {
                    int extraIngredientRows = (ingredientCount - 1) / 3;
                    int arrowX = this.x + 2 + 54 + 4;
                    int arrowY = this.y + 2 + 4 + 9 * extraIngredientRows;
                    int arrowWidth = 10;
                    int arrowHeight = 9;
                    int arrowU = 15;
                    int arrowV = 171;
                    ((GatecraftingScreen)this.screen).minecraft.field_71446_o.func_110577_a(TRADING_SCREEN);
                    Screen.blit((int)arrowX, (int)arrowY, (float)arrowU, (float)arrowV, (int)arrowWidth, (int)arrowHeight, (int)512, (int)256);
                    ItemStack outputStack = this.recipe.func_77571_b();
                    if (!outputStack.func_190926_b()) {
                        int itemX = this.x + 2 + 72;
                        int itemY = this.y + 2 + 9 * extraIngredientRows;
                        int itemEndX = itemX + 18;
                        int itemEndY = itemY + 18;
                        this.screen.renderItemStack(outputStack, itemX, itemY);
                        if (mouseX >= itemX && mouseX < itemEndX && mouseY >= itemY && mouseY < itemEndY) {
                            this.tooltipItem = outputStack;
                        }
                    }
                }
            }
        }

        public static ItemStack getIngredientVariant(ItemStack[] variants) {
            int variantCount = variants.length;
            if (variantCount > 0) {
                int variantIndex = (int)(Util.func_211177_b() / 1000L / (long)variantCount);
                return variants[MathHelper.func_76125_a((int)variantIndex, (int)0, (int)(variantCount - 1))];
            }
            return ItemStack.field_190927_a;
        }

        public void scrollButton(int currentScrollAmount) {
            this.y = this.baseY - currentScrollAmount;
        }

        public void onClickButton() {
        }
    }
}

