/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.morered.client;

import com.github.commoble.morered.wire_post.SlackInterpolator;
import com.github.commoble.morered.wire_post.WirePostBlock;
import com.github.commoble.morered.wire_post.WirePostTileEntity;
import com.github.commoble.morered.wire_post.WireSpoolItem;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public class WirePostRenderer
extends TileEntityRenderer<WirePostTileEntity> {
    public WirePostRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public static int getRed(World world, BlockPos pos, BlockState state, float partialTicks) {
        int light = world.func_201696_r(pos);
        float celestialAngle = world.func_72929_e(partialTicks);
        if (light > 0) {
            float offset = celestialAngle < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            celestialAngle += (offset - celestialAngle) * 0.2f;
            light = Math.round((float)light * MathHelper.func_76134_b((float)celestialAngle));
        }
        light = Math.max(light, world.func_226658_a_(LightType.BLOCK, pos));
        light = MathHelper.func_76125_a((int)light, (int)0, (int)15);
        int power = state.func_196959_b((IProperty)WirePostBlock.POWER) ? (Integer)state.func_177229_b((IProperty)WirePostBlock.POWER) : 0;
        double lerpFactor = (double)power / 15.0;
        return (int)MathHelper.func_219803_d((double)lerpFactor, (double)86.0, (double)255.0) * light / 15;
    }

    public void render(WirePostTileEntity post, float partialTicks, MatrixStack matrices, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        BlockPos postPos = post.func_174877_v();
        Vec3d postVector = WirePostTileEntity.getConnectionVector(postPos);
        Set<BlockPos> connections = post.getRemoteConnections();
        World world = post.func_145831_w();
        BlockState postState = world.func_180495_p(postPos);
        IVertexBuilder vertexBuilder = buffer.getBuffer(RenderType.func_228659_m_());
        int postRed = WirePostRenderer.getRed(world, postPos, postState, partialTicks);
        for (BlockPos connectionPos : connections) {
            BlockState otherState = world.func_180495_p(connectionPos);
            int red = Math.min(postRed, WirePostRenderer.getRed(world, connectionPos, otherState, partialTicks));
            this.renderConnection(post, world, partialTicks, matrices, vertexBuilder, postVector, WirePostTileEntity.getConnectionVector(connectionPos), 0.0f, red);
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        for (Hand hand : Hand.values()) {
            float eyeHeight;
            double handZ;
            double handY;
            double handX;
            CompoundNBT nbt;
            ItemStack stack = player.func_184586_b(hand);
            if (!(stack.func_77973_b() instanceof WireSpoolItem) || (nbt = stack.func_179543_a("last_post_pos")) == null) continue;
            EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
            BlockPos positionOfCurrentPostOfPlayer = NBTUtil.func_186861_c((CompoundNBT)nbt);
            if (!positionOfCurrentPostOfPlayer.equals((Object)postPos)) continue;
            Vec3d vectorOfCurrentPostOfPlayer = new Vec3d((Vec3i)positionOfCurrentPostOfPlayer).func_72441_c(0.5, 0.5, 0.5);
            int handSideID = -(hand == Hand.MAIN_HAND ? -1 : 1) * (player.func_184591_cq() == HandSide.RIGHT ? 1 : -1);
            float swingProgress = player.func_70678_g(partialTicks);
            float swingZ = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
            float playerAngle = MathHelper.func_219799_g((float)partialTicks, (float)player.field_70760_ar, (float)player.field_70761_aq) * ((float)Math.PI / 180);
            double playerAngleX = MathHelper.func_76126_a((float)playerAngle);
            double playerAngleZ = MathHelper.func_76134_b((float)playerAngle);
            double handOffset = (double)handSideID * 0.35;
            double d3 = 0.8;
            if (renderManager.field_78733_k == null || renderManager.field_78733_k.field_74320_O <= 0) {
                double fov = renderManager.field_78733_k.field_74334_X;
                Vec3d handVector = new Vec3d(-0.14 + (double)handSideID * -0.36 * (fov /= 100.0), -0.12 + -0.045 * fov, 0.4);
                handVector = handVector.func_178789_a(-MathHelper.func_219799_g((float)partialTicks, (float)player.field_70127_C, (float)player.field_70125_A) * ((float)Math.PI / 180));
                handVector = handVector.func_178785_b(-MathHelper.func_219799_g((float)partialTicks, (float)player.field_70126_B, (float)player.field_70177_z) * ((float)Math.PI / 180));
                handVector = handVector.func_178785_b(swingZ * 0.5f);
                handVector = handVector.func_178789_a(-swingZ * 0.7f);
                handX = MathHelper.func_219803_d((double)partialTicks, (double)player.field_70169_q, (double)player.func_226277_ct_()) + handVector.field_72450_a;
                handY = MathHelper.func_219803_d((double)partialTicks, (double)player.field_70167_r, (double)player.func_226278_cu_()) + handVector.field_72448_b;
                handZ = MathHelper.func_219803_d((double)partialTicks, (double)player.field_70166_s, (double)player.func_226281_cx_()) + handVector.field_72449_c;
                eyeHeight = player.func_70047_e();
            } else {
                handX = MathHelper.func_219803_d((double)partialTicks, (double)player.field_70169_q, (double)player.func_226277_ct_()) - playerAngleZ * handOffset - playerAngleX * 0.8;
                handY = -0.2 + player.field_70167_r + (double)player.func_70047_e() + (player.func_226278_cu_() - player.field_70167_r) * (double)partialTicks - 0.45;
                handZ = MathHelper.func_219803_d((double)partialTicks, (double)player.field_70166_s, (double)player.func_226281_cx_()) - playerAngleX * handOffset + playerAngleZ * 0.8;
                eyeHeight = player.func_213453_ef() ? -0.1875f : 0.0f;
            }
            Vec3d renderPlayerVec = new Vec3d(handX, handY + (double)eyeHeight, handZ);
            this.renderConnection(post, world, partialTicks, matrices, vertexBuilder, vectorOfCurrentPostOfPlayer, renderPlayerVec, eyeHeight, postRed);
        }
    }

    private void renderConnection(WirePostTileEntity post, World world, float partialTicks, MatrixStack matrices, IVertexBuilder vertexBuilder, Vec3d startPos, Vec3d endPos, float eyeHeight, int red) {
        matrices.func_227860_a_();
        boolean translateSwap = false;
        if (startPos.func_82617_b() > endPos.func_82617_b()) {
            Vec3d swap = startPos;
            startPos = endPos;
            endPos = swap;
            translateSwap = true;
        }
        matrices.func_227861_a_(0.5, 0.5, 0.5);
        double startX = startPos.func_82615_a();
        double startY = startPos.func_82617_b();
        double startZ = startPos.func_82616_c();
        double endX = endPos.func_82615_a();
        double endY = endPos.func_82617_b();
        double endZ = endPos.func_82616_c();
        float dx = (float)(endX - startX);
        float dy = (float)(endY - startY);
        float dz = (float)(endZ - startZ);
        if (translateSwap) {
            matrices.func_227861_a_((double)(-dx), (double)(-dy), (double)(-dz));
        }
        Matrix4f fourMatrix = matrices.func_227866_c_().func_227870_a_();
        if (startY <= endY) {
            Vec3d[] pointList = SlackInterpolator.getInterpolatedDifferences(endPos.func_178788_d(startPos));
            int points = pointList.length;
            int lines = points - 1;
            for (int line = 0; line < lines; ++line) {
                Vec3d firstPoint = pointList[line];
                Vec3d secondPoint = pointList[line + 1];
                vertexBuilder.func_227888_a_(fourMatrix, (float)firstPoint.func_82615_a(), (float)firstPoint.func_82617_b(), (float)firstPoint.func_82616_c()).func_225586_a_(red, 0, 0, 255).func_181675_d();
                vertexBuilder.func_227888_a_(fourMatrix, (float)secondPoint.func_82615_a(), (float)secondPoint.func_82617_b(), (float)secondPoint.func_82616_c()).func_225586_a_(red, 0, 0, 255).func_181675_d();
            }
        }
        matrices.func_227865_b_();
    }

    public static void drawNextLineSegment(float x, float y, float z, IVertexBuilder vertexBuilder, Matrix4f fourMatrix, float lerp, float yLerp, int red) {
        vertexBuilder.func_227888_a_(fourMatrix, x * lerp, y * yLerp, z * lerp).func_225586_a_(red, 0, 0, 255).func_181675_d();
    }

    public static void spawnParticleFromTo(World world, Vec3d start, Vec3d end) {
        double lerp = world.field_73012_v.nextDouble();
        double x = MathHelper.func_219803_d((double)lerp, (double)start.func_82615_a(), (double)end.func_82615_a());
        double y = MathHelper.func_219803_d((double)lerp, (double)start.func_82617_b(), (double)end.func_82617_b());
        double z = MathHelper.func_219803_d((double)lerp, (double)start.func_82616_c(), (double)end.func_82616_c());
        world.func_195594_a((IParticleData)ParticleTypes.field_197624_q, x, y, z, 0.0, 0.0, 0.0);
    }

    public boolean isGlobalRenderer(WirePostTileEntity te) {
        return true;
    }
}

