/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.morered.client.jei;

import com.github.commoble.morered.ItemRegistrar;
import com.github.commoble.morered.MoreRed;
import com.github.commoble.morered.gatecrafting_plinth.GatecraftingRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class GatecraftingCategory
implements IRecipeCategory<GatecraftingRecipe> {
    public static final ResourceLocation ID = MoreRed.getModRL("gatecrafting");
    public static final ResourceLocation JEI_RECIPE_TEXTURE = new ResourceLocation("jei", "textures/gui/gui_vanilla.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;

    public GatecraftingCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ItemRegistrar.GATECRAFTING_PLINTH.get()));
        this.background = guiHelper.createDrawable(JEI_RECIPE_TEXTURE, 0, 60, 116, 54);
        this.localizedName = I18n.func_135052_a((String)"gui.morered.category.gatecrafting", (Object[])new Object[0]);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends GatecraftingRecipe> getRecipeClass() {
        return GatecraftingRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(GatecraftingRecipe recipe, IIngredients ingredients) {
        NonNullList inputs = recipe.func_192400_c();
        int maxItems = Math.min(inputs.size(), 9);
        ingredients.setInputIngredients(recipe.func_192400_c().subList(0, maxItems));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, GatecraftingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 94, 18);
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                int inputID = row * 3 + column + 1;
                guiItemStacks.init(inputID, true, column * 18, row * 18);
            }
        }
        guiItemStacks.set(ingredients);
    }
}

