/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.morered.client.jei;

import com.github.commoble.morered.ItemRegistrar;
import com.github.commoble.morered.RecipeRegistrar;
import com.github.commoble.morered.client.jei.GatecraftingCategory;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class JEIProxy
implements IModPlugin {
    public static final ResourceLocation ID = new ResourceLocation("morered", "morered");
    @Nullable
    private GatecraftingCategory gatecraftingCategory;

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.gatecraftingCategory = new GatecraftingCategory(registration.getJeiHelpers().getGuiHelper());
        registration.addRecipeCategories(new IRecipeCategory[]{this.gatecraftingCategory});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (this.gatecraftingCategory == null) {
            throw new NullPointerException("More Red's Gatecrafting JEI category failed to register! Notify the More Red author for assistance https://github.com/Commoble/morered/issues");
        }
        registration.addRecipes(JEIProxy.getGatecraftingRecipes(), GatecraftingCategory.ID);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ItemRegistrar.GATECRAFTING_PLINTH.get()), new ResourceLocation[]{GatecraftingCategory.ID});
    }

    public static List<IRecipe<CraftingInventory>> getGatecraftingRecipes() {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            RecipeManager manager = world.func_199532_z();
            return RecipeRegistrar.getAllGatecraftingRecipes(manager);
        }
        return ImmutableList.of();
    }
}

