/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.morered.gatecrafting_plinth;

import com.github.commoble.morered.BlockRegistrar;
import com.github.commoble.morered.ContainerRegistrar;
import com.github.commoble.morered.RecipeRegistrar;
import com.github.commoble.morered.gatecrafting_plinth.GatecraftingRecipe;
import com.github.commoble.morered.gatecrafting_plinth.GatecraftingResultSlot;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GatecraftingContainer
extends Container {
    public static final int OUTPUT_SLOT_ID = 0;
    public static final int FIRST_PLAYER_INVENTORY_SLOT_ID = 1;
    public static final int PLAYER_INVENTORY_SLOT_ROWS = 4;
    public static final int PLAYER_INVENTORY_SLOT_COLUMNS = 9;
    public static final int PLAYER_INVENTORY_SLOT_COUNT = 36;
    public static final int FIRST_PLAYER_INVENTORY_HOTBAR_SLOT_ID = 28;
    private final PlayerEntity player;
    private final IWorldPosCallable positionInWorld;
    public final CraftResultInventory craftResult = new CraftResultInventory();
    public Optional<IRecipe<CraftingInventory>> currentRecipe = Optional.empty();

    public static GatecraftingContainer getClientContainer(int id, PlayerInventory playerInventory) {
        return new GatecraftingContainer(id, playerInventory, BlockPos.field_177992_a);
    }

    public static IContainerProvider getServerContainerProvider(BlockPos pos) {
        return (id, playerInventory, theServerPlayer) -> new GatecraftingContainer(id, playerInventory, pos);
    }

    protected GatecraftingContainer(int id, PlayerInventory playerInventory, BlockPos pos) {
        super((ContainerType)ContainerRegistrar.GATECRAFTING.get(), id);
        this.player = playerInventory.field_70458_d;
        this.positionInWorld = IWorldPosCallable.func_221488_a((World)this.player.field_70170_p, (BlockPos)pos);
        this.func_75146_a(new GatecraftingResultSlot(this, (IInventory)this.craftResult, 0, 220, 38));
        for (int column = 0; column < 3; ++column) {
            for (int row = 0; row < 9; ++row) {
                this.func_75146_a(new Slot((IInventory)playerInventory, row + column * 9 + 9, 108 + row * 18, 84 + column * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)playerInventory, i, 108 + i * 18, 142));
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return GatecraftingContainer.func_216963_a((IWorldPosCallable)this.positionInWorld, (PlayerEntity)playerIn, (Block)((Block)BlockRegistrar.GATECRAFTING_PLINTH.get()));
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return false;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int slotIndex) {
        ItemStack copiedStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            copiedStack = stackInSlot.func_77946_l();
            if (slotIndex == 0) {
                if (!this.func_75135_a(stackInSlot, 1, 37, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(stackInSlot, copiedStack);
            } else if (slotIndex >= 1 && (slotIndex < 28 ? !this.func_75135_a(stackInSlot, 28, 37, false) : slotIndex >= 28 && slotIndex < 37 && !this.func_75135_a(stackInSlot, 1, 28, false))) {
                return ItemStack.field_190927_a;
            }
            if (stackInSlot.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stackInSlot.func_190916_E() == copiedStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, stackInSlot);
        }
        return copiedStack;
    }

    public void onPlayerChoseRecipe(ResourceLocation recipeID) {
        this.attemptRecipeAssembly(RecipeRegistrar.getGatecraftingRecipe(this.player.field_70170_p.func_199532_z(), recipeID));
    }

    public void attemptRecipeAssembly(Optional<IRecipe<CraftingInventory>> recipeHolder) {
        Optional<IRecipe<CraftingInventory>> filteredRecipe = recipeHolder.filter(recipe -> recipe.func_222127_g() == RecipeRegistrar.GATECRAFTING_RECIPE_TYPE && GatecraftingRecipe.doesPlayerHaveIngredients(this.player.field_71071_by, (IRecipe<CraftingInventory>)recipe));
        this.updateRecipeAndResult(filteredRecipe);
    }

    public void updateRecipeAndResult(Optional<IRecipe<CraftingInventory>> recipeHolder) {
        this.currentRecipe = recipeHolder;
        this.craftResult.func_70299_a(0, recipeHolder.map(recipe -> recipe.func_77571_b().func_77946_l()).orElse(ItemStack.field_190927_a));
    }
}

