/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.morered.gatecrafting_plinth;

import com.github.commoble.morered.gatecrafting_plinth.GatecraftingContainer;
import com.github.commoble.morered.gatecrafting_plinth.GatecraftingRecipe;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;

public class GatecraftingResultSlot
extends Slot {
    private final GatecraftingContainer container;

    public GatecraftingResultSlot(GatecraftingContainer container, IInventory resultInventory, int index, int xPosition, int yPosition) {
        super(resultInventory, index, xPosition, yPosition);
        this.container = container;
    }

    public boolean func_75214_a(ItemStack stack) {
        return false;
    }

    public ItemStack func_190901_a(PlayerEntity player, ItemStack stack) {
        this.func_75218_e();
        this.container.currentRecipe.ifPresent(recipe -> this.removeIngredients(player.field_71071_by, (IRecipe<CraftingInventory>)recipe));
        this.verifyRecipeAfterCrafting(player.field_71071_by, this.container.currentRecipe);
        return stack;
    }

    public boolean func_82869_a(PlayerEntity player) {
        return this.container.currentRecipe.map(recipe -> GatecraftingRecipe.doesPlayerHaveIngredients(player.field_71071_by, (IRecipe<CraftingInventory>)recipe)).orElse(false);
    }

    public void removeIngredients(PlayerInventory playerInventory, IRecipe<CraftingInventory> recipe) {
        NonNullList ingredients = recipe.func_192400_c();
        for (Ingredient ingredient : ingredients) {
            int remainingItemsToRemove = ingredient.func_193365_a()[0].func_190916_E();
            int playerSlots = playerInventory.func_70302_i_();
            for (int playerSlot = 0; playerSlot < playerSlots && remainingItemsToRemove > 0; ++playerSlot) {
                ItemStack stackInSlot = playerInventory.func_70301_a(playerSlot);
                if (!ingredient.test(stackInSlot)) continue;
                int decrementAmount = Math.min(remainingItemsToRemove, stackInSlot.func_190916_E());
                remainingItemsToRemove -= decrementAmount;
                playerInventory.func_70298_a(playerSlot, decrementAmount);
            }
        }
    }

    public void verifyRecipeAfterCrafting(PlayerInventory playerInventory, Optional<IRecipe<CraftingInventory>> recipeHolder) {
        Optional<IRecipe> remainingRecipe = recipeHolder.filter(recipe -> GatecraftingRecipe.doesPlayerHaveIngredients(playerInventory, (IRecipe<CraftingInventory>)recipe));
        this.func_75215_d(remainingRecipe.map(recipe -> recipe.func_77571_b().func_77946_l()).orElse(ItemStack.field_190927_a));
        this.container.currentRecipe = remainingRecipe;
    }
}

