/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.morered.plate_blocks;

import com.github.commoble.morered.plate_blocks.PlateBlockStateProperties;
import com.github.commoble.morered.util.BlockStateUtil;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public enum InputSide {
    A(PlateBlockStateProperties.INPUT_A, 1),
    B(PlateBlockStateProperties.INPUT_B, 2),
    C(PlateBlockStateProperties.INPUT_C, 3);

    public final BooleanProperty property;
    public final int rotationsFromOutput;

    private InputSide(BooleanProperty property, int rotationsFromOutput) {
        this.property = property;
        this.rotationsFromOutput = rotationsFromOutput;
    }

    public boolean isBlockReceivingPower(World world, BlockState state, BlockPos pos) {
        int baseRotation;
        if (!(state.func_196959_b((IProperty)this.property) && state.func_196959_b((IProperty)PlateBlockStateProperties.ATTACHMENT_DIRECTION) && state.func_196959_b((IProperty)PlateBlockStateProperties.ROTATION))) {
            return false;
        }
        Direction attachmentDirection = (Direction)state.func_177229_b((IProperty)PlateBlockStateProperties.ATTACHMENT_DIRECTION);
        Direction inputDirection = BlockStateUtil.getInputDirection(attachmentDirection, baseRotation = ((Integer)state.func_177229_b((IProperty)PlateBlockStateProperties.ROTATION)).intValue(), this.rotationsFromOutput);
        BlockPos inputPos = pos.func_177972_a(inputDirection);
        int power = world.func_175651_c(inputPos, inputDirection);
        if (power > 0) {
            return true;
        }
        BlockState inputState = world.func_180495_p(inputPos);
        return inputState.func_177230_c() == Blocks.field_150488_af && (Integer)inputState.func_177229_b((IProperty)RedstoneWireBlock.field_176351_O) > 0;
    }
}

