/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.morered.plate_blocks;

import com.github.commoble.morered.plate_blocks.InputSide;
import com.github.commoble.morered.plate_blocks.LogicFunction;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public enum InputState {
    FFF(false, false, false),
    FFT(false, false, true),
    FTF(false, true, false),
    FTT(false, true, true),
    TFF(true, false, false),
    TFT(true, false, true),
    TTF(true, true, false),
    TTT(true, true, true);

    public final boolean a;
    public final boolean b;
    public final boolean c;

    private InputState(boolean a, boolean b, boolean c) {
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public boolean getSideState(InputSide side) {
        switch (side) {
            case A: {
                return this.a;
            }
            case B: {
                return this.b;
            }
            case C: {
                return this.c;
            }
        }
        return false;
    }

    public boolean applyLogic(LogicFunction function) {
        return function.apply(this.a, this.b, this.c);
    }

    public static InputState getState(boolean a, boolean b, boolean c) {
        return InputState.values()[InputState.boolsToID(a, b, c)];
    }

    public static InputState getInput(BlockState state) {
        return InputState.getState(state.func_196959_b((IProperty)InputSide.A.property) ? (Boolean)state.func_177229_b((IProperty)InputSide.A.property) : false, state.func_196959_b((IProperty)InputSide.B.property) ? (Boolean)state.func_177229_b((IProperty)InputSide.B.property) : false, state.func_196959_b((IProperty)InputSide.C.property) ? (Boolean)state.func_177229_b((IProperty)InputSide.C.property) : false);
    }

    public static InputState getWorldPowerState(World world, BlockState state, BlockPos pos) {
        return InputState.getState(InputSide.A.isBlockReceivingPower(world, state, pos), InputSide.B.isBlockReceivingPower(world, state, pos), InputSide.C.isBlockReceivingPower(world, state, pos));
    }

    public static BlockState getUpdatedBlockState(World world, BlockState oldBlockState, BlockPos pos) {
        InputState newInputState;
        InputState oldInputState = InputState.getInput(oldBlockState);
        if (oldInputState == (newInputState = InputState.getWorldPowerState(world, oldBlockState, pos))) {
            return oldBlockState;
        }
        BlockState newBlockState = oldBlockState;
        for (InputSide side : InputSide.values()) {
            if (!newBlockState.func_196959_b((IProperty)side.property)) continue;
            newBlockState = (BlockState)newBlockState.func_206870_a((IProperty)side.property, (Comparable)Boolean.valueOf(newInputState.getSideState(side)));
        }
        return newBlockState;
    }

    public static int boolsToID(boolean a, boolean b, boolean c) {
        return (a ? 4 : 0) + (b ? 2 : 0) + (c ? 1 : 0);
    }
}

