/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.morered.plate_blocks;

import com.github.commoble.morered.plate_blocks.InputSide;
import com.github.commoble.morered.plate_blocks.InputState;
import com.github.commoble.morered.plate_blocks.PlateBlockStateProperties;
import com.github.commoble.morered.plate_blocks.RedstonePlateBlock;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class LatchBlock
extends RedstonePlateBlock {
    public static final DirectionProperty ATTACHMENT_DIRECTION = PlateBlockStateProperties.ATTACHMENT_DIRECTION;
    public static final IntegerProperty ROTATION = PlateBlockStateProperties.ROTATION;
    public static final BooleanProperty INPUT_A = PlateBlockStateProperties.INPUT_A;
    public static final BooleanProperty INPUT_C = PlateBlockStateProperties.INPUT_C;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final InputSide[] INPUT_SIDES = new InputSide[]{InputSide.A, InputSide.C};
    public static final int OUTPUT_STRENGTH = 15;
    public static final int TICK_DELAY = 1;

    public LatchBlock(Block.Properties properties) {
        super(properties);
        BlockState baseState = this.func_176223_P();
        this.func_180632_j((BlockState)((BlockState)((BlockState)baseState.func_206870_a((IProperty)INPUT_A, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)INPUT_C, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{INPUT_A, INPUT_C, POWERED});
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        if (((Boolean)state.func_177229_b((IProperty)INPUT_C)).booleanValue()) {
            state = (BlockState)state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Deprecated
    public int func_180656_a(BlockState state, IBlockReader blockAccess, BlockPos pos, Direction sideOfAdjacentBlock) {
        if (((Boolean)state.func_177229_b((IProperty)INPUT_A)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)INPUT_C)).booleanValue()) {
            return 0;
        }
        boolean powered = (Boolean)state.func_177229_b((IProperty)POWERED);
        Direction outputDirectionWhenPowered = PlateBlockStateProperties.getOutputDirection(state);
        return powered && sideOfAdjacentBlock == outputDirectionWhenPowered.func_176734_d() || !powered && sideOfAdjacentBlock == outputDirectionWhenPowered ? 15 : 0;
    }

    public void func_225534_a_(BlockState oldBlockState, ServerWorld world, BlockPos pos, Random rand) {
        BlockState stateWithNewInput = InputState.getUpdatedBlockState((World)world, oldBlockState, pos);
        InputState newInputState = InputState.getWorldPowerState((World)world, stateWithNewInput, pos);
        boolean wasPowered = (Boolean)oldBlockState.func_177229_b((IProperty)POWERED);
        boolean isPowered = wasPowered && !newInputState.c || !wasPowered && newInputState.a;
        BlockState newBlockState = (BlockState)stateWithNewInput.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(isPowered));
        if (newBlockState != oldBlockState) {
            world.func_180501_a(pos, newBlockState, 2);
        }
    }

    @Override
    public InputSide[] getInputSides() {
        return INPUT_SIDES;
    }

    @Override
    public void notifyNeighbors(World world, BlockPos pos, BlockState state) {
        Direction primaryDirection = PlateBlockStateProperties.getOutputDirection(state);
        Direction oppositeDirection = primaryDirection.func_176734_d();
        EnumSet<Direction> outputDirections = EnumSet.of(primaryDirection, oppositeDirection);
        if (!ForgeEventFactory.onNeighborNotify((World)world, (BlockPos)pos, (BlockState)world.func_180495_p(pos), outputDirections, (boolean)false).isCanceled()) {
            for (Direction outputDirection : outputDirections) {
                BlockPos outputPos = pos.func_177972_a(outputDirection);
                world.func_190524_a(outputPos, (Block)this, pos);
                world.func_175695_a(outputPos, (Block)this, outputDirection);
            }
        }
    }
}

