/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.morered.plate_blocks;

import com.github.commoble.morered.plate_blocks.InputSide;
import com.github.commoble.morered.plate_blocks.InputState;
import com.github.commoble.morered.plate_blocks.LogicFunction;
import com.github.commoble.morered.plate_blocks.PlateBlockStateProperties;
import com.github.commoble.morered.plate_blocks.RedstonePlateBlock;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class LogicFunctionPlateBlock
extends RedstonePlateBlock {
    public static final DirectionProperty ATTACHMENT_DIRECTION = PlateBlockStateProperties.ATTACHMENT_DIRECTION;
    public static final IntegerProperty ROTATION = PlateBlockStateProperties.ROTATION;
    public static final int OUTPUT_STRENGTH = 15;
    public static final int TICK_DELAY = 1;
    public static final LogicFunctionPlateBlockFactory THREE_INPUTS = LogicFunctionPlateBlock.getBlockFactory(InputSide.A, InputSide.B, InputSide.C);
    public static final LogicFunctionPlateBlockFactory T_INPUTS = LogicFunctionPlateBlock.getBlockFactory(InputSide.A, InputSide.C);
    public static final LogicFunctionPlateBlockFactory LINEAR_INPUT = LogicFunctionPlateBlock.getBlockFactory(InputSide.B);
    private final LogicFunction function;

    public static LogicFunctionPlateBlockFactory getBlockFactory(final InputSide ... inputs) {
        return (properties, function) -> new LogicFunctionPlateBlock(function, properties){

            @Override
            public InputSide[] getInputSides() {
                return inputs;
            }
        };
    }

    public LogicFunctionPlateBlock(Block.Properties properties, LogicFunction function) {
        super(properties);
        this.function = function;
        BlockState baseState = this.func_176223_P();
        for (InputSide side : this.getInputSides()) {
            baseState = (BlockState)baseState.func_206870_a((IProperty)side.property, (Comparable)Boolean.valueOf(false));
        }
        this.func_180632_j(baseState);
    }

    @Override
    public abstract InputSide[] getInputSides();

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        for (InputSide side : this.getInputSides()) {
            builder.func_206894_a(new IProperty[]{side.property});
        }
    }

    @Deprecated
    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction sideOfAdjacentBlock) {
        if (InputState.getInput(blockState).applyLogic(this.function) && PlateBlockStateProperties.getOutputDirection(blockState) == sideOfAdjacentBlock.func_176734_d()) {
            return 15;
        }
        return 0;
    }

    public void func_225534_a_(BlockState oldBlockState, ServerWorld world, BlockPos pos, Random rand) {
        BlockState newBlockState = InputState.getUpdatedBlockState((World)world, oldBlockState, pos);
        if (newBlockState != oldBlockState) {
            world.func_180501_a(pos, newBlockState, 2);
        }
    }

    @Override
    public void notifyNeighbors(World world, BlockPos pos, BlockState state) {
        Direction outputDirection = PlateBlockStateProperties.getOutputDirection(state);
        BlockPos outputPos = pos.func_177972_a(outputDirection);
        if (!ForgeEventFactory.onNeighborNotify((World)world, (BlockPos)pos, (BlockState)world.func_180495_p(pos), EnumSet.of(outputDirection), (boolean)false).isCanceled()) {
            world.func_190524_a(outputPos, (Block)this, pos);
            world.func_175695_a(outputPos, (Block)this, outputDirection);
        }
    }

    @FunctionalInterface
    public static interface LogicFunctionPlateBlockFactory {
        public LogicFunctionPlateBlock makeBlock(LogicFunction var1, Block.Properties var2);
    }
}

