/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.morered.plate_blocks;

import com.github.commoble.morered.ItemRegistrar;
import com.github.commoble.morered.plate_blocks.LogicFunction;
import com.github.commoble.morered.plate_blocks.LogicFunctionPlateBlock;
import com.github.commoble.morered.plate_blocks.LogicFunctions;
import com.github.commoble.morered.plate_blocks.PlateBlockStateProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;

public class LogicGateType {
    public static final Map<ResourceLocation, LogicGateType> TYPES = new HashMap<ResourceLocation, LogicGateType>();
    public final Supplier<LogicFunctionPlateBlock> blockGetter;
    public final Supplier<BlockItem> itemGetter;

    public LogicGateType(Supplier<LogicFunctionPlateBlock> blockGetter, Supplier<BlockItem> itemGetter) {
        this.blockGetter = blockGetter;
        this.itemGetter = itemGetter;
    }

    public static void registerLogicGateType(String name, DeferredRegister<Block> blocks, DeferredRegister<Item> items, LogicFunction function, LogicFunctionPlateBlock.LogicFunctionPlateBlockFactory inputs) {
        LogicGateType.registerLogicGateType("morered", name, blocks, items, function, inputs);
    }

    public static void registerLogicGateType(String modid, String name, DeferredRegister<Block> blocks, DeferredRegister<Item> items, LogicFunction function, LogicFunctionPlateBlock.LogicFunctionPlateBlockFactory factory) {
        ResourceLocation id = new ResourceLocation(modid, name);
        RegistryObject<LogicFunctionPlateBlock> blockGetter = LogicGateType.registerLogicGate(blocks, name, function, factory);
        RegistryObject<BlockItem> itemGetter = LogicGateType.registerBlockItem(items, name, blockGetter);
        TYPES.put(id, new LogicGateType((Supplier<LogicFunctionPlateBlock>)blockGetter, (Supplier<BlockItem>)itemGetter));
    }

    private static RegistryObject<LogicFunctionPlateBlock> registerLogicGate(DeferredRegister<Block> blocks, String name, LogicFunction function, LogicFunctionPlateBlock.LogicFunctionPlateBlockFactory factory) {
        return blocks.register(name, () -> factory.makeBlock(function, Block.Properties.func_200945_a((Material)PlateBlockStateProperties.PLATE_MATERIAL).func_200943_b(0.0f).func_200947_a(SoundType.field_185848_a)));
    }

    private static final RegistryObject<BlockItem> registerBlockItem(DeferredRegister<Item> items, String name, Supplier<? extends Block> blockGetter) {
        return items.register(name, () -> new BlockItem((Block)blockGetter.get(), new Item.Properties().func_200916_a(ItemRegistrar.CREATIVE_TAB)));
    }

    public static void registerLogicGateTypes(DeferredRegister<Block> blocks, DeferredRegister<Item> items) {
        LogicGateType.registerLogicGateType("diode", blocks, items, LogicFunctions.INPUT_B, LogicFunctionPlateBlock.LINEAR_INPUT);
        LogicGateType.registerLogicGateType("not_gate", blocks, items, LogicFunctions.NOT_B, LogicFunctionPlateBlock.LINEAR_INPUT);
        LogicGateType.registerLogicGateType("nor_gate", blocks, items, LogicFunctions.NOR, LogicFunctionPlateBlock.THREE_INPUTS);
        LogicGateType.registerLogicGateType("nand_gate", blocks, items, LogicFunctions.NAND, LogicFunctionPlateBlock.THREE_INPUTS);
        LogicGateType.registerLogicGateType("or_gate", blocks, items, LogicFunctions.OR, LogicFunctionPlateBlock.THREE_INPUTS);
        LogicGateType.registerLogicGateType("and_gate", blocks, items, LogicFunctions.AND, LogicFunctionPlateBlock.THREE_INPUTS);
        LogicGateType.registerLogicGateType("xor_gate", blocks, items, LogicFunctions.XOR_AC, LogicFunctionPlateBlock.T_INPUTS);
        LogicGateType.registerLogicGateType("xnor_gate", blocks, items, LogicFunctions.XNOR_AC, LogicFunctionPlateBlock.T_INPUTS);
        LogicGateType.registerLogicGateType("multiplexer", blocks, items, LogicFunctions.MULTIPLEX, LogicFunctionPlateBlock.THREE_INPUTS);
        LogicGateType.registerLogicGateType("and_2_gate", blocks, items, LogicFunctions.AND_2, LogicFunctionPlateBlock.T_INPUTS);
        LogicGateType.registerLogicGateType("nand_2_gate", blocks, items, LogicFunctions.NAND_2, LogicFunctionPlateBlock.T_INPUTS);
    }
}

