/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.morered.plate_blocks;

import com.github.commoble.morered.util.BlockStateUtil;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class PlateBlockStateProperties {
    public static final DirectionProperty ATTACHMENT_DIRECTION = BlockStateProperties.field_208155_H;
    public static final IntegerProperty ROTATION = IntegerProperty.func_177719_a((String)"rotation", (int)0, (int)3);
    public static final BooleanProperty INPUT_A = BooleanProperty.func_177716_a((String)"input_a");
    public static final BooleanProperty INPUT_B = BooleanProperty.func_177716_a((String)"input_b");
    public static final BooleanProperty INPUT_C = BooleanProperty.func_177716_a((String)"input_c");
    public static final Material PLATE_MATERIAL = new Material(MaterialColor.field_151665_m, false, false, false, false, true, false, false, PushReaction.NORMAL);

    public static Direction getOutputDirection(BlockState state) {
        if (!state.func_196959_b((IProperty)ATTACHMENT_DIRECTION) || !state.func_196959_b((IProperty)ROTATION)) {
            return Direction.DOWN;
        }
        Direction attachmentDirection = (Direction)state.func_177229_b((IProperty)ATTACHMENT_DIRECTION);
        int rotationIndex = (Integer)state.func_177229_b((IProperty)ROTATION);
        return BlockStateUtil.getOutputDirection(attachmentDirection, rotationIndex);
    }

    public static BlockState getStateForPlacedGatePlate(BlockState state, BlockItemUseContext context) {
        BlockPos placePos = context.func_195995_a();
        Direction faceOfAdjacentBlock = context.func_196000_l();
        Direction directionTowardAdjacentBlock = faceOfAdjacentBlock.func_176734_d();
        Vec3d relativeHitVec = context.func_221532_j().func_178788_d(new Vec3d((Vec3i)placePos));
        return PlateBlockStateProperties.getStateForPlacedGatePlate(state, placePos, directionTowardAdjacentBlock, relativeHitVec);
    }

    public static BlockState getStateForPlacedGatePlate(BlockState state, BlockPos placePos, Direction directionTowardAdjacentBlock, Vec3d relativeHitVec) {
        Direction outputDirection = BlockStateUtil.getOutputDirectionFromRelativeHitVec(relativeHitVec, directionTowardAdjacentBlock);
        int rotationIndex = BlockStateUtil.getRotationIndexForDirection(directionTowardAdjacentBlock, outputDirection);
        if (state.func_196959_b((IProperty)ATTACHMENT_DIRECTION) && state.func_196959_b((IProperty)ROTATION)) {
            return (BlockState)((BlockState)state.func_206870_a((IProperty)ATTACHMENT_DIRECTION, (Comparable)directionTowardAdjacentBlock)).func_206870_a((IProperty)ROTATION, (Comparable)Integer.valueOf(rotationIndex));
        }
        return state;
    }
}

