/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.morered.plate_blocks;

import com.github.commoble.morered.plate_blocks.InputSide;
import com.github.commoble.morered.plate_blocks.InputState;
import com.github.commoble.morered.plate_blocks.PlateBlock;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;

public abstract class RedstonePlateBlock
extends PlateBlock {
    public static final int OUTPUT_STRENGTH = 15;
    public static final int TICK_DELAY = 1;
    public static final ItemTags.Wrapper STICK = new ItemTags.Wrapper(new ResourceLocation("forge:rods/wooden"));

    public RedstonePlateBlock(Block.Properties properties) {
        super(properties);
    }

    public abstract InputSide[] getInputSides();

    public abstract void notifyNeighbors(World var1, BlockPos var2, BlockState var3);

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (this.hasInputPower(worldIn, state, pos)) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 1);
        }
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = super.func_196258_a(context);
        for (InputSide side : this.getInputSides()) {
            state = (BlockState)state.func_206870_a((IProperty)side.property, (Comparable)Boolean.valueOf(side.isBlockReceivingPower(world, state, pos)));
        }
        return state;
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        boolean isPlayerHoldingStick = STICK.func_199685_a_(player.func_184586_b(handIn).func_77973_b());
        if (isPlayerHoldingStick && !worldIn.field_72995_K) {
            int newRotation = ((Integer)state.func_177229_b((IProperty)ROTATION) + 1) % 4;
            BlockState newState = (BlockState)state.func_206870_a((IProperty)ROTATION, (Comparable)Integer.valueOf(newRotation));
            for (InputSide side : this.getInputSides()) {
                newState = (BlockState)newState.func_206870_a((IProperty)side.property, (Comparable)Boolean.valueOf(side.isBlockReceivingPower(worldIn, newState, pos)));
            }
            worldIn.func_175656_a(pos, newState);
        }
        return isPlayerHoldingStick ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    @Deprecated
    public boolean func_149744_f(BlockState state) {
        return true;
    }

    @Deprecated
    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return blockState.func_185911_a(blockAccess, pos, side);
    }

    @Deprecated
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
        this.notifyNeighbors(worldIn, pos, state);
    }

    @Deprecated
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            this.notifyNeighbors(worldIn, pos, state);
        }
    }

    @Deprecated
    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        InputState oldInputState = InputState.getInput(state);
        InputState newInputState = InputState.getWorldPowerState(worldIn, state, pos);
        if (oldInputState != newInputState && !worldIn.func_205220_G_().func_205361_b(pos, (Object)this)) {
            worldIn.func_205220_G_().func_205362_a(pos, (Object)this, 1, TickPriority.HIGH);
        }
    }

    public boolean hasInputPower(World world, BlockState state, BlockPos pos) {
        for (InputSide side : this.getInputSides()) {
            if (!side.isBlockReceivingPower(world, state, pos)) continue;
            return true;
        }
        return false;
    }
}

