/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.morered.util;

import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.Vec3d;

public class BlockStateUtil {
    public static final Direction[][] OUTPUT_TABLE = new Direction[][]{{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST}, {Direction.NORTH, Direction.WEST, Direction.SOUTH, Direction.EAST}, {Direction.UP, Direction.EAST, Direction.DOWN, Direction.WEST}, {Direction.UP, Direction.WEST, Direction.DOWN, Direction.EAST}, {Direction.UP, Direction.NORTH, Direction.DOWN, Direction.SOUTH}, {Direction.UP, Direction.SOUTH, Direction.DOWN, Direction.NORTH}};

    public static Direction getOutputDirection(Direction attachmentDirection, int rotationIndex) {
        return OUTPUT_TABLE[attachmentDirection.ordinal()][rotationIndex];
    }

    public static Direction getInputDirection(Direction attachmentDirection, int outputRotationIndex, int rotationsFromOutput) {
        return BlockStateUtil.getOutputDirection(attachmentDirection, (outputRotationIndex + rotationsFromOutput) % 4);
    }

    public static int getRotatedRotation(Direction attachmentFace, int rotationIndex, Rotation rotation) {
        if (attachmentFace == Direction.DOWN) {
            return (rotationIndex + rotation.ordinal()) % 4;
        }
        if (attachmentFace == Direction.UP) {
            return (rotationIndex + 4 - rotation.ordinal()) % 4;
        }
        return rotationIndex;
    }

    public static int getMirroredRotation(Direction attachmentFace, int rotationIndex, Mirror mirror) {
        boolean rotationIsEven;
        if (mirror == Mirror.NONE) {
            return rotationIndex;
        }
        boolean specialCase = mirror == Mirror.LEFT_RIGHT && attachmentFace.func_176740_k() == Direction.Axis.Y;
        boolean bl = rotationIsEven = rotationIndex % 2 == 0;
        if (specialCase && rotationIsEven || !specialCase && !rotationIsEven) {
            return (rotationIndex + 2) % 4;
        }
        return rotationIndex;
    }

    public static int getRotationIndexForDirection(Direction attachmentFace, Direction outputDirection) {
        Direction[] rotatedOutputs = OUTPUT_TABLE[attachmentFace.ordinal()];
        int size = rotatedOutputs.length;
        for (int i = 0; i < size; ++i) {
            if (rotatedOutputs[i] != outputDirection) continue;
            return i;
        }
        return 0;
    }

    public static Direction getOutputDirectionFromRelativeHitVec(Vec3d hitVec, Direction directionTowardBlockAttachedTo) {
        Direction.Axis axis = directionTowardBlockAttachedTo.func_176740_k();
        float x = (float)(axis == Direction.Axis.X ? 0.0 : hitVec.field_72450_a * 2.0 - 1.0);
        float y = (float)(axis == Direction.Axis.Y ? 0.0 : hitVec.field_72448_b * 2.0 - 1.0);
        float z = (float)(axis == Direction.Axis.Z ? 0.0 : hitVec.field_72449_c * 2.0 - 1.0);
        return Direction.func_176737_a((float)x, (float)y, (float)z);
    }
}

