/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.morered.wire_post;

import com.github.commoble.morered.ServerConfig;
import com.github.commoble.morered.wire_post.IPostsInChunk;
import com.github.commoble.morered.wire_post.PostsInChunkCapability;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PostsInChunk
implements IPostsInChunk,
ICapabilityProvider,
INBTSerializable<CompoundNBT> {
    private final LazyOptional<IPostsInChunk> holder = LazyOptional.of(() -> this);
    private Set<BlockPos> positions = new HashSet<BlockPos>();

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == PostsInChunkCapability.INSTANCE) {
            return PostsInChunkCapability.INSTANCE.orEmpty(cap, this.holder);
        }
        return LazyOptional.empty();
    }

    @Override
    public Set<BlockPos> getPositions() {
        return this.positions;
    }

    @Override
    public void setPositions(Set<BlockPos> set) {
        this.positions = set;
    }

    public CompoundNBT serializeNBT() {
        return (CompoundNBT)PostsInChunkCapability.INSTANCE.getStorage().writeNBT(PostsInChunkCapability.INSTANCE, (Object)this, null);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        PostsInChunkCapability.INSTANCE.getStorage().readNBT(PostsInChunkCapability.INSTANCE, (Object)this, null, (INBT)nbt);
    }

    public static Set<ChunkPos> getRelevantChunkPositionsNearPos(BlockPos pos) {
        double range = ServerConfig.INSTANCE.max_wire_post_connection_range.get();
        ChunkPos chunkPos = new ChunkPos(pos);
        int chunkRange = (int)Math.ceil(range / 16.0);
        HashSet<ChunkPos> set = new HashSet<ChunkPos>();
        for (int xOff = -chunkRange; xOff <= chunkRange; ++xOff) {
            for (int zOff = -chunkRange; zOff <= chunkRange; ++zOff) {
                set.add(new ChunkPos(chunkPos.field_77276_a + xOff, chunkPos.field_77275_b + zOff));
            }
        }
        return set;
    }
}

